/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.tableviewer;

import org.eclipse.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TableCheckBoxCellEditor
extends CheckboxCellEditor {
    private static final int defaultStyle = 32;
    private Button _check;
    protected AccessibleTableViewer _accessibleTableViewer;

    public TableCheckBoxCellEditor(AccessibleTableViewer accessibleTableViewer, int style) {
        super((Composite)accessibleTableViewer.getTable(), style);
        this._accessibleTableViewer = accessibleTableViewer;
    }

    public TableCheckBoxCellEditor(AccessibleTableViewer accessibleTableViewer) {
        this(accessibleTableViewer, 32);
    }

    protected Control createControl(Composite parent) {
        this._check = new Button(parent, this.getStyle());
        this._check.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                TableCheckBoxCellEditor.this.focusLost();
            }
        });
        this._check.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TableCheckBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this._check.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                TableCheckBoxCellEditor.this.handleTraverse(event);
            }
        });
        return this._check;
    }

    public void activate() {
    }

    protected Object doGetValue() {
        return this._check.getSelection();
    }

    protected void doSetValue(Object value) {
        if (!(value instanceof Boolean)) {
            return;
        }
        super.doSetValue(value);
        Boolean boolValue = (Boolean)value;
        this._check.setSelection(boolValue.booleanValue());
    }

    protected void handleTraverse(TraverseEvent e) {
        if (e.detail == 8 || e.detail == 16) {
            this.fireApplyEditorValue();
            this.deactivate();
            this._accessibleTableViewer.getCursor().handleTraverse(e);
            this._accessibleTableViewer.getCursor().edit();
        } else if (e.detail == 2) {
            e.doit = false;
            this.fireCancelEditor();
            this.deactivate();
            this._accessibleTableViewer.setTableItemImage();
        } else if (e.detail == 4) {
            e.doit = false;
            this.fireApplyEditorValue();
            this.deactivate();
        }
    }
}

