/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.Position;

public class AcceleoDocument
extends Document {
    private ReadWriteLock positionsLock = new ReentrantReadWriteLock();
    private Lock positionsReadLock = this.positionsLock.readLock();
    private Lock positionsWriteLock = this.positionsLock.writeLock();

    public Position[] getPositions(String category, int offset, int length, boolean canStartBefore, boolean canEndAfter) throws BadPositionCategoryException {
        this.positionsReadLock.lock();
        try {
            Position[] positionArray = super.getPositions(category, offset, length, canStartBefore, canEndAfter);
            return positionArray;
        }
        finally {
            this.positionsReadLock.unlock();
        }
    }

    public Position[] getPositions(String category) throws BadPositionCategoryException {
        this.positionsReadLock.lock();
        try {
            Position[] positionArray = super.getPositions(category);
            return positionArray;
        }
        finally {
            this.positionsReadLock.unlock();
        }
    }

    public void addPosition(Position position) throws BadLocationException {
        this.positionsWriteLock.lock();
        try {
            super.addPosition(position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    public void addPosition(String category, Position position) throws BadLocationException, BadPositionCategoryException {
        this.positionsWriteLock.lock();
        try {
            super.addPosition(category, position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    public void removePosition(Position position) {
        this.positionsWriteLock.lock();
        try {
            super.removePosition(position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }

    public void removePosition(String category, Position position) throws BadPositionCategoryException {
        this.positionsWriteLock.lock();
        try {
            super.removePosition(category, position);
        }
        finally {
            this.positionsWriteLock.unlock();
        }
    }
}

