/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.pdom;

import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMLinkage;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMProperty;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQEnum;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQGadget;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQMethod;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQObject;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQmlRegistration;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQmlUncreatable;
import org.eclipse.core.runtime.CoreException;

public enum QtPDOMNodeType {
    QObject,
    QEnum,
    QProperty,
    QMethod,
    QGadget,
    QmlTypeRegistration,
    QmlUncreatableRegistration;

    public final int Type = 6 + this.ordinal();
    public static final int VERSION = 3;

    public static QtPDOMNodeType forType(int version, int type) {
        QtPDOMNodeType[] qtPDOMNodeTypeArray = QtPDOMNodeType.values();
        int n = qtPDOMNodeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            QtPDOMNodeType node = qtPDOMNodeTypeArray[n2];
            if (node.Type == type) {
                return node;
            }
            ++n2;
        }
        return null;
    }

    public static PDOMNode load(QtPDOMLinkage linkage, int nodeType, long record) throws CoreException {
        QtPDOMNodeType node = QtPDOMNodeType.forType(linkage.getVersion(), nodeType);
        if (node == null) {
            return null;
        }
        switch (node) {
            case QObject: {
                return new QtPDOMQObject(linkage, record);
            }
            case QEnum: {
                return new QtPDOMQEnum(linkage, record);
            }
            case QProperty: {
                return new QtPDOMProperty(linkage, record);
            }
            case QMethod: {
                return new QtPDOMQMethod(linkage, record);
            }
            case QGadget: {
                return new QtPDOMQGadget(linkage, record);
            }
            case QmlTypeRegistration: {
                return new QtPDOMQmlRegistration(linkage, record);
            }
            case QmlUncreatableRegistration: {
                return new QtPDOMQmlUncreatable(linkage, record);
            }
        }
        return null;
    }
}

