/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.pdom;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.qt.core.ASTUtil;
import org.eclipse.cdt.internal.qt.core.pdom.AbstractQClassName;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMBinding;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMLinkage;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQObject;
import org.eclipse.cdt.internal.qt.core.pdom.QtPropertyName;
import org.eclipse.core.runtime.CoreException;

public class QObjectName
extends AbstractQClassName {
    private final char[] fullyQualifiedName;
    private final List<QtPropertyName> properties = new ArrayList<QtPropertyName>();
    private final Map<String, String> classInfos = new LinkedHashMap<String, String>();

    public QObjectName(ICPPASTCompositeTypeSpecifier spec) {
        super(spec);
        String fqn = ASTUtil.getFullyQualifiedName(spec.getName());
        this.fullyQualifiedName = fqn == null ? new char[]{} : fqn.toCharArray();
    }

    @Override
    public char[] getSimpleID() {
        return this.fullyQualifiedName;
    }

    public List<QtPropertyName> getProperties() {
        return this.properties;
    }

    public void addProperty(QtPropertyName property) {
        this.properties.add(property);
    }

    public Map<String, String> getClassInfos() {
        return this.classInfos;
    }

    public String addClassInfo(String key, String value) {
        return this.classInfos.put(key, value);
    }

    @Override
    protected QtPDOMBinding createPDOMBinding(QtPDOMLinkage linkage, IASTName name) throws CoreException {
        return new QtPDOMQObject(linkage, this, name);
    }

    @Override
    protected IASTName copy(IASTNode.CopyStyle style, ICPPASTCompositeTypeSpecifier spec) {
        return new QObjectName(spec);
    }
}

