/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.commands;

import java.util.List;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.commands.AddBaseParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddFaultCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDTypeDefinition;

public class AddFaultParameterCommand
extends AddBaseParameterCommand {
    protected Fault fault;
    private String faultName;

    public static int getParameterPatternForFault(Operation operation, Fault fault) {
        int pattern = -1;
        if (fault != null) {
            pattern = AddFaultParameterCommand.getPattern(fault.getEMessage());
        }
        if (pattern == -1) {
            pattern = AddBaseParameterCommand.getParameterPattern((WSDLElement)operation);
        }
        return pattern;
    }

    private static int getPattern(Message message) {
        int pattern = -1;
        if (message != null) {
            for (Part part : message.getEParts()) {
                if (part.getElementDeclaration() != null) {
                    pattern = AddBaseParameterCommand.PART_ELEMENT;
                    XSDElementDeclaration xsdElement = part.getElementDeclaration();
                    if (!AddFaultParameterCommand.isSequencePattern(xsdElement.getTypeDefinition())) break;
                    pattern = AddBaseParameterCommand.PART_ELEMENT_SEQ_ELEMENT;
                    break;
                }
                if (part.getTypeDefinition() == null) continue;
                pattern = AddBaseParameterCommand.PART_SIMPLETYPE;
                if (!(part.getTypeDefinition() instanceof XSDComplexTypeDefinition)) break;
                pattern = AddBaseParameterCommand.PART_COMPLEXTYPE;
                XSDComplexTypeDefinition xsdType = (XSDComplexTypeDefinition)part.getTypeDefinition();
                if (!AddFaultParameterCommand.isSequencePattern((XSDTypeDefinition)xsdType)) break;
                pattern = AddBaseParameterCommand.PART_COMPLEXTYPE_SEQ_ELEMENT;
                break;
            }
        }
        return pattern;
    }

    private static boolean isSequencePattern(XSDTypeDefinition type) {
        XSDParticle particle;
        XSDComplexTypeDefinition complexType;
        boolean isSequencePattern = false;
        if (type instanceof XSDComplexTypeDefinition && (complexType = (XSDComplexTypeDefinition)type).getContent() instanceof XSDParticle && (particle = (XSDParticle)complexType.getContent()).getContent() instanceof XSDModelGroup) {
            isSequencePattern = true;
        }
        return isSequencePattern;
    }

    public AddFaultParameterCommand(Operation operation, Fault fault) {
        super(operation, AddBaseParameterCommand.PART_ELEMENT);
        this.fault = fault;
    }

    @Override
    public void run() {
        Part part;
        if (this.fault == null) {
            AddFaultCommand command = new AddFaultCommand(this.operation, this.getFaultName());
            command.run();
            this.fault = (Fault)command.getWSDLElement();
        }
        this.newPart = part = this.createWSDLComponents((MessageReference)this.fault);
        this.newXSDElement = this.createXSDObjects(part);
    }

    @Override
    protected String getAnonymousXSDElementBaseName() {
        if (this.newAnonymousXSDElementName == null) {
            this.newAnonymousXSDElementName = String.valueOf(this.operation.getName()) + NameUtil.buildFirstCharUppercaseName(this.faultName);
        }
        return this.newAnonymousXSDElementName;
    }

    @Override
    protected String getNewXSDElementBaseName() {
        if (this.newXSDElementName == null) {
            this.newXSDElementName = String.valueOf(this.operation.getName()) + NameUtil.buildFirstCharUppercaseName(this.faultName);
        }
        return this.newXSDElementName;
    }

    @Override
    protected String getWSDLMessageName() {
        if (this.newWSDLMessageName == null) {
            this.newWSDLMessageName = String.valueOf(this.operation.getName()) + NameUtil.buildFirstCharUppercaseName(this.faultName);
            List usedNames = NameUtil.getUsedMessageNames(this.operation.getEnclosingDefinition());
            this.newWSDLMessageName = NameUtil.getUniqueNameHelper(this.newWSDLMessageName, usedNames);
        }
        return this.newWSDLMessageName;
    }

    @Override
    protected String getWSDLPartName() {
        if (this.newWSDLPartName == null) {
            this.newWSDLPartName = this.getFaultName();
        }
        return this.newWSDLPartName;
    }

    private String getFaultName() {
        if (this.faultName == null) {
            this.faultName = this.fault != null ? this.fault.getName() : NameUtil.getFaultName(this.operation);
        }
        return this.faultName;
    }

    @Override
    public MessageReference getMessageReference() {
        return this.fault;
    }
}

