import { FoldingRange } from 'vscode-json-languageservice';
import { CodeAction, CodeActionParams, CompletionList, DidChangeWatchedFilesParams, DocumentFormattingParams, DocumentLink, DocumentLinkParams, DocumentOnTypeFormattingParams, DocumentSymbolParams, FoldingRangeParams, Connection, TextDocumentPositionParams } from 'vscode-languageserver';
import { DocumentSymbol, Hover, SymbolInformation, TextEdit } from 'vscode-languageserver-types';
import { LanguageService } from '../../languageservice/yamlLanguageService';
import { SettingsState } from '../../yamlSettings';
import { ValidationHandler } from './validationHandlers';
export declare class LanguageHandlers {
    private readonly connection;
    private languageService;
    private yamlSettings;
    private validationHandler;
    constructor(connection: Connection, languageService: LanguageService, yamlSettings: SettingsState, validationHandler: ValidationHandler);
    registerHandlers(): void;
    documentLinkHandler(params: DocumentLinkParams): Promise<DocumentLink[]>;
    /**
     * Called when the code outline in an editor needs to be populated
     * Returns a list of symbols that is then shown in the code outline
     */
    documentSymbolHandler(documentSymbolParams: DocumentSymbolParams): DocumentSymbol[] | SymbolInformation[];
    /**
     * Called when the formatter is invoked
     * Returns the formatted document content using prettier
     */
    formatterHandler(formatParams: DocumentFormattingParams): TextEdit[];
    formatOnTypeHandler(params: DocumentOnTypeFormattingParams): Promise<TextEdit[] | undefined> | TextEdit[] | undefined;
    /**
     * Called when the user hovers with their mouse over a keyword
     * Returns an informational tooltip
     */
    hoverHandler(textDocumentPositionParams: TextDocumentPositionParams): Promise<Hover>;
    /**
     * Called when auto-complete is triggered in an editor
     * Returns a list of valid completion items
     */
    completionHandler(textDocumentPosition: TextDocumentPositionParams): Promise<CompletionList>;
    /**
     * Called when a monitored file is changed in an editor
     * Re-validates the entire document
     */
    watchedFilesHandler(change: DidChangeWatchedFilesParams): void;
    foldingRangeHandler(params: FoldingRangeParams): Promise<FoldingRange[] | undefined> | FoldingRange[] | undefined;
    codeActionHandler(params: CodeActionParams): CodeAction[] | undefined;
}
