/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineLifecycleListener;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineManager;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineOptions;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexObjectFilter;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexResourceFilter;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.EngineError;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class ViatraQueryEngineContentProvider implements ITreeContentProvider {
  private static class EngineListener implements ViatraQueryEngineLifecycleListener {
    private final TreeViewer viewer;
    
    private final AdvancedViatraQueryEngine engine;
    
    private boolean disposed = false;
    
    public EngineListener(final AdvancedViatraQueryEngine engine, final TreeViewer viewer) {
      this.viewer = viewer;
      this.engine = engine;
      engine.addLifecycleListener(this);
    }
    
    @Override
    public void engineBecameTainted(final String message, final Throwable t) {
      final Runnable _function = () -> {
        EngineError _engineError = new EngineError(message, t);
        this.viewer.add(this.engine, _engineError);
      };
      this.viewer.getTree().getDisplay().asyncExec(_function);
    }
    
    @Override
    public void engineDisposed() {
      this.disposed = true;
    }
    
    @Override
    public void engineWiped() {
    }
    
    @Override
    public void matcherInstantiated(final ViatraQueryMatcher<? extends IPatternMatch> matcher) {
    }
    
    public boolean dispose() {
      boolean _xifexpression = false;
      if (this.disposed) {
        boolean _xblockexpression = false;
        {
          this.engine.removeLifecycleListener(this);
          _xblockexpression = this.disposed = true;
        }
        _xifexpression = _xblockexpression;
      }
      return _xifexpression;
    }
  }
  
  protected AdapterFactoryContentProvider adapterFactoryContentProvider;
  
  @Accessors
  protected boolean traverseResources = true;
  
  @Accessors
  protected boolean traverseEObjects = true;
  
  private TreeViewer viewer;
  
  private List<ViatraQueryEngineContentProvider.EngineListener> listeners = new ArrayList<ViatraQueryEngineContentProvider.EngineListener>();
  
  public ViatraQueryEngineContentProvider() {
    final AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
    AdapterFactoryContentProvider _adapterFactoryContentProvider = new AdapterFactoryContentProvider(adapterFactory);
    this.adapterFactoryContentProvider = _adapterFactoryContentProvider;
  }
  
  @Override
  public Object[] getChildren(final Object parentElement) {
    return ((Object[])Conversions.unwrapArray(this.getChildrenInternal(parentElement), Object.class));
  }
  
  protected List<?> _getChildrenInternal(final Object parentElement) {
    return IterableExtensions.<Object>toList(((Iterable<Object>)Conversions.doWrapArray(this.adapterFactoryContentProvider.getChildren(parentElement))));
  }
  
  protected List<?> _getChildrenInternal(final EObject parentElement) {
    if (this.traverseEObjects) {
      return IterableExtensions.<Object>toList(((Iterable<Object>)Conversions.doWrapArray(this.adapterFactoryContentProvider.getChildren(parentElement))));
    } else {
      return CollectionLiterals.<Object>emptyList();
    }
  }
  
  protected List<?> _getChildrenInternal(final Resource parentElement) {
    if (this.traverseResources) {
      return IterableExtensions.<Object>toList(((Iterable<Object>)Conversions.doWrapArray(this.adapterFactoryContentProvider.getChildren(parentElement))));
    } else {
      return CollectionLiterals.<Object>emptyList();
    }
  }
  
  protected List<?> _getChildrenInternal(final ViatraQueryEngineManager parentElement) {
    return IterableExtensions.<ViatraQueryEngine>toList(parentElement.getExistingQueryEngines());
  }
  
  protected List<?> _getChildrenInternal(final AdvancedViatraQueryEngine parentElement) {
    final ViatraQueryEngineOptions engineOptions = parentElement.getEngineOptions();
    final QueryScope scope = parentElement.getScope();
    ViatraQueryEngineContentProvider.EngineListener _engineListener = new ViatraQueryEngineContentProvider.EngineListener(parentElement, this.viewer);
    this.listeners.add(_engineListener);
    if ((scope instanceof EMFScope)) {
      final Set<? extends Notifier> roots = ((EMFScope)scope).getScopeRoots();
      final BaseIndexOptions options = ((EMFScope)scope).getOptions();
      return ImmutableList.<Object>builder().addAll(roots).add(engineOptions).add(options).build();
    } else {
      return Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(scope, engineOptions));
    }
  }
  
  protected List<?> _getChildrenInternal(final BaseIndexOptions parentElement) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Dynamic EMF mode");
    boolean _isDynamicEMFMode = parentElement.isDynamicEMFMode();
    Pair<String, Boolean> _mappedTo = Pair.<String, Boolean>of(_builder.toString(), Boolean.valueOf(_isDynamicEMFMode));
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("Wildcard mode");
    boolean _isWildcardMode = parentElement.isWildcardMode();
    Pair<String, Boolean> _mappedTo_1 = Pair.<String, Boolean>of(_builder_1.toString(), Boolean.valueOf(_isWildcardMode));
    StringConcatenation _builder_2 = new StringConcatenation();
    _builder_2.append("Traverse only well-behaving features");
    boolean _isTraverseOnlyWellBehavingDerivedFeatures = parentElement.isTraverseOnlyWellBehavingDerivedFeatures();
    Pair<String, Boolean> _mappedTo_2 = Pair.<String, Boolean>of(_builder_2.toString(), Boolean.valueOf(_isTraverseOnlyWellBehavingDerivedFeatures));
    StringConcatenation _builder_3 = new StringConcatenation();
    _builder_3.append("Resource filter");
    IBaseIndexResourceFilter _resourceFilterConfiguration = parentElement.getResourceFilterConfiguration();
    Pair<String, IBaseIndexResourceFilter> _mappedTo_3 = Pair.<String, IBaseIndexResourceFilter>of(_builder_3.toString(), _resourceFilterConfiguration);
    StringConcatenation _builder_4 = new StringConcatenation();
    _builder_4.append("Object filter");
    IBaseIndexObjectFilter _objectFilterConfiguration = parentElement.getObjectFilterConfiguration();
    Pair<String, IBaseIndexObjectFilter> _mappedTo_4 = Pair.<String, IBaseIndexObjectFilter>of(_builder_4.toString(), _objectFilterConfiguration);
    final List<? extends Pair<String, ?>> baseOptions = Collections.<Pair<String, ?>>unmodifiableList(CollectionLiterals.<Pair<String, ?>>newArrayList(_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3, _mappedTo_4));
    return baseOptions;
  }
  
  protected List<?> _getChildrenInternal(final ViatraQueryEngineOptions parentElement) {
    return this.getChildrenInternal(parentElement.getEngineDefaultHints());
  }
  
  protected List<?> _getChildrenInternal(final QueryEvaluationHint parentElement) {
    final ImmutableList.Builder<Object> builder = ImmutableList.<Object>builder().add(parentElement.getQueryBackendFactory());
    boolean _isEmpty = parentElement.getBackendHintSettings().isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      builder.add(parentElement.getBackendHintSettings().entrySet());
    } else {
      builder.add("No hints specified");
    }
    return builder.build();
  }
  
  protected List<?> _getChildrenInternal(final ResourceSet parentElement) {
    return parentElement.getResources();
  }
  
  @Override
  public Object[] getElements(final Object inputElement) {
    return this.getChildren(inputElement);
  }
  
  @Override
  public Object getParent(final Object element) {
    return null;
  }
  
  @Override
  public boolean hasChildren(final Object element) {
    return ((this.getChildren(element) != null) && (!((List<Object>)Conversions.doWrapArray(this.getChildren(element))).isEmpty()));
  }
  
  @Override
  public void dispose() {
    final Consumer<ViatraQueryEngineContentProvider.EngineListener> _function = (ViatraQueryEngineContentProvider.EngineListener it) -> {
      it.dispose();
    };
    this.listeners.forEach(_function);
  }
  
  @Override
  public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
    this.viewer = ((TreeViewer) viewer);
  }
  
  public List<?> getChildrenInternal(final Object parentElement) {
    if (parentElement instanceof EObject) {
      return _getChildrenInternal((EObject)parentElement);
    } else if (parentElement instanceof Resource) {
      return _getChildrenInternal((Resource)parentElement);
    } else if (parentElement instanceof ResourceSet) {
      return _getChildrenInternal((ResourceSet)parentElement);
    } else if (parentElement instanceof AdvancedViatraQueryEngine) {
      return _getChildrenInternal((AdvancedViatraQueryEngine)parentElement);
    } else if (parentElement instanceof ViatraQueryEngineManager) {
      return _getChildrenInternal((ViatraQueryEngineManager)parentElement);
    } else if (parentElement instanceof ViatraQueryEngineOptions) {
      return _getChildrenInternal((ViatraQueryEngineOptions)parentElement);
    } else if (parentElement instanceof BaseIndexOptions) {
      return _getChildrenInternal((BaseIndexOptions)parentElement);
    } else if (parentElement instanceof QueryEvaluationHint) {
      return _getChildrenInternal((QueryEvaluationHint)parentElement);
    } else if (parentElement != null) {
      return _getChildrenInternal(parentElement);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(parentElement).toString());
    }
  }
  
  @Pure
  public boolean isTraverseResources() {
    return this.traverseResources;
  }
  
  public void setTraverseResources(final boolean traverseResources) {
    this.traverseResources = traverseResources;
  }
  
  @Pure
  public boolean isTraverseEObjects() {
    return this.traverseEObjects;
  }
  
  public void setTraverseEObjects(final boolean traverseEObjects) {
    this.traverseEObjects = traverseEObjects;
  }
}
