/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IConnectionMethod;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.ui.PlatformUI;

public class ConfigurationWizardMainPage
extends CVSWizardPage {
    private static final String ANONYMOUS_USER = "anonymous";
    private boolean showValidate;
    private boolean validate;
    private Combo connectionMethodCombo;
    private Combo userCombo;
    private Text passwordText;
    private Text portText;
    private Button useDefaultPort;
    private Button useCustomPort;
    private Combo hostCombo;
    private Combo repositoryPathCombo;
    private Button validateButton;
    private Button allowCachingButton;
    private boolean allowCaching = false;
    private static final int COMBO_HISTORY_LENGTH = 5;
    private Properties properties = null;
    private ICVSRepositoryLocation location;
    private ICVSRepositoryLocation oldLocation;
    private static final String STORE_USERNAME_ID = "ConfigurationWizardMainPage.STORE_USERNAME_ID";
    private static final String STORE_HOSTNAME_ID = "ConfigurationWizardMainPage.STORE_HOSTNAME_ID";
    private static final String STORE_PATH_ID = "ConfigurationWizardMainPage.STORE_PATH_ID";
    private static final String STORE_DONT_VALIDATE_ID = "ConfigurationWizardMainPage.STORE_DONT_VALIDATE_ID";
    private IDialogSettings settings;
    public static final int REQUIRED_FIELD = 1;
    public static final int INVALID_FIELD_CONTENTS = 2;

    public ConfigurationWizardMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    private String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected IDialogSettings getDialogSettings() {
        return this.settings;
    }

    protected void setDialogSettings(IDialogSettings settings) {
        this.settings = settings;
    }

    private void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 2, false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.sharing_new_repository_page_context");
        Listener listener = event -> {
            String hostText;
            if (this.location != null) {
                this.oldLocation = this.location;
                this.location = null;
            }
            if (event.widget == this.hostCombo && (hostText = this.hostCombo.getText()).length() > 0 && hostText.charAt(0) == ':') {
                try {
                    CVSRepositoryLocation newLocation = CVSRepositoryLocation.fromString((String)hostText);
                    this.connectionMethodCombo.setText(newLocation.getMethod().getName());
                    this.repositoryPathCombo.setText(newLocation.getRootDirectory());
                    int port = newLocation.getPort();
                    if (port == 0) {
                        this.useDefaultPort.setSelection(true);
                        this.useCustomPort.setSelection(false);
                    } else {
                        this.useCustomPort.setSelection(true);
                        this.useDefaultPort.setSelection(false);
                        this.portText.setText(String.valueOf(port));
                    }
                    this.userCombo.setText(newLocation.getUsername());
                    this.hostCombo.setText(newLocation.getHost());
                }
                catch (CVSException e) {
                    CVSUIPlugin.log((CoreException)((Object)((Object)((Object)e))));
                }
            }
            this.updateWidgetEnablements();
        };
        Group g = this.createGroup(composite, CVSUIMessages.ConfigurationWizardMainPage_Location_1);
        ConfigurationWizardMainPage.createLabel((Composite)g, CVSUIMessages.ConfigurationWizardMainPage_host);
        this.hostCombo = this.createEditableCombo((Composite)g);
        ControlDecoration decoration = new ControlDecoration((Control)this.hostCombo, 16512);
        FieldDecoration infoDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        decoration.setImage(infoDecoration.getImage());
        decoration.setDescriptionText(CVSUIMessages.ConfigurationWizardMainPage_8);
        decoration.setShowOnlyOnFocus(true);
        ((GridLayout)g.getLayout()).horizontalSpacing = decoration.getMarginWidth() + infoDecoration.getImage().getBounds().width;
        this.hostCombo.addListener(13, listener);
        this.hostCombo.addListener(24, listener);
        ConfigurationWizardMainPage.createLabel((Composite)g, CVSUIMessages.ConfigurationWizardMainPage_repositoryPath);
        this.repositoryPathCombo = this.createEditableCombo((Composite)g);
        this.repositoryPathCombo.addListener(13, listener);
        this.repositoryPathCombo.addListener(24, listener);
        g = this.createGroup(composite, CVSUIMessages.ConfigurationWizardMainPage_Authentication_2);
        ConfigurationWizardMainPage.createLabel((Composite)g, CVSUIMessages.ConfigurationWizardMainPage_userName);
        this.userCombo = this.createEditableCombo((Composite)g);
        this.userCombo.addListener(13, listener);
        this.userCombo.addListener(24, listener);
        ConfigurationWizardMainPage.createLabel((Composite)g, CVSUIMessages.ConfigurationWizardMainPage_password);
        this.passwordText = ConfigurationWizardMainPage.createPasswordField((Composite)g);
        this.passwordText.addListener(24, listener);
        g = this.createGroup(composite, CVSUIMessages.ConfigurationWizardMainPage_Connection_3);
        ConfigurationWizardMainPage.createLabel((Composite)g, CVSUIMessages.ConfigurationWizardMainPage_connection);
        this.connectionMethodCombo = this.createCombo((Composite)g);
        this.connectionMethodCombo.addListener(13, listener);
        Composite portGroup = new Composite((Composite)g, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        portGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        portGroup.setLayout((Layout)layout);
        this.useDefaultPort = this.createRadioButton(portGroup, CVSUIMessages.ConfigurationWizardMainPage_useDefaultPort, 2);
        this.useCustomPort = this.createRadioButton(portGroup, CVSUIMessages.ConfigurationWizardMainPage_usePort, 1);
        this.useCustomPort.addListener(13, listener);
        this.portText = ConfigurationWizardMainPage.createTextField(portGroup);
        this.portText.addListener(24, listener);
        if (this.showValidate) {
            Composite validateButtonTabGroup = new Composite(composite, 0);
            data = new GridData();
            data.horizontalSpan = 2;
            validateButtonTabGroup.setLayoutData((Object)data);
            validateButtonTabGroup.setLayout((Layout)new FillLayout());
            this.validateButton = new Button(validateButtonTabGroup, 32);
            this.validateButton.setText(CVSUIMessages.ConfigurationWizardAutoconnectPage_validate);
            this.validateButton.addListener(13, e -> {
                boolean bl = this.validate = this.validateButton.getSelection();
            });
        }
        this.allowCachingButton = new Button(composite, 32);
        this.allowCachingButton.setText(CVSUIMessages.UserValidationDialog_6);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.allowCachingButton.setLayoutData((Object)data);
        this.allowCachingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationWizardMainPage.this.allowCaching = ConfigurationWizardMainPage.this.allowCachingButton.getSelection();
            }
        });
        Link link = SWTUtils.createPreferenceLink((Shell)this.getShell(), (Composite)composite, (String)CVSUIMessages.ConfigurationWizardMainPage_9, (String)CVSUIMessages.ConfigurationWizardMainPage_10);
        data = new GridData(768);
        data.horizontalSpan = 2;
        link.setLayoutData((Object)data);
        SWTUtils.createPreferenceLink((Shell)this.getShell(), (Composite)composite, (String)"org.eclipse.team.cvs.ui.ExtMethodPreferencePage", (String[])new String[]{"org.eclipse.team.cvs.ui.cvs", "org.eclipse.team.cvs.ui.ExtMethodPreferencePage", "org.eclipse.jsch.ui.SSHPreferences", "org.eclipse.ui.net.NetPreferences"}, (String)CVSUIMessages.ConfigurationWizardMainPage_7);
        this.initializeValues();
        this.updateWidgetEnablements();
        this.hostCombo.setFocus();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
    }

    protected Combo createEditableCombo(Composite parent) {
        Combo combo = new Combo(parent, 0);
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        return group;
    }

    private Properties createProperties() {
        Properties result = new Properties();
        result.setProperty("connection", this.connectionMethodCombo.getText());
        result.setProperty("user", this.userCombo.getText());
        result.setProperty("password", this.passwordText.getText());
        result.setProperty("host", this.hostCombo.getText());
        if (this.useCustomPort.getSelection()) {
            result.setProperty("port", this.portText.getText());
        }
        result.setProperty("root", this.repositoryPathCombo.getText());
        return result;
    }

    public ICVSRepositoryLocation getLocation() throws CVSException {
        if (this.location == null) {
            if (!this.isPageComplete()) {
                return null;
            }
            this.location = CVSRepositoryLocation.fromProperties((Properties)this.createProperties());
            if (this.location.equals(this.oldLocation)) {
                this.location = this.oldLocation;
            }
            this.location.setAllowCaching(this.allowCaching);
            this.oldLocation = null;
            this.saveWidgetValues();
        }
        return this.location;
    }

    private void initializeValues() {
        IConnectionMethod[] methods;
        Object[] objectArray;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] userNames;
            String[] paths;
            int n;
            String[] hostNames = settings.getArray(STORE_HOSTNAME_ID);
            if (hostNames != null) {
                objectArray = hostNames;
                n = hostNames.length;
                int n2 = 0;
                while (n2 < n) {
                    IConnectionMethod hostName = objectArray[n2];
                    this.hostCombo.add((String)hostName);
                    ++n2;
                }
            }
            if ((paths = settings.getArray(STORE_PATH_ID)) != null) {
                String[] stringArray = paths;
                int n3 = paths.length;
                n = 0;
                while (n < n3) {
                    String path = stringArray[n];
                    this.repositoryPathCombo.add(path);
                    ++n;
                }
            }
            if ((userNames = settings.getArray(STORE_USERNAME_ID)) != null) {
                String[] stringArray = userNames;
                int n4 = userNames.length;
                int n5 = 0;
                while (n5 < n4) {
                    String userName = stringArray[n5];
                    this.userCombo.add(userName);
                    ++n5;
                }
            }
            this.userCombo.add(ANONYMOUS_USER);
            if (this.showValidate) {
                this.validate = !settings.getBoolean(STORE_DONT_VALIDATE_ID);
                this.validateButton.setSelection(this.validate);
            }
        }
        objectArray = methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        int userName = methods.length;
        int userNames = 0;
        while (userNames < userName) {
            IConnectionMethod method = objectArray[userNames];
            this.connectionMethodCombo.add(method.getName());
            ++userNames;
        }
        int defaultIndex = this.connectionMethodCombo.indexOf("pserver") != -1 ? this.connectionMethodCombo.indexOf("pserver") : 0;
        this.connectionMethodCombo.select(defaultIndex);
        this.useDefaultPort.setSelection(true);
        if (this.properties != null) {
            String repositoryPath;
            String port;
            String host;
            String password;
            String method = this.properties.getProperty("connection");
            if (method == null) {
                this.connectionMethodCombo.select(defaultIndex);
            } else {
                this.connectionMethodCombo.select(this.connectionMethodCombo.indexOf(method));
            }
            String user = this.properties.getProperty("user");
            if (user != null) {
                this.userCombo.setText(user);
            }
            if ((password = this.properties.getProperty("password")) != null) {
                this.passwordText.setText(password);
            }
            if ((host = this.properties.getProperty("host")) != null) {
                this.hostCombo.setText(host);
            }
            if ((port = this.properties.getProperty("port")) != null) {
                this.useCustomPort.setSelection(true);
                this.portText.setText(port);
            }
            if ((repositoryPath = this.properties.getProperty("root")) != null) {
                this.repositoryPathCombo.setText(repositoryPath);
            }
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] hostNames;
            String userName = this.userCombo.getText();
            if (!userName.equals(ANONYMOUS_USER)) {
                String[] userNames = settings.getArray(STORE_USERNAME_ID);
                if (userNames == null) {
                    userNames = new String[]{};
                }
                userNames = this.addToHistory(userNames, userName);
                settings.put(STORE_USERNAME_ID, userNames);
            }
            if ((hostNames = settings.getArray(STORE_HOSTNAME_ID)) == null) {
                hostNames = new String[]{};
            }
            hostNames = this.addToHistory(hostNames, this.hostCombo.getText());
            settings.put(STORE_HOSTNAME_ID, hostNames);
            String[] paths = settings.getArray(STORE_PATH_ID);
            if (paths == null) {
                paths = new String[]{};
            }
            paths = this.addToHistory(paths, this.repositoryPathCombo.getText());
            settings.put(STORE_PATH_ID, paths);
            if (this.showValidate) {
                settings.put(STORE_DONT_VALIDATE_ID, !this.validate);
            }
        }
    }

    public void setShowValidate(boolean showValidate) {
        this.showValidate = showValidate;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected void updateWidgetEnablements() {
        if (this.useDefaultPort.getSelection()) {
            this.portText.setEnabled(false);
        } else {
            this.portText.setEnabled(true);
        }
        this.validateFields();
    }

    protected void validateFields() {
        String port;
        String user = this.userCombo.getText();
        IStatus status = ConfigurationWizardMainPage.validateUserName(user);
        if (!this.isStatusOK(status)) {
            return;
        }
        String host = this.hostCombo.getText();
        status = ConfigurationWizardMainPage.validateHost(host);
        if (!this.isStatusOK(status)) {
            return;
        }
        if (this.portText.isEnabled() && !this.isStatusOK(status = ConfigurationWizardMainPage.validatePort(port = this.portText.getText()))) {
            return;
        }
        String pathString = this.repositoryPathCombo.getText();
        status = ConfigurationWizardMainPage.validatePath(pathString);
        if (!this.isStatusOK(status)) {
            return;
        }
        try {
            CVSRepositoryLocation l = CVSRepositoryLocation.fromProperties((Properties)this.createProperties());
            if (!l.equals((Object)this.oldLocation) && KnownRepositories.getInstance().isKnownRepository(l.getLocation())) {
                this.setErrorMessage(CVSUIMessages.ConfigurationWizardMainPage_0);
                this.setPageComplete(false);
                return;
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private boolean isStatusOK(IStatus status) {
        if (!status.isOK()) {
            if (status.getCode() == 1) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(status.getMessage());
            }
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.hostCombo.setFocus();
        }
    }

    public static final IStatus validateUserName(String user) {
        if (user.length() == 0) {
            return new Status(4, "org.eclipse.team.cvs.ui", 1, CVSUIMessages.ConfigurationWizardMainPage_1, null);
        }
        if (user.indexOf(58) != -1) {
            return new Status(4, "org.eclipse.team.cvs.ui", 2, CVSUIMessages.ConfigurationWizardMainPage_invalidUserName, null);
        }
        if (user.startsWith(" ") || user.endsWith(" ")) {
            return new Status(4, "org.eclipse.team.cvs.ui", 2, CVSUIMessages.ConfigurationWizardMainPage_6, null);
        }
        return Status.OK_STATUS;
    }

    public static final IStatus validateHost(String host) {
        if (host.length() == 0) {
            return new Status(4, "org.eclipse.team.cvs.ui", 1, CVSUIMessages.ConfigurationWizardMainPage_2, null);
        }
        if (host.indexOf(58) != -1) {
            return new Status(4, "org.eclipse.team.cvs.ui", 2, CVSUIMessages.ConfigurationWizardMainPage_invalidHostName, null);
        }
        if (host.startsWith(" ") || host.endsWith(" ")) {
            return new Status(4, "org.eclipse.team.cvs.ui", 2, CVSUIMessages.ConfigurationWizardMainPage_5, null);
        }
        return Status.OK_STATUS;
    }

    public static final IStatus validatePort(String port) {
        if (port.length() == 0) {
            return new Status(4, "org.eclipse.team.cvs.ui", 1, CVSUIMessages.ConfigurationWizardMainPage_3, null);
        }
        try {
            Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            return new Status(4, "org.eclipse.team.cvs.ui", 2, CVSUIMessages.ConfigurationWizardMainPage_invalidPort, null);
        }
        return Status.OK_STATUS;
    }

    public static final IStatus validatePath(String pathString) {
        String[] segments;
        if (pathString.length() == 0) {
            return new Status(4, "org.eclipse.team.cvs.ui", 1, CVSUIMessages.ConfigurationWizardMainPage_4, null);
        }
        Path path = new Path(null, pathString);
        String[] stringArray = segments = path.segments();
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.charAt(0) == ' ' || string.charAt(string.length() - 1) == ' ') {
                return new Status(4, "org.eclipse.team.cvs.ui", 2, CVSUIMessages.ConfigurationWizardMainPage_invalidPathWithSpaces, null);
            }
            ++n2;
        }
        if (pathString.contains("//")) {
            if (pathString.indexOf("//") == 2) {
                return new Status(4, "org.eclipse.team.cvs.ui", 2, CVSUIMessages.ConfigurationWizardMainPage_useNTFormat, null);
            }
            return new Status(4, "org.eclipse.team.cvs.ui", 2, CVSUIMessages.ConfigurationWizardMainPage_invalidPathWithSlashes, null);
        }
        if (pathString.endsWith("/")) {
            return new Status(4, "org.eclipse.team.cvs.ui", 2, CVSUIMessages.ConfigurationWizardMainPage_invalidPathWithTrailingSlash, null);
        }
        return Status.OK_STATUS;
    }
}

