/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.scripting.launcher;

import java.io.IOException;
import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.core.AbstractChannel;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.scripting.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.scripting.events.ScriptEvent;
import org.eclipse.tcf.te.tcf.core.scripting.interfaces.IScriptLauncher;
import org.eclipse.tcf.te.tcf.core.scripting.nls.Messages;
import org.eclipse.tcf.te.tcf.core.scripting.parser.Parser;
import org.eclipse.tcf.te.tcf.core.scripting.parser.Token;
import org.eclipse.tcf.te.tcf.core.util.JSONUtils;

public class ScriptLauncher
extends PlatformObject
implements IScriptLauncher {
    IChannel channel;
    private IPropertiesContainer properties;
    private ICallback callback;
    AbstractChannel.TraceListener traceListener;

    @Override
    public void dispose() {
        if (this.channel != null) {
            if (this.traceListener != null) {
                ((AbstractChannel)this.channel).removeTraceListener(this.traceListener);
                this.traceListener = null;
            }
            Tcf.getChannelManager().closeChannel(this.channel);
            ScriptEvent event = new ScriptEvent(this, ScriptEvent.Type.STOP, null);
            EventManager.getInstance().fireEvent((EventObject)event);
            this.channel = null;
        }
    }

    @Override
    public void launch(final IPeer peer, final IPropertiesContainer properties, ICallback callback) {
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)properties);
        this.callback = callback == null ? new Callback(){

            public void internalDone(Object caller, IStatus status) {
            }
        } : callback;
        this.properties = properties;
        Tcf.getChannelManager().openChannel(peer, null, new IChannelManager.DoneOpenChannel(){

            public void doneOpenChannel(Throwable error, IChannel channel) {
                if (error == null) {
                    ScriptLauncher.this.channel = channel;
                    ScriptEvent event = new ScriptEvent(ScriptLauncher.this, ScriptEvent.Type.START, null);
                    EventManager.getInstance().fireEvent((EventObject)event);
                    channel.addChannelListener(new IChannel.IChannelListener(){

                        public void onChannelOpened() {
                        }

                        public void onChannelClosed(Throwable error) {
                            if ((this).ScriptLauncher.this.traceListener != null && (this).ScriptLauncher.this.channel != null) {
                                ((AbstractChannel)(this).ScriptLauncher.this.channel).removeTraceListener((this).ScriptLauncher.this.traceListener);
                                (this).ScriptLauncher.this.traceListener = null;
                            }
                            if (error != null) {
                                Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ScriptLauncher_error_channelConnectFailed, (Object)peer.getID(), (Object)error.getLocalizedMessage()), error);
                                ScriptLauncher.this.invokeCallback((IStatus)status, null);
                            }
                        }

                        public void congestionLevel(int level) {
                        }
                    });
                    ScriptLauncher.this.traceListener = new AbstractChannel.TraceListener(){

                        public void onMessageSent(char type, String token, String service, String name, byte[] data) {
                            if (this.isFiltered(type, name)) {
                                return;
                            }
                            String message = this.formatMessage(type, token, service, name, data, false);
                            ScriptEvent event = new ScriptEvent(ScriptLauncher.this, ScriptEvent.Type.OUTPUT, new ScriptEvent.Message(type, message));
                            EventManager.getInstance().fireEvent((EventObject)event);
                        }

                        public void onMessageReceived(char type, String token, String service, String name, byte[] data) {
                            if (this.isFiltered(type, name)) {
                                return;
                            }
                            String message = this.formatMessage(type, token, service, name, data, true);
                            ScriptEvent event = new ScriptEvent(ScriptLauncher.this, ScriptEvent.Type.OUTPUT, new ScriptEvent.Message(type, message));
                            EventManager.getInstance().fireEvent((EventObject)event);
                        }

                        public void onChannelClosed(Throwable error) {
                        }

                        private boolean isFiltered(char type, String name) {
                            boolean filtered = false;
                            if (type == 'F' || name != null && name.toLowerCase().contains("heartbeat")) {
                                filtered = true;
                            }
                            return filtered;
                        }

                        protected String formatMessage(char type, String token, String service, String name, byte[] data, boolean received) {
                            String args = JSONUtils.decodeStringFromByteArray((byte[])data);
                            StringBuilder message = new StringBuilder();
                            message.append(received ? "<---" : "--->");
                            message.append(" ").append(Character.valueOf(type));
                            if (token != null) {
                                message.append(" ").append(token);
                            }
                            if (service != null) {
                                message.append(" ").append(service);
                            }
                            if (name != null) {
                                message.append(" ").append(name);
                            }
                            if (args != null && args.trim().length() > 0) {
                                message.append(" ").append(args.trim());
                            }
                            return message.toString();
                        }
                    };
                    ((AbstractChannel)channel).addTraceListener(ScriptLauncher.this.traceListener);
                    if (channel.getState() != 1) {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.ScriptLauncher_error_channelNotConnected, (Throwable)new IllegalStateException());
                        ScriptLauncher.this.invokeCallback((IStatus)status, null);
                        return;
                    }
                    if (properties.getStringProperty("script.script") == null) {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.ScriptLauncher_error_missingScript, (Throwable)new IllegalArgumentException("script.script"));
                        ScriptLauncher.this.invokeCallback((IStatus)status, null);
                        return;
                    }
                    ScriptLauncher.this.executeLaunch();
                } else {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ScriptLauncher_error_channelConnectFailed, (Object)peer.getID(), (Object)error.getLocalizedMessage()), error);
                    ScriptLauncher.this.invokeCallback((IStatus)status, null);
                }
            }
        });
    }

    protected void executeLaunch() {
        IPropertiesContainer properties = this.getProperties();
        if (properties == null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ScriptLauncher_error_illegalNullArgument, (Object)"properties"), (Throwable)new IllegalArgumentException());
            this.invokeCallback((IStatus)status, null);
            return;
        }
        String script = properties.getStringProperty("script.script");
        if (script == null || "".equals(script.trim())) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.ScriptLauncher_error_missingScript, (Throwable)new IllegalArgumentException("script.script"));
            this.invokeCallback((IStatus)status, null);
            return;
        }
        Parser parser = new Parser(script);
        try {
            Token[] tokens = parser.parse();
            if (tokens == null || tokens.length <= 0) {
                this.invokeCallback(Status.OK_STATUS, null);
                return;
            }
            this.executeToken(tokens, 0);
        }
        catch (IOException e) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ScriptLauncher_error_parsingScript, (Object)e.getLocalizedMessage()), (Throwable)e);
            this.invokeCallback((IStatus)status, null);
            return;
        }
    }

    protected void executeToken(final Token[] tokens, final int index) {
        IService service;
        Assert.isNotNull((Object)tokens);
        if (index < 0 || index >= tokens.length) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ScriptLauncher_error_illegalIndex, (Object)index), (Throwable)new IllegalArgumentException("index"));
            this.invokeCallback((IStatus)status, null);
            return;
        }
        Token token = tokens[index];
        IService iService = service = this.channel != null ? this.channel.getRemoteService(token.getServiceName()) : null;
        if (service != null) {
            new Command(this.channel, service, token.getCommandName(), token.getArguments()){

                public void done(Exception error, Object[] args) {
                    if (error == null) {
                        int nextIndex = index + 1;
                        if (nextIndex == tokens.length) {
                            ScriptLauncher.this.invokeCallback(Status.OK_STATUS, null);
                        } else {
                            ScriptLauncher.this.executeToken(tokens, nextIndex);
                        }
                    } else {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ScriptLauncher_error_parsingScript, (Object)error.getLocalizedMessage()), (Throwable)error);
                        ScriptLauncher.this.invokeCallback((IStatus)status, null);
                    }
                }
            };
        } else {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ScriptLauncher_error_serviceNotAvailable, (Object)token.getServiceName(), (Object)this.channel.getRemotePeer().getID()), null);
            this.invokeCallback((IStatus)status, null);
        }
    }

    protected void invokeCallback(IStatus status, Object result) {
        ICallback callback;
        if (status.getSeverity() == 4) {
            this.dispose();
        }
        if ((callback = this.getCallback()) != null) {
            callback.setResult(result);
            callback.done((Object)this, status);
        }
    }

    public final IChannel getChannel() {
        return this.channel;
    }

    public final IPropertiesContainer getProperties() {
        return this.properties;
    }

    protected final ICallback getCallback() {
        return this.callback;
    }
}

