/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.util.List;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.swt.tools.internal.ASTClass;
import org.eclipse.swt.tools.internal.ASTItem;
import org.eclipse.swt.tools.internal.ASTParameter;
import org.eclipse.swt.tools.internal.ASTType;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIParameter;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.MetaData;

public class ASTMethod
extends ASTItem
implements JNIMethod {
    String name;
    String qualifiedName;
    int modifiers;
    ASTClass declaringClass;
    ASTType[] paramTypes;
    ASTType returnType;
    ASTParameter[] parameters;
    Boolean unique;
    String data;
    int start;

    public ASTMethod(ASTClass declaringClass, MethodDeclaration method) {
        this.declaringClass = declaringClass;
        this.name = method.getName().getIdentifier();
        this.modifiers = method.getModifiers();
        this.start = method.getStartPosition();
        Javadoc doc = method.getJavadoc();
        List tags = null;
        if (doc != null) {
            tags = doc.tags();
            for (TagElement tag : tags) {
                if (!"@method".equals(tag.getTagName())) continue;
                String data = tag.fragments().get(0).toString();
                this.setMetaData(data);
                break;
            }
        }
        this.returnType = new ASTType(declaringClass.resolver, method.getReturnType2(), method.getExtraDimensions());
        List parameters = method.parameters();
        this.paramTypes = new ASTType[parameters.size()];
        this.parameters = new ASTParameter[this.paramTypes.length];
        int i = 0;
        for (SingleVariableDeclaration param : parameters) {
            this.paramTypes[i] = new ASTType(declaringClass.resolver, param.getType(), param.getExtraDimensions());
            this.parameters[i] = new ASTParameter(this, i, param.getName().getIdentifier());
            if (tags != null) {
                String name = param.getName().getIdentifier();
                for (TagElement tag : tags) {
                    List fragments;
                    if (!"@param".equals(tag.getTagName()) || (fragments = tag.fragments()).size() < 2 || !name.equals(fragments.get(0).toString())) continue;
                    String data = fragments.get(1).toString();
                    this.parameters[i].setMetaData(data);
                }
            }
            ++i;
        }
    }

    @Override
    public JNIClass getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isNativeUnique() {
        if (this.unique != null) {
            return this.unique;
        }
        boolean result = true;
        String name = this.getName();
        JNIMethod[] jNIMethodArray = this.declaringClass.getDeclaredMethods();
        int n = jNIMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            JNIMethod mth = jNIMethodArray[n2];
            if ((mth.getModifiers() & 0x100) != 0 && this != mth && !this.equals(mth) && name.equals(mth.getName())) {
                result = false;
                break;
            }
            ++n2;
        }
        this.unique = result;
        return result;
    }

    @Override
    public JNIType[] getParameterTypes() {
        return this.paramTypes;
    }

    @Override
    public JNIParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JNIType getReturnType() {
        return this.returnType;
    }

    @Override
    public String getAccessor() {
        return (String)this.getParam("accessor");
    }

    @Override
    public String getExclude() {
        return (String)this.getParam("exclude");
    }

    @Override
    public String getMetaData() {
        if (this.data != null) {
            return this.data;
        }
        MetaData metaData = this.declaringClass.metaData;
        String className = this.getDeclaringClass().getSimpleName();
        String key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this);
        String value = metaData.getMetaData(key, null);
        if (value == null) {
            key = String.valueOf(className) + "_" + this.getName();
            value = metaData.getMetaData(key, null);
        }
        if (value == null && this.getName().startsWith("_") && (value = metaData.getMetaData(key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this).substring(2), null)) == null) {
            key = String.valueOf(className) + "_" + this.getName().substring(1);
            value = metaData.getMetaData(key, null);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public void setAccessor(String str) {
        this.setParam("accessor", str);
    }

    @Override
    public void setExclude(String str) {
        this.setParam("exclude", str);
    }

    @Override
    public void setMetaData(String value) {
        this.data = value;
    }

    public String toString() {
        return this.getName();
    }
}

