/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.action;

import java.util.Locale;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.LanguageNewDialog;
import org.eclipse.swt.widgets.Shell;

public class LanguageNewAction
extends Action {
    private final Shell m_shell;
    private final TranslationStoreStack m_project;

    public LanguageNewAction(TranslationStoreStack project, Shell s) {
        super("New Language...");
        this.m_project = project;
        this.m_shell = s;
        this.setEnabled(project.isEditable());
        this.setImageDescriptor(S2ESdkUiActivator.getImageDescriptor("language_add.gif"));
    }

    public void run() {
        LanguageNewDialog dialog = new LanguageNewDialog(this.m_shell, this.m_project);
        if (dialog.open() == 0) {
            Language newLanguage = new Language(new Locale(dialog.getLanguageIso(), Optional.ofNullable(dialog.getCountryIso()).orElse("")));
            this.m_project.addNewLanguage(newLanguage, dialog.getStore());
        }
    }
}

