/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations;

import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.LaunchConfigurationTab;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.NoButton;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.RadioButton;
import org.eclipse.reddeer.swt.impl.button.YesButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.text.LabeledText;

public class EnvironmentTab
extends LaunchConfigurationTab {
    private static final String ADD_SHELL_TITLE = "New Environment Variable";
    private static final String SELECT_SHELL_TITLE = "Select Environment Variables";
    private static final String EDIT_SHELL_TITLE = "Edit Environment Variable";
    private static final String OVERWRITE_SHELL_TITLE = "Overwrite variable?";

    public EnvironmentTab() {
        super("Environment");
    }

    public List<TableItem> getAllVariables() {
        return new DefaultTable().getItems();
    }

    public TableItem getVariable(String variableName) {
        return new DefaultTable().getItem(variableName);
    }

    public TableItem getVariable(int variableId) {
        return new DefaultTable().getItem(variableId);
    }

    public void add(String name, String value) {
        this.add(name, value, true);
    }

    public void add(String name, String value, boolean overwrite) {
        new PushButton("Add...").click();
        new WaitUntil((WaitCondition)new ShellIsAvailable(ADD_SHELL_TITLE));
        new LabeledText("Name:").setText(name);
        new LabeledText("Value:").setText(value);
        new OkButton().click();
        try {
            new WaitUntil((WaitCondition)new ShellIsAvailable(OVERWRITE_SHELL_TITLE), TimePeriod.SHORT);
            if (overwrite) {
                new YesButton().click();
            } else {
                new NoButton().click();
            }
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {}
    }

    public void selectEnvironmentVariable(String variableName) {
        this.selectEnvironmentVariableImpl(() -> {
            int varId = this.getEvnironmentIdByName(variableName);
            new DefaultTable().getItem(varId).setChecked(true);
        });
    }

    private int getEvnironmentIdByName(String namePart) {
        List allEnvironments = new DefaultTable().getItems();
        for (TableItem environment : allEnvironments) {
            if (!environment.getText().contains(namePart)) continue;
            return allEnvironments.indexOf(environment);
        }
        new DefaultShell(SELECT_SHELL_TITLE).close();
        throw new RedDeerException("Environment variable name does not exists!");
    }

    public void selectEnvironmentVariable(int variableId) {
        this.selectEnvironmentVariableImpl(() -> new DefaultTable().getItem(variableId).setChecked(true));
    }

    public void selectEnvironmentVariable(boolean selectAllBool) {
        this.selectEnvironmentVariableImpl(() -> {
            if (selectAllBool) {
                new PushButton("Select All").click();
            } else {
                new PushButton("Deselect All").click();
            }
        });
    }

    private void selectEnvironmentVariableImpl(Runnable selectedImpl) {
        new PushButton("Select...").click();
        new WaitUntil((WaitCondition)new ShellIsAvailable(SELECT_SHELL_TITLE));
        selectedImpl.run();
        OkButton oB = new OkButton();
        if (oB.isEnabled()) {
            oB.click();
        }
    }

    public void edit(String variableName, String newName, String newValue) {
        this.getVariable(variableName).select();
        new PushButton("Edit...").click();
        new WaitUntil((WaitCondition)new ShellIsAvailable(EDIT_SHELL_TITLE));
        if (newName != null) {
            new LabeledText("Name:").setText(newName);
        }
        if (newValue != null) {
            new LabeledText("Value:").setText(newValue);
        }
        new OkButton().click();
    }

    public void remove(String variableName) {
        this.getVariable(variableName).select();
        new PushButton("Remove").click();
    }

    public void copy(String variableName) {
        this.getVariable(variableName).select();
        new PushButton("Copy").click();
    }

    public void paste() {
        new PushButton("Paste").click();
    }

    public RadioButton getAppendRadioButton() {
        return new RadioButton("Append environment to native environment");
    }

    public RadioButton getReplaceRadioButton() {
        return new RadioButton("Replace native environment with specified environment");
    }
}

