/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2m.internal.qvt.oml.cst.ClassifierDefCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModulePropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.TransformationHeaderCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.HyperlinkUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtFileHyperlink;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.StringMatcher;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.LegacyHandlerSubmissionExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;

public abstract class AbstractInformationControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private Text myFilterText;
    private TreeViewer myTreeViewer;
    protected StringMatcher myStringMatcher;
    private Command myInvokingCommand;
    private TriggerSequence[] myInvokingCommandKeySequences;
    private Composite myViewMenuButtonComposite;
    private IAction myShowViewMenuAction;
    private IHandlerActivation myShowViewMenuHandlerActivation;
    private int myTreeStyle;

    public AbstractInformationControl(Shell parent, int shellStyle, int treeStyle, String invokingCommandId, boolean showStatusField) {
        super(parent, shellStyle, true, true, true, true, true, null, null);
        if (invokingCommandId != null) {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            this.myInvokingCommand = commandService.getCommand(invokingCommandId);
            if (this.myInvokingCommand != null && !this.myInvokingCommand.isDefined()) {
                this.myInvokingCommand = null;
            } else {
                this.getInvokingCommandKeySequences();
            }
        }
        this.myTreeStyle = treeStyle;
        if (this.hasHeader()) {
            this.setTitleText("");
        }
        this.setInfoText("");
        this.create();
        this.setInfoText(this.getStatusFieldText());
    }

    protected Control createDialogArea(Composite parent) {
        this.myTreeViewer = this.createTreeViewer(parent, this.myTreeStyle);
        final Tree tree = this.myTreeViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractInformationControl.this.gotoSelectedElement();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                TreeItem o;
                if (tree.equals(e.getSource()) && (o = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem) {
                    if (!o.equals(this.fLastItem)) {
                        this.fLastItem = o;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (e.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = AbstractInformationControl.this.myTreeViewer.scrollUp(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = AbstractInformationControl.this.myTreeViewer.scrollDown(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        AbstractInformationControl.this.gotoSelectedElement();
                    }
                }
            }
        });
        this.installFilter();
        this.addDisposeListener(this);
        return this.myTreeViewer.getControl();
    }

    public AbstractInformationControl(Shell parent, int shellStyle, int treeStyle) {
        this(parent, shellStyle, treeStyle, null, false);
    }

    protected abstract TreeViewer createTreeViewer(Composite var1, int var2);

    protected abstract String getId();

    protected TreeViewer getTreeViewer() {
        return this.myTreeViewer;
    }

    protected boolean hasHeader() {
        return false;
    }

    protected Text getFilterText() {
        return this.myFilterText;
    }

    protected Text createFilterText(Composite parent) {
        this.myFilterText = new Text(parent, 0);
        Dialog.applyDialogFont((Control)this.myFilterText);
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.myFilterText.setLayoutData((Object)data);
        this.myFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    AbstractInformationControl.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    AbstractInformationControl.this.myTreeViewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    AbstractInformationControl.this.myTreeViewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.myFilterText;
    }

    protected void createHorizontalSeparator(Composite parent) {
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
    }

    protected void updateStatusFieldText() {
        this.setInfoText(this.getStatusFieldText());
    }

    protected void handleStatusFieldClicked() {
    }

    protected String getStatusFieldText() {
        return "";
    }

    public StringMatcher getStringMatcher() {
        return this.myStringMatcher;
    }

    private void installFilter() {
        this.myFilterText.setText("");
        this.myFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                int length = text.length();
                if (length > 0 && text.charAt(length - 1) != '*') {
                    text = String.valueOf(text) + '*';
                }
                AbstractInformationControl.this.setMatcherString(text, true);
            }
        });
    }

    protected void stringMatcherUpdated() {
        this.myTreeViewer.getControl().setRedraw(false);
        this.myTreeViewer.refresh();
        this.myTreeViewer.expandAll();
        this.selectFirstMatch();
        this.myTreeViewer.getControl().setRedraw(true);
    }

    protected void setMatcherString(String pattern, boolean update) {
        if (pattern.length() == 0) {
            this.myStringMatcher = null;
        } else {
            boolean ignoreCase = pattern.toLowerCase().equals(pattern);
            this.myStringMatcher = new StringMatcher(pattern, ignoreCase, false);
        }
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    protected Object getSelectedElement() {
        if (this.myTreeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.myTreeViewer.getSelection()).getFirstElement();
    }

    private void gotoSelectedElement() {
        ClassifierDefCS classifierDefCS;
        Object selectedElement = this.getSelectedElement();
        SimpleNameCS cstNode = null;
        if (selectedElement instanceof MappingMethodCS) {
            MappingMethodCS mappingMethodCS = (MappingMethodCS)selectedElement;
            MappingDeclarationCS mappingDeclarationCS = mappingMethodCS.getMappingDeclarationCS();
            if (mappingDeclarationCS != null) {
                cstNode = AbstractInformationControl.getLinkDestinationNode(mappingDeclarationCS);
            }
        } else if (selectedElement instanceof ModulePropertyCS) {
            ModulePropertyCS modulePropertyCS = (ModulePropertyCS)selectedElement;
            cstNode = modulePropertyCS.getSimpleNameCS();
            if (cstNode == null) {
                cstNode = modulePropertyCS;
            }
        } else if (selectedElement instanceof MappingModuleCS) {
            MappingModuleCS mappingModuleCS = (MappingModuleCS)selectedElement;
            TransformationHeaderCS headerCS = mappingModuleCS.getHeaderCS();
            if (headerCS != null) {
                cstNode = headerCS.getPathNameCS();
            }
        } else if (selectedElement instanceof ClassifierDefCS && (cstNode = (classifierDefCS = (ClassifierDefCS)selectedElement).getSimpleNameCS()) == null) {
            cstNode = classifierDefCS;
        }
        if (cstNode != null) {
            this.dispose();
            URI sourceFileURI = CSTHelper.getSourceFile((CSTNode)cstNode);
            IRegion destReg = HyperlinkUtil.createRegion((CSTNode)cstNode);
            QvtFileHyperlink qvtFileHyperlink = new QvtFileHyperlink((IRegion)new Region(0, 0), sourceFileURI, destReg, destReg);
            qvtFileHyperlink.open();
        }
    }

    private static CSTNode getLinkDestinationNode(MappingDeclarationCS mappingDeclCS) {
        SimpleNameCS linkDestCS = mappingDeclCS.getSimpleNameCS();
        if (linkDestCS == null) {
            linkDestCS = mappingDeclCS;
        }
        return linkDestCS;
    }

    protected void selectFirstMatch() {
        Tree tree = this.myTreeViewer.getTree();
        Object element = this.findElement(tree.getItems());
        if (element != null) {
            this.myTreeViewer.setSelection((ISelection)new StructuredSelection(element), true);
        } else {
            this.myTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    protected Object findElement(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            Object element = items[i].getData();
            if (this.isStringMatcherOk(element)) {
                return element;
            }
            element = this.findElement(items[i].getItems());
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public boolean isStringMatcherOk(Object element) {
        if (this.myStringMatcher == null) {
            return true;
        }
        if (element != null) {
            ILabelProvider labelProvider = (ILabelProvider)this.myTreeViewer.getLabelProvider();
            String label = labelProvider.getText(element);
            return this.myStringMatcher.match(label) || this.matchesTextPattern(element);
        }
        return false;
    }

    protected boolean matchesTextPattern(Object element) {
        return false;
    }

    public void setInformation(String information) {
    }

    public abstract void setInput(Object var1);

    protected void fillViewMenu(IMenuManager viewMenu) {
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        this.fillViewMenu(dialogMenu);
    }

    protected void inputChanged(Object newInput, Object newSelection) {
        this.myFilterText.setText("");
        this.myTreeViewer.setInput(newInput);
        if (newSelection != null) {
            this.myTreeViewer.setSelection((ISelection)new StructuredSelection(newSelection));
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.removeHandlerAndKeyBindingSupport();
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public int open() {
        this.addHandlerAndKeyBindingSupport();
        return super.open();
    }

    public final void dispose() {
        this.close();
    }

    public void widgetDisposed(DisposeEvent event) {
        this.removeHandlerAndKeyBindingSupport();
        this.myTreeViewer = null;
        this.myFilterText = null;
    }

    protected void addHandlerAndKeyBindingSupport() {
        if (this.myShowViewMenuHandlerActivation == null) {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            LegacyHandlerSubmissionExpression expression = new LegacyHandlerSubmissionExpression(null, this.getShell(), null);
            this.myShowViewMenuHandlerActivation = handlerService.activateHandler(this.myShowViewMenuAction.getActionDefinitionId(), (IHandler)new ActionHandler(this.myShowViewMenuAction), (Expression)expression);
        }
    }

    protected void removeHandlerAndKeyBindingSupport() {
        if (this.myShowViewMenuHandlerActivation != null) {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            handlerService.deactivateHandler(this.myShowViewMenuHandlerActivation);
            this.myShowViewMenuHandlerActivation = null;
        }
    }

    public boolean hasContents() {
        return this.myTreeViewer != null && this.myTreeViewer.getInput() != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public boolean isFocusControl() {
        return this.getShell().getDisplay().getActiveShell() == this.getShell();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.myFilterText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    protected final Command getInvokingCommand() {
        return this.myInvokingCommand;
    }

    protected final TriggerSequence[] getInvokingCommandKeySequences() {
        if (this.myInvokingCommandKeySequences == null && this.getInvokingCommand() != null) {
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
            this.myInvokingCommandKeySequences = bindingService.getActiveBindingsFor(this.getInvokingCommand().getId());
            return this.myInvokingCommandKeySequences;
        }
        return this.myInvokingCommandKeySequences;
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName = this.getId();
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    protected Control createTitleMenuArea(Composite parent) {
        this.myViewMenuButtonComposite = (Composite)super.createTitleMenuArea(parent);
        if (this.hasHeader()) {
            this.myFilterText = this.createFilterText(parent);
        }
        this.myShowViewMenuAction = new Action("showViewMenu"){

            public void run() {
                AbstractInformationControl.this.showDialogMenu();
            }
        };
        this.myShowViewMenuAction.setEnabled(true);
        this.myShowViewMenuAction.setActionDefinitionId("org.eclipse.ui.window.showViewMenu");
        return this.myViewMenuButtonComposite;
    }

    protected Control createTitleControl(Composite parent) {
        if (this.hasHeader()) {
            return super.createTitleControl(parent);
        }
        this.myFilterText = this.createFilterText(parent);
        return this.myFilterText;
    }

    protected void setTabOrder(Composite composite) {
        if (this.hasHeader()) {
            composite.setTabList(new Control[]{this.myFilterText, this.myTreeViewer.getTree()});
        } else {
            this.myViewMenuButtonComposite.setTabList(new Control[]{this.myFilterText});
            composite.setTabList(new Control[]{this.myViewMenuButtonComposite, this.myTreeViewer.getTree()});
        }
    }
}

