/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.dialogs;

import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectSelectionDialog;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MavenModuleSelectionDialog
extends MavenProjectSelectionDialog {
    protected Set<Object> knownModules;
    protected boolean pomUpdateRequired = false;

    public MavenModuleSelectionDialog(Shell parent, Set<Object> knownModules) {
        super(parent, true);
        this.knownModules = knownModules;
        this.setTitle(Messages.OverviewPage_selectModuleProjects);
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        TreeViewer viewer = this.getViewer();
        viewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        viewer.getTree().addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (e.detail == 32) {
                TreeItem item = (TreeItem)e.item;
                Object data = item.getData();
                if (item.getChecked() && data instanceof IResource && this.knownModules.contains(((IResource)data).getLocation())) {
                    item.setChecked(false);
                }
            }
        }));
        viewer.getTree().setFocus();
        Button checkbox = new Button((Composite)control, 32);
        checkbox.setSelection(false);
        checkbox.setText(Messages.OverviewPage_updateModulePoms);
        checkbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.pomUpdateRequired = checkbox.getSelection();
        }));
        return control;
    }

    public boolean isPomUpdateRequired() {
        return this.pomUpdateRequired;
    }

    protected class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private final ILabelProvider labelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();

        protected ProjectLabelProvider() {
        }

        public String getText(Object element) {
            return this.labelProvider.getText(element);
        }

        public Image getImage(Object element) {
            return this.labelProvider.getImage(element);
        }

        public Color getForeground(Object element) {
            if (element instanceof IResource && MavenModuleSelectionDialog.this.knownModules.contains(((IResource)element).getLocation())) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

