/*********************************************************************
* Copyright (c) 2005, 2019 SAP SE
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which is available at https://www.eclipse.org/legal/epl-2.0/
*
* Contributors:
*    SAP SE - initial API, implementation and documentation
*    mgorning - Bug 343983 - Notification for Cancelled Reconnection Events
*    mlypik - Bug 401792 - Disable starting reconnection
*
* SPDX-License-Identifier: EPL-2.0
**********************************************************************/
package org.eclipse.graphiti.func;

import org.eclipse.graphiti.features.context.IReconnectionContext;

/**
 * The Interface IReconnection.
 * 
 * @noimplement This interface is not intended to be implemented by clients.
 * @noextend This interface is not intended to be extended by clients.
 */
public interface IReconnection {

	/**
	 * Can reconnect.
	 * 
	 * @param context
	 *            the context
	 * 
	 * @return true, if successful
	 */
	boolean canReconnect(IReconnectionContext context);

	/**
	 * Reconnnect.
	 * 
	 * @param context
	 *            the context
	 */
	void reconnect(IReconnectionContext context);

	/**
	 * Pre reconnnect.
	 * 
	 * @param context
	 *            the context
	 */
	void preReconnect(IReconnectionContext context);

	/**
	 * Post reconnnect.
	 * 
	 * @param context
	 *            the context
	 */
	void postReconnect(IReconnectionContext context);

	/**
	 * Will called if the connection reconnect process was canceled after
	 * dragging the start or end of the connection. E.g. user pressed ESC, user
	 * clicked on an invalid target, focus was lost, ...
	 * 
	 * @param context
	 *            the context
	 * 
	 * @since 0.9
	 */
	void canceledReconnect(IReconnectionContext context);

	/**
	 * Can start reconnect.
	 * 
	 * @param context
	 *            the context
	 * 
	 * @return true, if successful
	 * 
	 * @since 0.11
	 */
	boolean canStartReconnect(IReconnectionContext context);
}
