/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import java.util.HashMap;
import org.eclipse.cdt.internal.ui.preferences.formatter.TranslationUnitPreview;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.changes.CCompositeChange;
import org.eclipse.cdt.internal.ui.refactoring.dialogs.ValidatingLabeledTextField;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodWizard;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.Messages;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodToImplementConfig;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterInfo;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.refactoring.CTextFileChange;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class ParameterNamesInputPage
extends UserInputWizardPage {
    private static final int PREVIEW_UPDATE_DELAY = 500;
    private MethodToImplementConfig config;
    private TranslationUnitPreview translationUnitPreview;
    private Job delayedPreviewUpdater;
    private ImplementMethodWizard wizard;

    public ParameterNamesInputPage(MethodToImplementConfig config, ImplementMethodWizard wizard) {
        super(Messages.ParameterNamesInputPage_Title);
        this.config = config;
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite superComposite = new Composite(parent, 0);
        superComposite.setLayout((Layout)new GridLayout());
        this.setTitle(Messages.ImplementMethodInputPage_PageTitle);
        this.setMessage(Messages.ParameterNamesInputPage_CompleteMissingMails);
        ValidatingLabeledTextField validatingLabeledTextField = new ValidatingLabeledTextField(superComposite);
        validatingLabeledTextField.setLayoutData(new GridData(768));
        for (final ParameterInfo actParameterInfo : this.config.getParaHandler().getParameterInfos()) {
            String type = actParameterInfo.getTypeName();
            String content = actParameterInfo.getParameterName();
            boolean readOnly = !actParameterInfo.hasNewName();
            validatingLabeledTextField.addElement(type, content, readOnly, new ValidatingLabeledTextField.Validator(){

                @Override
                public void hasErrors() {
                    ParameterNamesInputPage.this.setPageComplete(false);
                }

                @Override
                public void hasNoErrors() {
                    ParameterNamesInputPage.this.setPageComplete(true);
                }

                @Override
                public boolean isValidInput(String newName) {
                    actParameterInfo.setParameterName(newName);
                    ParameterNamesInputPage.this.updatePreview();
                    return true;
                }
            });
        }
        this.createPreview(superComposite);
        this.setControl((Control)superComposite);
    }

    private InsertEdit getInsertEdit(CompositeChange compositeChange) {
        Change[] changeArray = compositeChange.getChildren();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit textEdit;
            MultiTextEdit multiEdit;
            CTextFileChange textFileChange;
            TextEdit edit;
            Change actChange = changeArray[n2];
            if (actChange instanceof CompositeChange) {
                return this.getInsertEdit((CompositeChange)actChange);
            }
            if (actChange instanceof CTextFileChange && (edit = (textFileChange = (CTextFileChange)actChange).getEdit()) instanceof MultiTextEdit && (multiEdit = (MultiTextEdit)edit).getChildrenSize() != 0 && (textEdit = multiEdit.getChildren()[0]) instanceof InsertEdit) {
                return (InsertEdit)textEdit;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFunctionDefinitionSignature(IProgressMonitor monitor) {
        try {
            ModificationCollector collector = new ModificationCollector();
            ImplementMethodRefactoring implementMethodRefactoring = (ImplementMethodRefactoring)this.wizard.getRefactoring();
            CCompositeChange finalChange = null;
            ImplementMethodRefactoring implementMethodRefactoring2 = implementMethodRefactoring;
            synchronized (implementMethodRefactoring2) {
                implementMethodRefactoring.createDefinition(collector, this.config, monitor);
                finalChange = collector.createFinalChange();
            }
            InsertEdit insertEdit = this.getInsertEdit(finalChange);
            if (insertEdit == null) {
                return Messages.ImplementMethodRefactoringPage_PreviewGenerationNotPossible;
            }
            return insertEdit.getText().trim();
        }
        catch (OperationCanceledException e) {
            return Messages.ImplementMethodRefactoringPage_PreviewCanceled;
        }
        catch (CoreException e) {
            return Messages.ImplementMethodRefactoringPage_PreviewGenerationNotPossible;
        }
    }

    private void createPreview(Composite superComposite) {
        this.translationUnitPreview = new TranslationUnitPreview(new HashMap<String, String>(), superComposite);
        this.translationUnitPreview.getControl().setLayoutData((Object)new GridData(768));
        this.delayedPreviewUpdater = new Job(Messages.ImplementMethodRefactoringPage_GeneratingPreview){

            protected IStatus run(IProgressMonitor monitor) {
                this.setPreviewText(Messages.ImplementMethodRefactoringPage_GeneratingPreview);
                String functionDefinitionSignature = ParameterNamesInputPage.this.createFunctionDefinitionSignature(monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.setPreviewText(functionDefinitionSignature);
                return Status.OK_STATUS;
            }

            private void setPreviewText(String text) {
                Display display;
                Shell shell = ParameterNamesInputPage.this.getShell();
                if (shell != null && (display = shell.getDisplay()) != null) {
                    display.asyncExec(() -> {
                        Control control = ParameterNamesInputPage.this.translationUnitPreview.getControl();
                        if (control != null && !control.isDisposed()) {
                            ParameterNamesInputPage.this.translationUnitPreview.setPreviewText(text);
                        }
                    });
                }
            }
        };
        this.delayedPreviewUpdater.schedule(500L);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        MethodToImplementConfig nextConfig = ((ImplementMethodRefactoring)this.wizard.getRefactoring()).getRefactoringData().getNextConfigNeedingParameterNames(this.config);
        if (nextConfig != null) {
            return this.wizard.getPageForConfig(nextConfig);
        }
        this.wizard.cancelAndJoinPreviewJobs();
        return this.computeSuccessorPage();
    }

    protected boolean cancelPreviewJob() {
        if (this.delayedPreviewUpdater == null) {
            return false;
        }
        if (this.delayedPreviewUpdater.getState() != 0) {
            this.translationUnitPreview.setPreviewText(Messages.ImplementMethodRefactoringPage_PreviewCanceled);
        }
        return !this.delayedPreviewUpdater.cancel();
    }

    protected void joinPreviewJob() {
        if (this.delayedPreviewUpdater == null) {
            return;
        }
        try {
            this.delayedPreviewUpdater.join();
        }
        catch (InterruptedException e) {
            CUIPlugin.log(e);
        }
    }

    private void updatePreview() {
        if (this.translationUnitPreview == null) {
            return;
        }
        this.delayedPreviewUpdater.schedule(500L);
    }

    public boolean isPageComplete() {
        if (!this.config.isChecked()) {
            return true;
        }
        return super.isPageComplete();
    }
}

