/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.prettify.common;

import com.google.gerrit.prettify.common.PrettifyConstants;
import com.google.gerrit.prettify.common.SparseFileContent;
import com.google.gerrit.prettify.common.SparseHtmlFile;
import com.google.gerrit.reviewdb.AccountDiffPreference;
import com.google.gwtexpui.safehtml.client.SafeHtml;
import com.google.gwtexpui.safehtml.client.SafeHtmlBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.ReplaceEdit;

public abstract class PrettyFormatter
implements SparseHtmlFile {
    public static final EditFilter A = new EditFilter(){

        @Override
        String getStyleName() {
            return "wdd";
        }

        @Override
        int getBegin(Edit edit) {
            return edit.getBeginA();
        }

        @Override
        int getEnd(Edit edit) {
            return edit.getEndA();
        }
    };
    public static final EditFilter B = new EditFilter(){

        @Override
        String getStyleName() {
            return "wdi";
        }

        @Override
        int getBegin(Edit edit) {
            return edit.getBeginB();
        }

        @Override
        int getEnd(Edit edit) {
            return edit.getEndB();
        }
    };
    protected SparseFileContent content;
    protected EditFilter side;
    protected List<Edit> edits;
    protected AccountDiffPreference diffPrefs;
    protected String fileName;
    protected Set<Integer> trailingEdits;
    private int col;
    private int lineIdx;
    private Tag lastTag;
    private StringBuilder buf;

    @Override
    public SafeHtml getSafeHtmlLine(int lineNo) {
        return SafeHtml.asis((String)this.content.get(lineNo));
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    public boolean contains(int idx) {
        return this.content.contains(idx);
    }

    @Override
    public boolean hasTrailingEdit(int idx) {
        return this.trailingEdits.contains(idx);
    }

    public void setEditFilter(EditFilter f) {
        this.side = f;
    }

    public void setEditList(List<Edit> all) {
        this.edits = all;
    }

    public void setDiffPrefs(AccountDiffPreference how) {
        this.diffPrefs = how;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void format(SparseFileContent src) {
        this.content = new SparseFileContent();
        this.content.setSize(src.size());
        this.trailingEdits = new HashSet<Integer>();
        String html = this.toHTML(src);
        if (this.diffPrefs.isSyntaxHighlighting() && this.getFileType() != null && src.isWholeFile()) {
            html = html.replaceAll("&#39;", "'");
            html = this.prettify(html, this.getFileType());
        } else {
            html = this.expandTabs(html);
            html = html.replaceAll("\n", "<br />");
        }
        int pos = 0;
        int textChunkStart = 0;
        this.lastTag = Tag.NULL;
        this.col = 0;
        this.lineIdx = 0;
        this.buf = new StringBuilder();
        while (pos <= html.length()) {
            int tagStart = html.indexOf(60, pos);
            if (tagStart < 0) {
                assert (this.lastTag == Tag.NULL);
                pos = html.length();
                if (textChunkStart < pos) {
                    this.htmlText(html.substring(textChunkStart, pos));
                }
                if (0 >= this.buf.length()) break;
                this.content.addLine(src.mapIndexToLine(this.lineIdx), this.buf.toString());
                break;
            }
            int tagEnd = html.indexOf(62, tagStart);
            assert (tagStart < tagEnd);
            pos = tagEnd + 1;
            if (textChunkStart < tagStart) {
                this.lastTag.open(this.buf, html);
                this.htmlText(html.substring(textChunkStart, tagStart));
            }
            textChunkStart = pos;
            if (PrettyFormatter.isBR(html, tagStart, tagEnd)) {
                this.lastTag.close(this.buf, html);
                this.content.addLine(src.mapIndexToLine(this.lineIdx), this.buf.toString());
                this.buf = new StringBuilder();
                this.col = 0;
                ++this.lineIdx;
                continue;
            }
            if (html.charAt(tagStart + 1) == '/') {
                this.lastTag = this.lastTag.pop(this.buf, html);
                continue;
            }
            if (html.charAt(tagEnd - 1) == '/') continue;
            this.lastTag = new Tag(this.lastTag, tagStart, tagEnd);
        }
        this.buf = null;
    }

    private void htmlText(String txt) {
        int start;
        int pos = 0;
        while (pos < txt.length() && (start = txt.indexOf(38, pos)) >= 0) {
            this.cleanText(txt, pos, start);
            pos = txt.indexOf(59, start + 1) + 1;
            if (this.diffPrefs.getLineLength() <= this.col) {
                this.buf.append("<br />");
                this.col = 0;
            }
            this.buf.append(txt.substring(start, pos));
            ++this.col;
        }
        this.cleanText(txt, pos, txt.length());
    }

    private void cleanText(String txt, int pos, int end) {
        while (pos < end) {
            int free = this.diffPrefs.getLineLength() - this.col;
            if (free <= 0) {
                this.buf.append("<br />");
                this.col = 0;
                free = this.diffPrefs.getLineLength();
            }
            int n = Math.min(end - pos, free);
            this.buf.append(txt.substring(pos, pos + n));
            this.col += n;
            pos += n;
        }
    }

    protected abstract String prettify(String var1, String var2);

    private static boolean isBR(String html, int tagStart, int tagEnd) {
        return tagEnd - tagStart == 5 && html.charAt(tagStart + 1) == 'b' && html.charAt(tagStart + 2) == 'r' && html.charAt(tagStart + 3) == ' ';
    }

    private String toHTML(SparseFileContent src) {
        SafeHtml html;
        if (this.diffPrefs.isIntralineDifference()) {
            html = this.colorLineEdits(src);
        } else {
            SafeHtmlBuilder b = new SafeHtmlBuilder();
            int index = src.first();
            while (index < src.size()) {
                b.append(src.get(index));
                b.append('\n');
                index = src.next(index);
            }
            html = b;
            String r = "<span class=\"wse\" title=\"" + PrettifyConstants.C.wseBareCR() + "\"" + ">&nbsp;</span>$1";
            html = html.replaceAll("\r([^\n])", r);
        }
        if (this.diffPrefs.isShowWhitespaceErrors()) {
            html = this.showTabAfterSpace(html);
            html = this.showTrailingWhitespace(html);
        }
        if (this.diffPrefs.isShowTabs()) {
            String t = 1 < this.diffPrefs.getTabSize() ? "\t" : "";
            html = html.replaceAll("\t", "<span class=\"vt\">\u00bb</span>" + t);
        }
        return html.asString();
    }

    private SafeHtml colorLineEdits(SparseFileContent src) {
        ArrayList<Edit> edits = new ArrayList<Edit>(this.edits.size() + 1);
        edits.addAll(this.edits);
        edits.add(new Edit(src.size(), src.size()));
        SafeHtmlBuilder buf = new SafeHtmlBuilder();
        int curIdx = 0;
        Edit curEdit = (Edit)edits.get(curIdx);
        ReplaceEdit lastReplace = null;
        List charEdits = null;
        int lastPos = 0;
        int lastIdx = 0;
        int index = src.first();
        while (index < src.size()) {
            int cmp = this.compare(index, curEdit);
            while (0 < cmp) {
                curEdit = (Edit)edits.get(curIdx++);
                cmp = this.compare(index, curEdit);
            }
            if (cmp < 0) {
                this.appendShowBareCR(buf, src.get(index), true);
                buf.append('\n');
            } else if (curEdit instanceof ReplaceEdit) {
                if (lastReplace != curEdit) {
                    lastReplace = (ReplaceEdit)curEdit;
                    charEdits = lastReplace.getInternalEdits();
                    lastPos = 0;
                    lastIdx = 0;
                }
                String line = src.get(index) + "\n";
                int c = 0;
                while (c < line.length()) {
                    if (charEdits.size() <= lastIdx) {
                        this.appendShowBareCR(buf, line.substring(c), false);
                        break;
                    }
                    Edit edit = (Edit)charEdits.get(lastIdx);
                    int b = this.side.getBegin(edit) - lastPos;
                    int e = this.side.getEnd(edit) - lastPos;
                    if (c < b) {
                        int cmnLen = Math.min(b, line.length());
                        buf.openSpan();
                        buf.setStyleName("wdc");
                        this.appendShowBareCR(buf, line.substring(c, cmnLen), cmnLen == line.length() - 1);
                        buf.closeSpan();
                        c = cmnLen;
                    }
                    int modLen = Math.min(e, line.length());
                    if (c < e && c < modLen) {
                        buf.openSpan();
                        buf.setStyleName(this.side.getStyleName());
                        this.appendShowBareCR(buf, line.substring(c, modLen), modLen == line.length() - 1);
                        buf.closeSpan();
                        if (modLen == line.length()) {
                            this.trailingEdits.add(index);
                        }
                        c = modLen;
                    }
                    if (e > c) continue;
                    ++lastIdx;
                }
                lastPos += line.length();
            } else {
                this.appendShowBareCR(buf, src.get(index), true);
                buf.append('\n');
            }
            index = src.next(index);
        }
        return buf;
    }

    private void appendShowBareCR(SafeHtmlBuilder buf, String src, boolean end) {
        while (!src.isEmpty()) {
            int cr = src.indexOf(13);
            if (cr < 0) {
                buf.append(src);
                return;
            }
            if (end) {
                if (cr == src.length() - 1) {
                    buf.append(src.substring(0, cr));
                    return;
                }
            } else if (cr == src.length() - 2 && src.charAt(cr + 1) == '\n') {
                buf.append(src.substring(0, cr));
                buf.append('\n');
                return;
            }
            buf.append(src.substring(0, cr));
            buf.openSpan();
            buf.setStyleName("wse");
            buf.setAttribute("title", PrettifyConstants.C.wseBareCR());
            buf.nbsp();
            buf.closeSpan();
            src = src.substring(cr + 1);
        }
    }

    private int compare(int index, Edit edit) {
        if (index < this.side.getBegin(edit)) {
            return -1;
        }
        if (index < this.side.getEnd(edit)) {
            return 0;
        }
        return 1;
    }

    private SafeHtml showTabAfterSpace(SafeHtml src) {
        String m = "( ( |<span[^>]*>|</span>)*\t)";
        String r = "<span class=\"wse\" title=\"" + PrettifyConstants.C.wseTabAfterSpace() + "\"" + ">$1</span>";
        src = src.replaceFirst("^( ( |<span[^>]*>|</span>)*\t)", r);
        src = src.replaceAll("\n( ( |<span[^>]*>|</span>)*\t)", "\n" + r);
        return src;
    }

    private SafeHtml showTrailingWhitespace(SafeHtml src) {
        String r = "<span class=\"wse\" title=\"" + PrettifyConstants.C.wseTrailingSpace() + "\"" + ">$1</span>$2";
        src = src.replaceAll("([ \t][ \t]*)(\r?(</span>)?\n)", r);
        src = src.replaceFirst("([ \t][ \t]*)(\r?(</span>)?\n?)$", r);
        return src;
    }

    private String expandTabs(String html) {
        StringBuilder tmp = new StringBuilder();
        int i = 0;
        if (this.diffPrefs.isShowTabs()) {
            i = 1;
        }
        while (i < this.diffPrefs.getTabSize()) {
            tmp.append("&nbsp;");
            ++i;
        }
        return html.replaceAll("\t", tmp.toString());
    }

    private String getFileType() {
        String srcType = this.fileName;
        if (srcType == null) {
            return null;
        }
        int dot = srcType.lastIndexOf(46);
        if (dot < 0) {
            return null;
        }
        if (0 < dot) {
            srcType = srcType.substring(dot + 1);
        }
        if ("txt".equalsIgnoreCase(srcType)) {
            return null;
        }
        return srcType;
    }

    public static abstract class EditFilter {
        abstract String getStyleName();

        abstract int getBegin(Edit var1);

        abstract int getEnd(Edit var1);
    }

    private static class Tag {
        static final Tag NULL = new Tag(null, 0, 0){

            @Override
            void open(StringBuilder buf, String html) {
            }

            @Override
            void close(StringBuilder buf, String html) {
            }

            @Override
            Tag pop(StringBuilder buf, String html) {
                return this;
            }
        };
        final Tag parent;
        final int start;
        final int end;
        boolean open;

        Tag(Tag p, int s, int e) {
            this.parent = p;
            this.start = s;
            this.end = e;
        }

        void open(StringBuilder buf, String html) {
            if (!this.open) {
                this.parent.open(buf, html);
                buf.append(html.substring(this.start, this.end + 1));
                this.open = true;
            }
        }

        void close(StringBuilder buf, String html) {
            this.pop(buf, html);
            this.parent.close(buf, html);
        }

        Tag pop(StringBuilder buf, String html) {
            if (this.open) {
                int sp = html.indexOf(32, this.start + 1);
                if (sp < 0 || this.end < sp) {
                    sp = this.end;
                }
                buf.append("</");
                buf.append(html.substring(this.start + 1, sp));
                buf.append('>');
                this.open = false;
            }
            return this.parent;
        }
    }
}

