/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard.cli;

import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.wizard.AbstractFile;
import org.eclipse.xtext.xtext.wizard.BinaryFile;
import org.eclipse.xtext.xtext.wizard.ProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.ProjectsCreator;
import org.eclipse.xtext.xtext.wizard.SourceFolderDescriptor;
import org.eclipse.xtext.xtext.wizard.TextFile;
import org.eclipse.xtext.xtext.wizard.WizardConfiguration;

public class CliProjectsCreator
implements ProjectsCreator {
    @Accessors
    private String lineDelimiter;

    @Override
    public void createProjects(WizardConfiguration config) {
        Consumer<ProjectDescriptor> _function = it -> this.createProject((ProjectDescriptor)it);
        config.getEnabledProjects().forEach(_function);
    }

    public void createProject(ProjectDescriptor project) {
        String _location = project.getLocation();
        File projectRoot = new File(_location);
        projectRoot.mkdirs();
        Consumer<AbstractFile> _function = it -> {
            try {
                boolean _isExecutable;
                String _pathFor = project.getConfig().getSourceLayout().getPathFor(it.getOutlet());
                String _plus = _pathFor + "/";
                String _relativePath = it.getRelativePath();
                String projectRelativePath = _plus + _relativePath;
                File file = new File(projectRoot, projectRelativePath);
                file.getParentFile().mkdirs();
                boolean _matched = false;
                if (it instanceof TextFile) {
                    _matched = true;
                    String normalizedContent = ((TextFile)it).getContent().replace(Strings.newLine(), this.lineDelimiter);
                    Files.write((CharSequence)normalizedContent, (File)file, (Charset)project.getConfig().getEncoding());
                }
                if (!_matched && it instanceof BinaryFile) {
                    _matched = true;
                    Files.write((byte[])Resources.toByteArray((URL)((BinaryFile)it).getContent()), (File)file);
                }
                if (_isExecutable = it.isExecutable()) {
                    file.setExecutable(true);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        project.getFiles().forEach(_function);
        Consumer<SourceFolderDescriptor> _function_1 = it -> {
            String _path = it.getPath();
            new File(projectRoot, _path).mkdirs();
        };
        project.getSourceFolders().forEach(_function_1);
    }

    @Pure
    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }
}

