/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.wb.core.gef.header.Headers;
import org.eclipse.wb.core.gef.header.IHeaderMenuProvider;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.ParentTargetDragEditPartTracker;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDimensionInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DimensionHeaderEditPart<C extends IControlInfo>
extends GraphicalEditPart
implements IHeaderMenuProvider {
    protected static final Color COLOR_NORMAL = Headers.COLOR_HEADER;
    protected static final Font DEFAULT_FONT = new Font(null, "Arial", 7, 0);
    protected final IGridLayoutInfo<C> m_layout;
    protected final GridDimensionInfo<C> m_dimension;
    private final Figure m_containerFigure;

    public DimensionHeaderEditPart(IGridLayoutInfo<C> layout, GridDimensionInfo<C> dimension, Figure containerFigure) {
        this.m_layout = layout;
        this.m_dimension = dimension;
        this.m_containerFigure = containerFigure;
        this.setModel(dimension);
    }

    public final IGridLayoutInfo<C> getLayout() {
        return this.m_layout;
    }

    public final GridDimensionInfo<C> getDimension() {
        return this.m_dimension;
    }

    public final Point getOffset() {
        Point offset = new Point(0, 0);
        FigureUtils.translateFigureToAbsolute2((Figure)this.m_containerFigure, (Translatable)offset);
        offset.translate(this.m_layout.getComposite().getClientAreaInsets());
        return offset;
    }

    public final Tool getDragTrackerTool(Request request) {
        return new ParentTargetDragEditPartTracker((EditPart)this);
    }

    protected void refreshVisuals() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                DimensionHeaderEditPart.this.getFigure().setToolTipText(DimensionHeaderEditPart.this.m_dimension.getTitle());
                DimensionHeaderEditPart.this.getFigure().setBackground(COLOR_NORMAL);
            }
        });
    }

    public void performRequest(Request request) {
        super.performRequest(request);
        if (request.getType() == "open") {
            ExecutionUtils.run((ObjectInfo)this.m_layout.getUnderlyingModel(), (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    DimensionHeaderEditPart.this.m_dimension.flipGrab();
                }
            });
        }
    }
}

