/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ast.binding;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.wb.internal.core.utils.ast.binding.BindingContext;
import org.eclipse.wb.internal.core.utils.ast.binding.DesignerPackageBinding;

public final class DesignerTypeBinding
implements ITypeBinding {
    private final IPackageBinding m_packageBinding;
    private final String m_name;
    private final String m_key;
    private final boolean m_class;
    private final boolean m_primitive;
    private final boolean m_nullType;
    private final boolean m_interface;
    private final boolean m_enum;
    private final boolean m_topLevel;
    private final boolean m_member;
    private final boolean m_nested;
    private final boolean m_local;
    private final boolean m_anonymous;
    private final boolean m_genericType;
    private final boolean m_parameterizedType;
    private final boolean m_typeVariable;
    private ITypeBinding m_typeDeclaration;
    private ITypeBinding[] m_typeArguments;
    private ITypeBinding[] m_typeParameters;
    private ITypeBinding[] m_typeBounds;
    private final int m_modifiers;
    private final int m_declaredModifiers;
    private final boolean m_array;
    private final ITypeBinding m_elementType;
    private final int m_dimensions;
    private final ITypeBinding m_declaringClass;
    private final ITypeBinding m_superclass;
    private ITypeBinding[] m_interfaces;
    private final IMethodBinding[] m_declaredMethods;

    DesignerTypeBinding(BindingContext context, String fullyQualifiedName, ITypeBinding binding) {
        IPackageBinding jdtPackageBinding;
        if (fullyQualifiedName != null) {
            context.register(fullyQualifiedName, this);
        }
        this.m_packageBinding = (jdtPackageBinding = binding.getPackage()) != null ? new DesignerPackageBinding(jdtPackageBinding) : null;
        this.m_name = binding.getName();
        this.m_key = binding.getKey();
        this.m_class = binding.isClass();
        this.m_primitive = binding.isPrimitive();
        this.m_nullType = binding.isNullType();
        this.m_interface = binding.isInterface();
        this.m_enum = binding.isEnum();
        this.m_topLevel = binding.isTopLevel();
        this.m_nested = binding.isNested();
        this.m_member = binding.isMember();
        this.m_local = binding.isLocal();
        this.m_anonymous = binding.isAnonymous();
        this.m_genericType = binding.isGenericType();
        this.m_parameterizedType = binding.isParameterizedType();
        this.m_typeVariable = binding.isTypeVariable();
        ITypeBinding typeDeclaration = binding.getTypeDeclaration();
        this.m_typeDeclaration = typeDeclaration == binding ? this : context.get(typeDeclaration);
        ITypeBinding[] typeArguments = binding.getTypeArguments();
        this.m_typeArguments = new ITypeBinding[typeArguments.length];
        int i = 0;
        while (i < typeArguments.length) {
            ITypeBinding typeArgument = typeArguments[i];
            this.m_typeArguments[i] = context.get(typeArgument, true);
            ++i;
        }
        ITypeBinding[] typeBounds = binding.getTypeBounds();
        this.m_typeBounds = new ITypeBinding[typeBounds.length];
        i = 0;
        while (i < typeBounds.length) {
            ITypeBinding typeBound = typeBounds[i];
            this.m_typeBounds[i] = context.get(typeBound);
            ++i;
        }
        ITypeBinding[] typeParameters = binding.getTypeParameters();
        this.m_typeParameters = new ITypeBinding[typeParameters.length];
        i = 0;
        while (i < typeParameters.length) {
            ITypeBinding typeParameter = typeParameters[i];
            this.m_typeParameters[i] = context.get(typeParameter);
            ++i;
        }
        this.m_modifiers = binding.getModifiers();
        this.m_declaredModifiers = binding.getDeclaredModifiers();
        this.m_array = binding.isArray();
        this.m_elementType = binding.getElementType() != null ? context.get(binding.getElementType()) : null;
        this.m_dimensions = binding.getDimensions();
        this.m_declaringClass = context.get(binding.getDeclaringClass());
        this.m_superclass = context.get(binding.getSuperclass(), true);
        ITypeBinding[] jdtInterfaces = binding.getInterfaces();
        this.m_interfaces = new ITypeBinding[jdtInterfaces.length];
        i = 0;
        while (i < jdtInterfaces.length) {
            ITypeBinding jdtInterface = jdtInterfaces[i];
            this.m_interfaces[i] = context.get(jdtInterface);
            ++i;
        }
        IMethodBinding[] methods = binding.getDeclaredMethods();
        this.m_declaredMethods = new IMethodBinding[methods.length];
        i = 0;
        while (i < methods.length) {
            IMethodBinding method = methods[i];
            this.m_declaredMethods[i] = context.get(method);
            ++i;
        }
    }

    public void addInterface(ITypeBinding typeBinding) {
        ITypeBinding[] newInterfaces = new ITypeBinding[this.m_interfaces.length + 1];
        System.arraycopy(this.m_interfaces, 0, newInterfaces, 0, this.m_interfaces.length);
        newInterfaces[newInterfaces.length - 1] = typeBinding;
        this.m_interfaces = newInterfaces;
    }

    public String toString() {
        throw new IllegalArgumentException();
    }

    public String getBinaryName() {
        throw new IllegalArgumentException();
    }

    public boolean isPrimitive() {
        return this.m_primitive;
    }

    public boolean isNullType() {
        return this.m_nullType;
    }

    public boolean isArray() {
        return this.m_array;
    }

    public ITypeBinding getElementType() {
        return this.m_elementType;
    }

    public int getDimensions() {
        return this.m_dimensions;
    }

    public boolean isClass() {
        return this.m_class;
    }

    public boolean isInterface() {
        return this.m_interface;
    }

    public boolean isEnum() {
        return this.m_enum;
    }

    public boolean isAnnotation() {
        throw new IllegalArgumentException();
    }

    public ITypeBinding[] getTypeParameters() {
        return this.m_typeParameters;
    }

    public boolean isTypeVariable() {
        return this.m_typeVariable;
    }

    public ITypeBinding[] getTypeBounds() {
        return this.m_typeBounds;
    }

    public boolean isParameterizedType() {
        return this.m_parameterizedType;
    }

    public ITypeBinding[] getTypeArguments() {
        return this.m_typeArguments;
    }

    public ITypeBinding getErasure() {
        throw new IllegalArgumentException();
    }

    public boolean isRawType() {
        throw new IllegalArgumentException();
    }

    public boolean isWildcardType() {
        throw new IllegalArgumentException();
    }

    public ITypeBinding getBound() {
        throw new IllegalArgumentException();
    }

    public boolean isUpperbound() {
        throw new IllegalArgumentException();
    }

    public String getName() {
        return this.m_name;
    }

    public IPackageBinding getPackage() {
        return this.m_packageBinding;
    }

    public ITypeBinding getDeclaringClass() {
        return this.m_declaringClass;
    }

    public ITypeBinding getSuperclass() {
        return this.m_superclass;
    }

    public ITypeBinding[] getInterfaces() {
        return this.m_interfaces;
    }

    public int getModifiers() {
        return this.m_modifiers;
    }

    public int getDeclaredModifiers() {
        return this.m_declaredModifiers;
    }

    public boolean isTopLevel() {
        return this.m_topLevel;
    }

    public boolean isNested() {
        return this.m_nested;
    }

    public boolean isMember() {
        return this.m_member;
    }

    public boolean isLocal() {
        return this.m_local;
    }

    public boolean isAnonymous() {
        return this.m_anonymous;
    }

    public ITypeBinding[] getDeclaredTypes() {
        throw new IllegalArgumentException();
    }

    public IVariableBinding[] getDeclaredFields() {
        throw new IllegalArgumentException();
    }

    public IMethodBinding[] getDeclaredMethods() {
        return this.m_declaredMethods;
    }

    public boolean isFromSource() {
        throw new IllegalArgumentException();
    }

    public String getQualifiedName() {
        throw new IllegalArgumentException();
    }

    public int getKind() {
        throw new IllegalArgumentException();
    }

    public boolean isDeprecated() {
        throw new IllegalArgumentException();
    }

    public boolean isSynthetic() {
        throw new IllegalArgumentException();
    }

    public IJavaElement getJavaElement() {
        throw new IllegalArgumentException();
    }

    public String getKey() {
        return this.m_key;
    }

    public boolean isEqualTo(IBinding binding) {
        throw new IllegalArgumentException();
    }

    public boolean isAssignmentCompatible(ITypeBinding type) {
        throw new IllegalArgumentException();
    }

    public boolean isCastCompatible(ITypeBinding type) {
        throw new IllegalArgumentException();
    }

    public boolean isGenericType() {
        return this.m_genericType;
    }

    public boolean isSubTypeCompatible(ITypeBinding type) {
        throw new IllegalArgumentException();
    }

    public ITypeBinding getTypeDeclaration() {
        return this.m_typeDeclaration;
    }

    public IMethodBinding getDeclaringMethod() {
        throw new IllegalArgumentException();
    }

    public ITypeBinding getWildcard() {
        throw new IllegalArgumentException();
    }

    public boolean isCapture() {
        throw new IllegalArgumentException();
    }

    public ITypeBinding getComponentType() {
        throw new IllegalArgumentException();
    }

    public IAnnotationBinding[] getAnnotations() {
        throw new IllegalArgumentException();
    }

    public ITypeBinding createArrayType(int dimension) {
        throw new IllegalArgumentException();
    }

    public boolean isRecovered() {
        throw new IllegalArgumentException();
    }

    public int getRank() {
        throw new IllegalArgumentException();
    }

    public ITypeBinding getGenericTypeOfWildcardType() {
        throw new IllegalArgumentException();
    }

    public IMethodBinding getFunctionalInterfaceMethod() {
        throw new IllegalArgumentException();
    }

    public IAnnotationBinding[] getTypeAnnotations() {
        throw new IllegalArgumentException();
    }

    public IBinding getDeclaringMember() {
        return null;
    }

    public boolean isIntersectionType() {
        return false;
    }
}

