/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.mailbox;

import org.eclipse.viatra.query.runtime.rete.network.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.indexer.MessageIndexer;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.MessageIndexerFactory;

public abstract class AbstractUpdateSplittingMailbox<IndexerType extends MessageIndexer, ReceiverType extends Receiver>
implements Mailbox {
    protected IndexerType monotoneQueue;
    protected IndexerType antiMonotoneQueue;
    protected IndexerType monotoneBuffer;
    protected IndexerType antiMonotoneBuffer;
    protected boolean deliveringMonotone;
    protected boolean deliveringAntiMonotone;
    protected final ReceiverType receiver;
    protected final ReteContainer container;
    protected CommunicationGroup group = null;

    public AbstractUpdateSplittingMailbox(ReceiverType receiver, ReteContainer container, MessageIndexerFactory<IndexerType> factory) {
        this.receiver = receiver;
        this.container = container;
        this.monotoneQueue = factory.create();
        this.antiMonotoneQueue = factory.create();
        this.monotoneBuffer = factory.create();
        this.antiMonotoneBuffer = factory.create();
        this.deliveringMonotone = false;
        this.deliveringAntiMonotone = false;
    }

    protected void swapAndClearMonotone() {
        IndexerType tmp = this.monotoneQueue;
        this.monotoneQueue = this.monotoneBuffer;
        this.monotoneBuffer = tmp;
        this.monotoneBuffer.clear();
    }

    protected void swapAndClearAntiMonotone() {
        IndexerType tmp = this.antiMonotoneQueue;
        this.antiMonotoneQueue = this.antiMonotoneBuffer;
        this.antiMonotoneBuffer = tmp;
        this.antiMonotoneBuffer.clear();
    }

    protected IndexerType getActiveMonotoneQueue() {
        if (this.deliveringMonotone) {
            return this.monotoneBuffer;
        }
        return this.monotoneQueue;
    }

    protected IndexerType getActiveAntiMonotoneQueue() {
        if (this.deliveringAntiMonotone) {
            return this.antiMonotoneBuffer;
        }
        return this.antiMonotoneQueue;
    }

    public ReceiverType getReceiver() {
        return this.receiver;
    }

    public void clear() {
        this.monotoneQueue.clear();
        this.antiMonotoneQueue.clear();
        this.monotoneBuffer.clear();
        this.antiMonotoneBuffer.clear();
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.group;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup group) {
        this.group = group;
    }

    @Override
    public boolean isEmpty() {
        return this.getActiveMonotoneQueue().isEmpty() && this.getActiveAntiMonotoneQueue().isEmpty();
    }
}

