/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IDataDrivenRuntimeObject;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.DataDrivenStateProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenEventHandler
implements IDataDrivenRuntimeObject {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("\\*");
    private final Pattern fEventName;
    private final List<DataDrivenAction> fStateChanges;

    public DataDrivenEventHandler(String eventName, List<DataDrivenAction> actions) {
        String name = WILDCARD_PATTERN.matcher(eventName).replaceAll(".*");
        this.fEventName = Pattern.compile(name);
        this.fStateChanges = actions;
    }

    private boolean appliesToEvent(ITmfEvent event) {
        String eventName = event.getName();
        return this.fEventName.matcher(eventName).matches();
    }

    public void handleEvent(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, DataDrivenStateProvider container) {
        if (!this.appliesToEvent(event)) {
            return;
        }
        this.fStateChanges.forEach(change -> change.eventHandle(event, scenarioInfo, container));
    }
}

