/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTreeBuilder;

public class FileContentCachingService {
    String[] fileDiffs;
    private CVSRepositoryLocation repository;
    private ICVSFolder remoteRoot;

    public static RemoteFolderTree buildRemoteTree(CVSRepositoryLocation repository, ICVSFolder root, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, 100);
        try {
            RemoteFolderTreeBuilder builder = new RemoteFolderTreeBuilder(repository, root, tag);
            RemoteFolderTree tree = builder.buildTree(new ICVSResource[]{root}, Policy.subMonitorFor(monitor, 50));
            FileContentCachingService service = new FileContentCachingService(repository, tree, builder.getFileDiffs());
            service.cacheFileContents(Policy.subMonitorFor(monitor, 50));
            RemoteFolderTree remoteFolderTree = tree;
            return remoteFolderTree;
        }
        finally {
            monitor.done();
        }
    }

    public static void fetchFileContents(RemoteFolderTree root, String[] filePaths, IProgressMonitor monitor) throws CVSException {
        FileContentCachingService service = new FileContentCachingService((CVSRepositoryLocation)root.getRepository(), root, filePaths);
        service.cacheFileContents(monitor);
    }

    public static RemoteFile buildRemoteTree(CVSRepositoryLocation repository, ICVSFile file, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, 100);
        try {
            RemoteFolderTreeBuilder builder = new RemoteFolderTreeBuilder(repository, file.getParent(), tag);
            RemoteFile remote = builder.buildTree(file, monitor);
            if (builder.getFileDiffs().length > 0) {
                remote.getStorage(Policy.subMonitorFor(monitor, 50));
            }
            RemoteFile remoteFile = remote;
            return remoteFile;
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
        finally {
            monitor.done();
        }
    }

    public FileContentCachingService(CVSRepositoryLocation repository, RemoteFolderTree tree, String[] fileDiffs) {
        this.repository = repository;
        this.remoteRoot = tree;
        this.fileDiffs = fileDiffs;
    }

    private void cacheFileContents(IProgressMonitor monitor) throws CVSException {
        String[] files = this.getUncachedFiles();
        if (files.length == 0) {
            return;
        }
        monitor.beginTask(null, 10 + files.length * 100);
        Policy.checkCanceled(monitor);
        Session session = new Session(this.repository, this.remoteRoot, false);
        session.open(Policy.subMonitorFor(monitor, 10), false);
        try {
            Policy.checkCanceled(monitor);
            IStatus status = Command.UPDATE.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, files, null, Policy.subMonitorFor(monitor, files.length * 100));
            if (!status.isOK()) {
                CVSProviderPlugin.log((CoreException)((Object)new CVSException(status)));
            }
        }
        finally {
            session.close();
            monitor.done();
        }
    }

    private String[] getUncachedFiles() {
        if (this.fileDiffs.length == 0) {
            return this.fileDiffs;
        }
        ArrayList<String> existing = new ArrayList<String>();
        int i = 0;
        while (i < this.fileDiffs.length) {
            String filePath = this.fileDiffs[i];
            try {
                ICVSFile file = this.remoteRoot.getFile(filePath);
                if (file instanceof RemoteFile && !((RemoteFile)file).isContentsCached()) {
                    existing.add(filePath);
                }
            }
            catch (CVSException cVSException) {}
            ++i;
        }
        return existing.toArray(new String[existing.size()]);
    }
}

