/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sirius.business.api.migration.AirdResourceVersionMismatchException;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.business.internal.migration.resource.MigrationUtil;
import org.eclipse.sirius.business.internal.session.SessionTransientAttachment;
import org.eclipse.sirius.business.internal.session.danalysis.SessionLazyCrossReferencer;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.common.tools.api.util.MarkerUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.impl.SessionManagerEObjectImpl;

public class SessionManagerImpl
extends SessionManagerEObjectImpl
implements SessionManager {
    private Set<SessionManagerListener> extensionPointListeners;
    private Set<SessionManagerListener> programmaticListeners = new LinkedHashSet<SessionManagerListener>();
    private Set<Viewpoint> selectedViewpoints = new HashSet<Viewpoint>();
    private final Map<Session, SessionListener> sessionsToListeners = new HashMap<Session, SessionListener>();

    public static SessionManagerImpl init() {
        return new SessionManagerImpl();
    }

    @Override
    public void addSessionsListener(SessionManagerListener listener) {
        this.programmaticListeners.add(listener);
    }

    @Override
    public Collection<Session> getSessions() {
        return Collections.unmodifiableCollection(this.doGetSessions());
    }

    private Collection<? extends Session> doGetSessions() {
        return this.sessionsToListeners.keySet();
    }

    @Override
    public void removeSessionsListener(SessionManagerListener listener) {
        this.programmaticListeners.remove(listener);
    }

    @Override
    public void add(final Session newSession) {
        Assert.isNotNull((Object)newSession, (String)Messages.SessionManagerImpl_cantAddNullSessionErrorMsg);
        if (!this.doGetSessions().contains(newSession)) {
            if (newSession instanceof DAnalysisSessionEObject) {
                this.getOwnedSessions().add((Object)((DAnalysisSessionEObject)((Object)newSession)));
            }
            SessionListener sessListener = new SessionListener(){

                @Override
                public void notify(int changeKind) {
                    if (changeKind == 0) {
                        SessionManagerImpl.this.fireVPSelectionDeselectionEvents();
                    }
                    SessionManagerImpl.this.notifyUpdatedSession(newSession, changeKind);
                }
            };
            newSession.addListener(sessListener);
            this.sessionsToListeners.put(newSession, sessListener);
            LinkedHashSet listenersToIterate = Sets.newLinkedHashSet(this.getAllListeners());
            for (SessionManagerListener listener : listenersToIterate) {
                listener.notifyAddSession(newSession);
            }
            this.fireVPSelectionDeselectionEvents();
        }
    }

    private void notifyUpdatedSession(Session newSession, int changeKind) {
        for (SessionManagerListener listener : Iterables.filter((Iterable)Lists.newArrayList(this.getAllListeners()), SessionManagerListener.class)) {
            listener.notify(newSession, changeKind);
        }
    }

    @Override
    public void remove(Session removedSession) {
        if (this.doGetSessions().contains(removedSession)) {
            this.getOwnedSessions().remove((Object)removedSession);
            SessionListener sessListener = this.sessionsToListeners.get(removedSession);
            if (sessListener != null) {
                removedSession.removeListener(sessListener);
            }
            this.sessionsToListeners.remove(removedSession);
            LinkedHashSet listenersToIterate = Sets.newLinkedHashSet(this.getAllListeners());
            for (SessionManagerListener listener : listenersToIterate) {
                listener.notifyRemoveSession(removedSession);
            }
            this.fireVPSelectionDeselectionEvents();
            if (this.sessionsToListeners.isEmpty()) {
                SiriusPlugin.getDefault().getModelAccessorRegistry().dispose();
            }
        }
    }

    @Override
    public Session getSession(EObject any) {
        Session found;
        block10: {
            found = null;
            if (any instanceof Resource) {
                found = this.getSession((Resource)any);
            } else if (any != null) {
                Option<SessionTransientAttachment> attachment;
                Optional<Adapter> slcr = any.eAdapters().stream().filter(SessionLazyCrossReferencer.class::isInstance).findFirst();
                if (slcr.isPresent()) {
                    found = ((SessionLazyCrossReferencer)slcr.get()).getSession();
                }
                if (found == null && (attachment = SessionTransientAttachment.getSessionTransientAttachement((Notifier)any)).some()) {
                    found = ((SessionTransientAttachment)((Object)attachment.get())).getSession();
                }
                if (found == null) {
                    try {
                        Resource resource;
                        Resource res;
                        EObject root = EcoreUtil.getRootContainer((EObject)any);
                        Resource resource2 = res = root != null ? root.eResource() : null;
                        if (res != null) {
                            found = this.getSession(res);
                        }
                        if (found == null && (resource = any.eResource()) != null) {
                            found = this.getSession(resource);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!SiriusPlugin.getDefault().isDebugging()) break block10;
                        SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", Messages.SessionManagerImpl_remoteServerConnectionErrorMsg));
                    }
                }
            }
        }
        return found;
    }

    @Override
    public Session getSession(Resource semanticResource) {
        Session found = null;
        Option<SessionTransientAttachment> attachment = SessionTransientAttachment.getSessionTransientAttachement((Notifier)semanticResource);
        if (attachment.some()) {
            found = ((SessionTransientAttachment)((Object)attachment.get())).getSession();
        }
        if (found == null) {
            Iterator<? extends Session> sessionsIter = this.doGetSessions().iterator();
            while (sessionsIter.hasNext() && found == null) {
                Session sess = sessionsIter.next();
                ArrayList<Resource> semanticResources = new ArrayList<Resource>(sess.getSemanticResources());
                if (semanticResources.contains(semanticResource)) {
                    found = sess;
                    continue;
                }
                if (!(sess instanceof DAnalysisSessionEObject) || !((DAnalysisSessionEObject)((Object)sess)).getControlledResources().contains((Object)semanticResource)) continue;
                found = sess;
            }
        }
        return found;
    }

    @Override
    public Session getSession(URI sessionModelURI, IProgressMonitor monitor) {
        Session session;
        Option<IResource> optionalResource = new URIQuery(sessionModelURI).getCorrespondingResource();
        if (optionalResource.some()) {
            MarkerUtil.removeMarkerFor((IResource)((IResource)optionalResource.get()), (String)"org.eclipse.sirius.viewpointMarker");
        }
        if ((session = this.lookForAlreadyLoadedSession(sessionModelURI)) == null) {
            try {
                session = SessionFactory.INSTANCE.createSession(sessionModelURI, monitor);
            }
            catch (CoreException e) {
                if (optionalResource.some()) {
                    MarkerUtil.addMarkerFor((IResource)((IResource)optionalResource.get()), (String)MessageFormat.format(Messages.SessionManagerImpl_representationsFileLoadingSeeErrorLogMsg, e.getCause() != null ? e.getCause().getMessage() : e.getMessage()), (int)2, (String)"org.eclipse.sirius.viewpointMarker");
                }
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
        return session;
    }

    @Override
    public Session getExistingSession(URI sessionResourceURI) {
        return this.lookForAlreadyLoadedSession(sessionResourceURI);
    }

    private Session lookForAlreadyLoadedSession(URI sessionModelURI) {
        Session alreadyLoadedSession = null;
        for (Session loadedSession : this.getSessions()) {
            if (!loadedSession.getSessionResource().getURI().equals(sessionModelURI)) continue;
            alreadyLoadedSession = loadedSession;
        }
        return alreadyLoadedSession;
    }

    @Override
    public void notifyRepresentationCreated(Session session) {
        if (this.doGetSessions().contains(session)) {
            this.notifyUpdatedSession(session, 10);
        }
    }

    @Override
    public void notifyRepresentationDeleted(Session session) {
        if (this.doGetSessions().contains(session)) {
            this.notifyUpdatedSession(session, 10);
        }
    }

    @Override
    public void notifyRepresentationRenamed(Session session) {
        if (this.doGetSessions().contains(session)) {
            this.notifyUpdatedSession(session, 10);
        }
    }

    private void fireVPSelectionDeselectionEvents() {
        Set<Viewpoint> newSelectedViewpoints = this.collectSelectedViewpoints();
        HashSet<Viewpoint> selectingViewpoints = new HashSet<Viewpoint>(newSelectedViewpoints);
        selectingViewpoints.removeAll(this.selectedViewpoints);
        for (Viewpoint viewpoint : selectingViewpoints) {
            this.fireSelectedViewpointEvent(viewpoint);
        }
        HashSet<Viewpoint> deselectingViewpoints = new HashSet<Viewpoint>(this.selectedViewpoints);
        deselectingViewpoints.removeAll(newSelectedViewpoints);
        for (Viewpoint viewpoint : deselectingViewpoints) {
            this.fireDeselectedViewpointEvent(viewpoint);
        }
        this.selectedViewpoints = newSelectedViewpoints;
    }

    private Set<Viewpoint> collectSelectedViewpoints() {
        HashSet<Viewpoint> result = new HashSet<Viewpoint>();
        for (Session session : this.doGetSessions()) {
            result.addAll(session.getSelectedViewpoints(false));
        }
        return result;
    }

    private void fireSelectedViewpointEvent(Viewpoint viewpoint) {
        for (SessionManagerListener listener : this.getAllListeners()) {
            listener.viewpointSelected(viewpoint);
        }
    }

    private void fireDeselectedViewpointEvent(Viewpoint viewpoint) {
        for (SessionManagerListener listener : this.getAllListeners()) {
            listener.viewpointDeselected(viewpoint);
        }
    }

    private synchronized Iterable<SessionManagerListener> getAllListeners() {
        return Iterables.concat(this.getExtensionPointListeners(), this.programmaticListeners);
    }

    private synchronized Set<SessionManagerListener> getExtensionPointListeners() {
        if (this.extensionPointListeners == null) {
            this.extensionPointListeners = new LinkedHashSet<SessionManagerListener>();
            this.extensionPointListeners.addAll(EclipseUtil.getExtensionPlugins(SessionManagerListener.class, (String)"org.eclipse.sirius.sessionManagerListener", (String)"class"));
        }
        return this.extensionPointListeners;
    }

    @Override
    public Session openSession(URI sessionResourceURI, IProgressMonitor monitor, UICallBack uiCallback) {
        return this.openSession(sessionResourceURI, monitor, uiCallback, false);
    }

    @Override
    public Session openSession(URI sessionResourceURI, IProgressMonitor monitor, UICallBack uiCallback, boolean isDirectUserActionLoading) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Session session = this.getSession(sessionResourceURI, (IProgressMonitor)subMonitor.newChild(30));
        if (session != null && !session.isOpen()) {
            try {
                session.open((IProgressMonitor)subMonitor.newChild(70));
            }
            catch (AirdResourceVersionMismatchException e) {
                session = null;
                if (uiCallback != null && uiCallback.askSessionReopeningWithResourceVersionMismatch(e)) {
                    try {
                        MigrationUtil.ignoreVersionMismatch = true;
                        session = this.getSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
                        session.open((IProgressMonitor)new NullProgressMonitor());
                    }
                    finally {
                        MigrationUtil.ignoreVersionMismatch = false;
                    }
                }
                throw e;
            }
        }
        for (Resource resource : session.getAllSessionResources()) {
            if (!(resource instanceof XMLResource)) continue;
            ((XMLResource)resource).getDefaultLoadOptions().put("RESOURCE_NON_BATCH_MIGRATION", isDirectUserActionLoading);
        }
        uiCallback.askUserAndSaveMigratedSession(session);
        subMonitor.done();
        return session;
    }
}

