/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.telnet.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ReadableByteChannel;
import org.eclipse.remote.telnet.core.TelnetCodes;
import org.eclipse.remote.telnet.core.TelnetCommandShell;
import org.eclipse.remote.telnet.core.TelnetOption;
import org.eclipse.remote.telnet.internal.core.Logger;
import org.eclipse.remote.telnet.internal.core.messages.Messages;

public class TelnetProtocol
extends Thread
implements TelnetCodes {
    protected static final int STATE_INITIAL = 0;
    protected static final int STATE_IAC_RECEIVED = 1;
    protected static final int STATE_WILL_RECEIVED = 2;
    protected static final int STATE_WONT_RECEIVED = 3;
    protected static final int STATE_DO_RECEIVED = 4;
    protected static final int STATE_DONT_RECEIVED = 5;
    protected static final int STATE_SUBNEGOTIATION_STARTED = 6;
    protected static final int STATE_RECEIVING_SUBNEGOTIATION = 7;
    protected static final int BUFFER_SIZE = 2048;
    protected ByteBuffer rawBytes = ByteBuffer.allocateDirect(2048);
    protected byte[] processedBytes = new byte[2048];
    protected StringBuffer processedStringBuffer = new StringBuffer(2048);
    protected int telnetState = 0;
    protected boolean remoteIsTelnetServer = false;
    protected TelnetOption[] localOptions = new TelnetOption[256];
    protected TelnetOption[] remoteOptions = new TelnetOption[256];
    protected byte[] receivedSubnegotiation = new byte[128];
    protected int nextSubnegotiationByteIndex = 0;
    protected boolean ignoreSubnegotiation = false;
    protected int width = 0;
    protected int height = 0;
    protected TelnetCommandShell shell;
    protected Socket socket;
    protected ReadableByteChannel inputChannel;
    protected OutputStream serverOutputStream;
    protected OutputStream clientOutputStream;
    protected boolean localEcho = true;

    public TelnetProtocol(Socket socket, TelnetCommandShell shell) throws IOException {
        Logger.log("entered");
        this.shell = shell;
        this.socket = socket;
        this.serverOutputStream = socket.getOutputStream();
        this.inputChannel = Channels.newChannel(socket.getInputStream());
        this.initializeOptions();
    }

    public OutputStream getOutputStream() {
        return this.serverOutputStream;
    }

    public void setClientOutputStream(OutputStream stream) {
        this.clientOutputStream = stream;
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    public boolean isRemoteTelnetServer() {
        return this.remoteIsTelnetServer;
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        Logger.log("Setting new size: width = " + newWidth + ", height = " + newHeight);
        if (!this.isConnected() || !this.isRemoteTelnetServer()) {
            return;
        }
        boolean sizeChanged = false;
        if (newWidth != this.width || newHeight != this.height) {
            sizeChanged = true;
        }
        this.width = newWidth;
        this.height = newHeight;
        if (sizeChanged && this.remoteIsTelnetServer && this.localOptions[31].isEnabled()) {
            Object[] sizeData = new Integer[]{this.width, this.height};
            this.localOptions[31].sendSubnegotiation(sizeData);
        }
    }

    public boolean localEcho() {
        return this.localEcho;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        Logger.log("Entered");
        try {
            try {
                while (this.socket.isConnected()) {
                    this.rawBytes.clear();
                    int nRawBytes = this.inputChannel.read(this.rawBytes);
                    if (nRawBytes == -1) {
                        Logger.log("End of input reading from socket!");
                        if (this.clientOutputStream != null) {
                            this.clientOutputStream.write(Messages.TelnetProtocol_0.getBytes());
                        }
                        break;
                    }
                    int nProcessedBytes = this.processTelnetProtocol(nRawBytes);
                    if (nProcessedBytes <= 0 || this.clientOutputStream == null) continue;
                    this.clientOutputStream.write(this.processedBytes, 0, nProcessedBytes);
                    this.clientOutputStream.flush();
                }
            }
            catch (ClosedByInterruptException nRawBytes) {
                this.shell.terminated();
                try {
                    if (this.inputChannel != null) {
                        this.inputChannel.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (this.serverOutputStream != null) {
                        this.serverOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (this.clientOutputStream != null) {
                        this.clientOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (SocketException ex) {
                String message = ex.getMessage();
                if (message != null && !message.equalsIgnoreCase("Socket closed") && !message.equalsIgnoreCase("Connection reset")) {
                    Logger.logException(ex);
                }
                this.shell.terminated();
                try {
                    if (this.inputChannel != null) {
                        this.inputChannel.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (this.serverOutputStream != null) {
                        this.serverOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (this.clientOutputStream != null) {
                        this.clientOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.shell.terminated();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (this.inputChannel != null) {
                        this.inputChannel.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (this.serverOutputStream != null) {
                        this.serverOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (this.clientOutputStream != null) {
                        this.clientOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            this.shell.terminated();
            try {
                if (this.inputChannel != null) {
                    this.inputChannel.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (this.serverOutputStream != null) {
                    this.serverOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (this.clientOutputStream != null) {
                    this.clientOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void initializeOptions() {
        int i = 0;
        while (i < this.localOptions.length) {
            this.localOptions[i] = new TelnetOption((byte)i, false, true, this.serverOutputStream);
            ++i;
        }
        i = 0;
        while (i < this.localOptions.length) {
            this.remoteOptions[i] = new TelnetOption((byte)i, false, false, this.serverOutputStream);
            ++i;
        }
        this.localOptions[1].setDesired(false);
        this.remoteOptions[1].setDesired(true);
        this.localOptions[3].setDesired(true);
        this.remoteOptions[3].setDesired(true);
        this.localOptions[24].setDesired(true);
        this.remoteOptions[24].setDesired(true);
        this.localOptions[31].setDesired(true);
        this.remoteOptions[31].setDesired(true);
    }

    protected int processTelnetProtocol(int count) {
        int nextProcessedByte = 0;
        int byteIndex = 0;
        while (byteIndex < count) {
            byte inputByte = this.rawBytes.get(byteIndex);
            int ubyte = inputByte & 0xFF;
            block0 : switch (this.telnetState) {
                case 0: {
                    if (inputByte == -1) {
                        this.telnetState = 1;
                        break;
                    }
                    this.processedBytes[nextProcessedByte++] = inputByte;
                    break;
                }
                case 1: {
                    switch (inputByte) {
                        case -1: {
                            this.processedBytes[nextProcessedByte++] = -1;
                            this.telnetState = 0;
                            break block0;
                        }
                        case -5: {
                            this.telnetState = 2;
                            break block0;
                        }
                        case -4: {
                            this.telnetState = 3;
                            break block0;
                        }
                        case -3: {
                            this.telnetState = 4;
                            break block0;
                        }
                        case -2: {
                            this.telnetState = 5;
                            break block0;
                        }
                        case -6: {
                            this.telnetState = 6;
                            break block0;
                        }
                        case -15: 
                        case -14: 
                        case -12: 
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -7: {
                            this.telnetState = 0;
                            break block0;
                        }
                    }
                    Logger.log("processTelnetProtocol: UNRECOGNIZED TELNET PROTOCOL COMMAND: " + ubyte);
                    this.telnetState = 0;
                    break;
                }
                case 2: {
                    Logger.log("Received WILL " + this.localOptions[ubyte].optionName() + ".");
                    this.remoteOptions[ubyte].handleWill();
                    this.telnetState = 0;
                    this.telnetServerDetected();
                    break;
                }
                case 3: {
                    Logger.log("Received WONT " + this.localOptions[ubyte].optionName() + ".");
                    this.remoteOptions[ubyte].handleWont();
                    this.telnetState = 0;
                    this.telnetServerDetected();
                    break;
                }
                case 4: {
                    Logger.log("Received DO " + this.localOptions[ubyte].optionName() + ".");
                    this.localOptions[ubyte].handleDo();
                    this.telnetState = 0;
                    this.telnetServerDetected();
                    break;
                }
                case 5: {
                    Logger.log("Received DONT " + this.localOptions[ubyte].optionName() + ".");
                    this.localOptions[ubyte].handleDont();
                    this.telnetState = 0;
                    this.telnetServerDetected();
                    break;
                }
                case 6: {
                    Logger.log("Starting subnegotiation for option " + this.localOptions[ubyte].optionName() + ".");
                    int i = 0;
                    while (i < this.receivedSubnegotiation.length) {
                        this.receivedSubnegotiation[i] = 0;
                        ++i;
                    }
                    this.ignoreSubnegotiation = false;
                    this.nextSubnegotiationByteIndex = 0;
                    this.receivedSubnegotiation[this.nextSubnegotiationByteIndex++] = inputByte;
                    this.telnetState = 7;
                    break;
                }
                case 7: {
                    if (inputByte == -1) {
                        if (this.nextSubnegotiationByteIndex > 0 && this.receivedSubnegotiation[this.nextSubnegotiationByteIndex - 1] == -1) {
                            Logger.log("Double IAC in subnegotiation translated into single IAC.");
                            break;
                        }
                        if (this.nextSubnegotiationByteIndex < this.receivedSubnegotiation.length) {
                            this.receivedSubnegotiation[this.nextSubnegotiationByteIndex++] = inputByte;
                            break;
                        }
                        this.receivedSubnegotiation[this.receivedSubnegotiation.length - 1] = inputByte;
                        break;
                    }
                    if (inputByte == -16 && this.receivedSubnegotiation[this.nextSubnegotiationByteIndex - 1] == -1) {
                        Logger.log("Found SE code marking end of subnegotiation.");
                        if (!this.ignoreSubnegotiation) {
                            this.receivedSubnegotiation[this.nextSubnegotiationByteIndex - 1] = 0;
                            int subnegotiatedOption = this.receivedSubnegotiation[0] & 0xFF;
                            this.localOptions[subnegotiatedOption].handleSubnegotiation(this.receivedSubnegotiation, this.nextSubnegotiationByteIndex);
                        } else {
                            Logger.log("NOT CALLING handleSubnegotiation() BECAUSE OF ERRORS!");
                        }
                        this.telnetState = 0;
                    }
                    if (this.nextSubnegotiationByteIndex >= this.receivedSubnegotiation.length) {
                        Logger.log("SUBNEGOTIATION BUFFER FULL!");
                        this.ignoreSubnegotiation = true;
                        break;
                    }
                    Logger.log("Recording subnegotiation byte " + ubyte);
                    this.receivedSubnegotiation[this.nextSubnegotiationByteIndex++] = inputByte;
                    break;
                }
                default: {
                    Logger.log("INVALID TELNET STATE: " + this.telnetState);
                    this.telnetState = 0;
                }
            }
            ++byteIndex;
        }
        return nextProcessedByte;
    }

    protected void telnetServerDetected() {
        if (!this.remoteIsTelnetServer) {
            this.localEcho = false;
            Logger.log("Detected TELNET server.");
            this.remoteIsTelnetServer = true;
            TelnetOption[] telnetOptionArray = this.localOptions;
            int n = this.localOptions.length;
            int n2 = 0;
            while (n2 < n) {
                TelnetOption localOption = telnetOptionArray[n2];
                if (localOption.isDesired()) {
                    localOption.negotiate();
                }
                ++n2;
            }
            telnetOptionArray = this.remoteOptions;
            n = this.remoteOptions.length;
            n2 = 0;
            while (n2 < n) {
                TelnetOption remoteOption = telnetOptionArray[n2];
                if (remoteOption.isDesired()) {
                    remoteOption.negotiate();
                }
                ++n2;
            }
        }
    }
}

