/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.handler.MenuHandler;
import org.eclipse.reddeer.core.handler.MenuItemHandler;
import org.eclipse.reddeer.core.handler.WidgetHandler;
import org.eclipse.reddeer.core.lookup.MenuLookup;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.api.Menu;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.menu.DefaultMenu;
import org.eclipse.reddeer.swt.impl.menu.DefaultMenuItem;
import org.eclipse.reddeer.swt.widgets.AbstractItem;
import org.eclipse.swt.widgets.MenuItem;

public abstract class AbstractMenuItem
extends AbstractItem<MenuItem>
implements org.eclipse.reddeer.swt.api.MenuItem {
    protected MenuLookup menuLookup = MenuLookup.getInstance();
    protected MenuItemHandler menuItemHandler = MenuItemHandler.getInstance();
    private static final Logger log = Logger.getLogger(AbstractMenuItem.class);

    protected AbstractMenuItem(MenuItem swtWidget) {
        super(swtWidget);
    }

    @Override
    public void select() {
        log.info("Select menu item with text " + this.getText());
        this.menuItemHandler.select((MenuItem)this.swtWidget);
    }

    @Override
    public boolean isSelected() {
        return this.menuItemHandler.isSelected((MenuItem)this.swtWidget);
    }

    @Override
    public String getText() {
        return this.menuItemHandler.getMenuItemText((MenuItem)this.swtWidget).replace("&", "");
    }

    @Override
    public boolean isEnabled() {
        return this.menuItemHandler.isEnabled((MenuItem)this.swtWidget);
    }

    @Override
    public boolean isDisposed() {
        return WidgetHandler.getInstance().isDisposed(this.swtWidget);
    }

    @Override
    public List<org.eclipse.reddeer.swt.api.MenuItem> getChildItems() {
        List items = MenuHandler.getInstance().getItems(this.menuItemHandler.getMenuFromMenuItem((MenuItem)this.swtWidget));
        if (items == null) {
            return new ArrayList<org.eclipse.reddeer.swt.api.MenuItem>();
        }
        return items.stream().map(DefaultMenuItem::new).collect(Collectors.toList());
    }

    @Override
    public List<org.eclipse.reddeer.swt.api.MenuItem> getAvailableChildItems() {
        ArrayList<org.eclipse.reddeer.swt.api.MenuItem> availableItems = new ArrayList<org.eclipse.reddeer.swt.api.MenuItem>();
        for (org.eclipse.reddeer.swt.api.MenuItem item : this.getChildItems()) {
            if (!item.isEnabled()) continue;
            availableItems.add(item);
        }
        return availableItems;
    }

    @Override
    public Menu getParent() {
        return new DefaultMenu(this.menuItemHandler.getParent((MenuItem)this.swtWidget));
    }

    @Override
    public Control<?> getParentControl() {
        throw new SWTLayerException("Menu item does not have parent control");
    }

    @Override
    public Menu getMenu() {
        org.eclipse.swt.widgets.Menu menu = this.menuItemHandler.getMenu((MenuItem)this.swtWidget);
        return menu == null ? null : new DefaultMenu(menu);
    }
}

