/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.context;

import org.eclipse.reddeer.common.logging.LogLevel;
import org.eclipse.reddeer.common.properties.RedDeerProperties;

public class ExecutionSetting {
    private static ExecutionSetting instance;
    private boolean pauseFailedTest = false;
    private int logMessageFilter;
    private int logLevel = Integer.MAX_VALUE;
    private boolean filterSet = false;

    public static ExecutionSetting getInstance() {
        if (instance == null) {
            instance = new ExecutionSetting();
            ExecutionSetting.instance.pauseFailedTest = RedDeerProperties.PAUSE_FAILED_TEST.getBooleanValue();
            String logMessageFilterText = RedDeerProperties.LOG_MESSAGE_FILTER.getValue();
            String logLevel = RedDeerProperties.LOG_LEVEL.getValue();
            ExecutionSetting.instance.logLevel = LogLevel.ALL.fromString(logLevel).getValue();
            instance.parseLogMessageFilter(logMessageFilterText);
        }
        return instance;
    }

    private void parseLogMessageFilter(String logMessageTypeParam) {
        String[] parts;
        String[] stringArray = parts = logMessageTypeParam.split("\\|");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (p.equalsIgnoreCase("DUMP")) {
                this.addLogMessageType(1);
            } else if (p.equalsIgnoreCase("WARN")) {
                this.addLogMessageType(16);
            } else if (p.equalsIgnoreCase("ERROR")) {
                this.addLogMessageType(32);
            } else if (p.equalsIgnoreCase("TRACE")) {
                this.addLogMessageType(2);
            } else if (p.equalsIgnoreCase("DEBUG")) {
                this.addLogMessageType(4);
            } else if (p.equalsIgnoreCase("INFO")) {
                this.addLogMessageType(8);
            } else if (p.equalsIgnoreCase("STEP")) {
                this.addLogMessageType(128);
            } else {
                if (p.equalsIgnoreCase("ALL")) {
                    this.setLogMessageFilter(255);
                    return;
                }
                if (p.equalsIgnoreCase("NONE")) {
                    this.setLogMessageFilter(0);
                    return;
                }
            }
            ++n2;
        }
        if (!this.filterSet) {
            this.setLogMessageFilter(255);
        }
    }

    private void addLogMessageType(int type) {
        this.logMessageFilter |= type;
        this.filterSet = true;
    }

    private ExecutionSetting() {
    }

    public boolean isPauseFailedTest() {
        return this.pauseFailedTest;
    }

    public int getLogMessageFilter() {
        return this.logMessageFilter;
    }

    public void setLogMessageFilter(int value) {
        this.logMessageFilter = value;
    }

    public int getLogLevel() {
        return this.logLevel;
    }
}

