/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPBasicBlock;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFG;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFGNode;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPDFS;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPExpressionBlock;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPPragmaNode;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.PhaseConcurrencyAnalysis;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.RegionConcurrencyAnalysis;

public class RegionConcurrencyMap {
    protected RegionConcurrencyAnalysis region_ = null;
    protected OMPCFG cfg_ = null;
    protected PhaseConcurrencyAnalysis[] phases_ = null;
    protected ArrayList indexMap_ = new ArrayList();
    protected Hashtable stmtMap_ = new Hashtable();
    protected Hashtable concurrencyMap_ = new Hashtable();
    protected LinkedList phaseStmts_ = new LinkedList();
    protected Hashtable exclusionMap_ = new Hashtable();

    public RegionConcurrencyMap(RegionConcurrencyAnalysis region) {
        this.region_ = region;
        this.cfg_ = this.region_.getCFG();
        this.phases_ = this.region_.getPhases();
    }

    public void buildMap() {
        int i = 0;
        while (i < this.phases_.length) {
            this.processPhase(this.phases_[i]);
            ++i;
        }
    }

    protected void processPhase(PhaseConcurrencyAnalysis phase) {
        Set nodes = phase.getNodes();
        this.phaseStmts_.clear();
        this.exclusionMap_.clear();
        OMPPragmaNode ePragma = null;
        for (OMPCFGNode node : nodes) {
            ePragma = node.getPragmaContext();
            if (ePragma != null && ePragma.getPragma() != null) {
                int pType = ePragma.getPragma().getOMPType();
                if ((pType != 4 || this.hasBarrierFreePathToSelf((OMPBasicBlock)node)) && pType != 7 && pType != 12 && pType != 8 && pType != 2) {
                    ePragma = null;
                }
            } else {
                ePragma = null;
            }
            if (node instanceof OMPBasicBlock) {
                LinkedList stmts = ((OMPBasicBlock)node).getFundamentals();
                for (IASTNode n : stmts) {
                    this.indexNode(n, ePragma);
                }
                this.indexNode((IASTNode)((OMPBasicBlock)node).getBranchingExpression(), ePragma);
                continue;
            }
            if (!(node instanceof OMPExpressionBlock)) continue;
            IASTExpression[] eList = ((OMPExpressionBlock)node).getExpressions();
            int j = 0;
            while (j < eList.length) {
                this.indexNode((IASTNode)eList[j], ePragma);
                ++j;
            }
        }
        for (IASTNode n : this.phaseStmts_) {
            OMPPragmaNode ePragmaS = (OMPPragmaNode)this.exclusionMap_.get(n);
            int nIndex = (Integer)this.stmtMap_.get(n);
            for (IASTNode m : this.phaseStmts_) {
                OMPPragmaNode ePragmaT = (OMPPragmaNode)this.exclusionMap_.get(m);
                if (ePragmaT == ePragmaS && ePragmaT != null) continue;
                BitSet b = (BitSet)this.concurrencyMap_.get(m);
                b.set(nIndex);
            }
        }
    }

    protected void indexNode(IASTNode n, OMPPragmaNode ePragma) {
        if (n == null) {
            return;
        }
        if (!this.stmtMap_.containsKey(n)) {
            this.indexMap_.add(n);
            this.stmtMap_.put(n, new Integer(this.indexMap_.indexOf(n)));
            this.concurrencyMap_.put(n, new BitSet());
        }
        if (!this.phaseStmts_.contains(n)) {
            this.phaseStmts_.add(n);
        }
        if (ePragma != null && !this.exclusionMap_.contains(n)) {
            this.exclusionMap_.put(n, ePragma);
        }
    }

    public Set getNodesConcurrentTo(IASTNode node) {
        BitSet b = (BitSet)this.concurrencyMap_.get(node);
        if (b == null) {
            return null;
        }
        HashSet ans = new HashSet();
        int i = b.nextSetBit(0);
        while (i >= 0) {
            ans.add(this.indexMap_.get(i));
            i = b.nextSetBit(i + 1);
        }
        return ans;
    }

    private boolean hasBarrierFreePathToSelf(OMPBasicBlock singleBlock) {
        BarrierPathDFS dfs = new BarrierPathDFS(singleBlock);
        dfs.startWalking();
        return dfs.hasBarrierFreePath();
    }

    private class BarrierPathDFS
    extends OMPDFS {
        protected OMPPragmaNode target_;
        protected boolean barrierFreeExists_;

        public BarrierPathDFS(OMPBasicBlock block) {
            super(block);
            this.target_ = null;
            this.barrierFreeExists_ = false;
            this.target_ = block.getPragmaContext();
        }

        public boolean hasBarrierFreePath() {
            return this.barrierFreeExists_;
        }

        @Override
        public int visit(OMPCFGNode node) {
            if (node instanceof OMPPragmaNode) {
                OMPPragmaNode thisNode = (OMPPragmaNode)node;
                if (thisNode.isImplicitBarrier() || thisNode.getPragma().getOMPType() == 9) {
                    return 1;
                }
                if (thisNode == this.target_) {
                    this.barrierFreeExists_ = true;
                    return 2;
                }
            }
            return 0;
        }
    }
}

