/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.emf.ui.popup.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.Library;
import org.eclipse.pmf.pim.PMFFactory;
import org.eclipse.pmf.pim.PMFPackage;
import org.eclipse.pmf.pim.impl.EClassToEventEntryMapImpl;
import org.eclipse.pmf.pim.ui.Button;
import org.eclipse.pmf.pim.ui.UIEvent;
import org.eclipse.pmf.pim.ui.UiFactory;
import org.eclipse.pmf.pim.ui.UiPackage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ImportModel
implements IObjectActionDelegate {
    static final String[] FILE_EXTENSIONS = new String[]{"genmodel", "ecore"};
    static final String[] FILE_SUFIXES = new String[]{"*.genmodel", "*.ecore"};
    protected Application application;
    private Shell shell;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        LoadResourceDialog loadResourceDialog = new LoadResourceDialog(this.shell, this.application.eResource().getResourceSet());
        if (loadResourceDialog.open() == 0) {
            try {
                this.application.eResource().save(Collections.emptyMap());
            }
            catch (IOException e) {
                EMFEditUIPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object element;
        if (selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof Application) {
            this.application = (Application)element;
        }
    }

    protected Library addLibraryEvent(String path, String fileName) throws IOException {
        Library libObject = PMFFactory.eINSTANCE.createLibrary();
        libObject.setName("System");
        EMap<EClass, EList<UIEvent>> uiEventsMap = ImportModel.createUIEventsforLibrary(libObject);
        libObject.eSet((EStructuralFeature)PMFPackage.Literals.LIBRARY__EVENTS, (Object)uiEventsMap.map());
        URI fileURI = URI.createPlatformResourceURI((String)(String.valueOf(path) + "/" + fileName), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)libObject);
        resource.save(Collections.EMPTY_MAP);
        return libObject;
    }

    public static EMap<EClass, EList<UIEvent>> createUIEventsforLibrary(Library libObject) {
        EcoreEMap uiEventsMap = new EcoreEMap(PMFPackage.Literals.ECLASS_TO_EVENT_ENTRY_MAP, EClassToEventEntryMapImpl.class, (InternalEObject)libObject, 11);
        BasicEList uiButtonEvents = new BasicEList();
        Button button = UiFactory.eINSTANCE.createButton();
        EClass eButton = button.eClass();
        UIEvent clickEvent = UiFactory.eINSTANCE.createUIEvent();
        clickEvent.setName("Click");
        clickEvent.setId("click");
        uiButtonEvents.add((Object)clickEvent);
        uiEventsMap.put((Object)eButton, (Object)uiButtonEvents);
        BasicEList uiUIElementEvents = new BasicEList();
        EClass eUIElement = (EClass)UiPackage.eINSTANCE.getEClassifier("UIElement");
        UIEvent exposeEvent = UiFactory.eINSTANCE.createUIEvent();
        exposeEvent.setName("Expose");
        exposeEvent.setId("Expose");
        UIEvent mouseInEvent = UiFactory.eINSTANCE.createUIEvent();
        mouseInEvent.setName("MouseIn");
        mouseInEvent.setId("MouseIn");
        UIEvent mouseOutEvent = UiFactory.eINSTANCE.createUIEvent();
        mouseOutEvent.setName("MouseOut");
        mouseOutEvent.setId("MouseOut");
        UIEvent dragEvent = UiFactory.eINSTANCE.createUIEvent();
        dragEvent.setName("DragDetect");
        dragEvent.setId("DragDetect");
        UIEvent focusinEvent = UiFactory.eINSTANCE.createUIEvent();
        focusinEvent.setName("FocusIn");
        focusinEvent.setId("FocusIn");
        UIEvent focusoutEvent = UiFactory.eINSTANCE.createUIEvent();
        focusoutEvent.setName("FocusOut");
        focusoutEvent.setId("FocusOut");
        UIEvent doubleclickEvent = UiFactory.eINSTANCE.createUIEvent();
        doubleclickEvent.setName("MouseDoubleClick");
        doubleclickEvent.setId("MouseDoubleClick");
        UIEvent resizeEvent = UiFactory.eINSTANCE.createUIEvent();
        resizeEvent.setName("Resize");
        resizeEvent.setId("Resize");
        uiUIElementEvents.add((Object)exposeEvent);
        uiUIElementEvents.add((Object)mouseInEvent);
        uiUIElementEvents.add((Object)mouseOutEvent);
        uiUIElementEvents.add((Object)dragEvent);
        uiUIElementEvents.add((Object)focusinEvent);
        uiUIElementEvents.add((Object)focusoutEvent);
        uiUIElementEvents.add((Object)doubleclickEvent);
        uiUIElementEvents.add((Object)resizeEvent);
        uiEventsMap.put((Object)eUIElement, (Object)uiUIElementEvents);
        BasicEList uiListEvents = new BasicEList();
        EClass eList = (EClass)UiPackage.eINSTANCE.getEClassifier("ListView");
        UIEvent selectionEvent = UiFactory.eINSTANCE.createUIEvent();
        selectionEvent.setName("Selection");
        selectionEvent.setId("Selection");
        uiListEvents.add((Object)selectionEvent);
        uiEventsMap.put((Object)eList, (Object)uiListEvents);
        BasicEList uiTextEvents = new BasicEList();
        EClass eText = (EClass)UiPackage.eINSTANCE.getEClassifier("Text");
        UIEvent focusInEvent = UiFactory.eINSTANCE.createUIEvent();
        focusInEvent.setName("focusIn");
        focusInEvent.setId("focusIn");
        UIEvent focusOutEvent = UiFactory.eINSTANCE.createUIEvent();
        focusOutEvent.setName("focusOut");
        focusOutEvent.setId("focusOut");
        UIEvent clickTextEvent = UiFactory.eINSTANCE.createUIEvent();
        clickTextEvent.setName("Click");
        clickTextEvent.setId("Click");
        UIEvent modifyTextEvent = UiFactory.eINSTANCE.createUIEvent();
        modifyTextEvent.setName("Modify");
        modifyTextEvent.setId("Modify");
        uiTextEvents.add((Object)focusInEvent);
        uiTextEvents.add((Object)focusOutEvent);
        uiTextEvents.add((Object)clickTextEvent);
        uiTextEvents.add((Object)modifyTextEvent);
        uiEventsMap.put((Object)eText, (Object)uiTextEvents);
        BasicEList uiComboEvents = new BasicEList();
        EClass eCombo = (EClass)UiPackage.eINSTANCE.getEClassifier("Combo");
        UIEvent selectionComboEvent = UiFactory.eINSTANCE.createUIEvent();
        selectionComboEvent.setName("Selection");
        selectionComboEvent.setId("Selection");
        UIEvent modifyComboEvent = UiFactory.eINSTANCE.createUIEvent();
        modifyComboEvent.setName("Modify");
        modifyComboEvent.setId("Modify");
        uiComboEvents.add((Object)selectionComboEvent);
        uiComboEvents.add((Object)modifyComboEvent);
        uiEventsMap.put((Object)eCombo, (Object)uiComboEvents);
        BasicEList uiLinkEvents = new BasicEList();
        EClass eLink = (EClass)UiPackage.eINSTANCE.getEClassifier("Hyperlink");
        UIEvent clickComboEvent = UiFactory.eINSTANCE.createUIEvent();
        clickComboEvent.setName("Click");
        clickComboEvent.setId("Click");
        uiLinkEvents.add((Object)clickComboEvent);
        uiEventsMap.put((Object)eLink, (Object)uiLinkEvents);
        BasicEList uiMenuItemEvents = new BasicEList();
        EClass eMenuItem = (EClass)UiPackage.eINSTANCE.getEClassifier("MenuItem");
        UIEvent selectMenuItemEvent = UiFactory.eINSTANCE.createUIEvent();
        selectMenuItemEvent.setName("Selection");
        selectMenuItemEvent.setId("Selection");
        uiMenuItemEvents.add((Object)selectMenuItemEvent);
        uiEventsMap.put((Object)eMenuItem, (Object)uiMenuItemEvents);
        BasicEList uiTabEvents = new BasicEList();
        EClass eTab = (EClass)UiPackage.eINSTANCE.getEClassifier("Tab");
        UIEvent selectTabEvent = UiFactory.eINSTANCE.createUIEvent();
        selectTabEvent.setName("Selection");
        selectTabEvent.setId("Selection");
        uiTabEvents.add((Object)selectTabEvent);
        uiEventsMap.put((Object)eTab, (Object)uiTabEvents);
        BasicEList uiTableEvents = new BasicEList();
        EClass eTable = (EClass)UiPackage.eINSTANCE.getEClassifier("Table");
        UIEvent selectTableEvent = UiFactory.eINSTANCE.createUIEvent();
        selectTableEvent.setName("Selection");
        selectTableEvent.setId("Selection");
        UIEvent sortTableEvent = UiFactory.eINSTANCE.createUIEvent();
        sortTableEvent.setName("Sort");
        sortTableEvent.setId("Sort");
        uiTableEvents.add((Object)selectTableEvent);
        uiTableEvents.add((Object)sortTableEvent);
        uiEventsMap.put((Object)eTable, (Object)uiTableEvents);
        BasicEList uiDateTimePickerEvents = new BasicEList();
        EClass eDateTimePicker = (EClass)UiPackage.eINSTANCE.getEClassifier("DateTimePicker");
        UIEvent selectDateTimePickerEvent = UiFactory.eINSTANCE.createUIEvent();
        selectDateTimePickerEvent.setName("Selection");
        selectDateTimePickerEvent.setId("Selection");
        uiDateTimePickerEvents.add((Object)selectDateTimePickerEvent);
        uiEventsMap.put((Object)eDateTimePicker, (Object)uiDateTimePickerEvents);
        return uiEventsMap;
    }

    public static String extractDirectoryPath(String path) {
        if (path == null || path.equals("") || path.equals("/")) {
            return "";
        }
        int lastSlashPos = path.lastIndexOf(47);
        if (lastSlashPos >= 0) {
            return path.substring(0, lastSlashPos);
        }
        return "";
    }

    public class LoadResourceDialog
    extends ResourceDialog {
        protected ResourceSet resourceSet;

        public LoadResourceDialog(Shell parent, ResourceSet resourceSet) {
            super(parent, EMFEditUIPlugin.INSTANCE.getString("_UI_LoadResourceDialog_title"), 4098);
            this.resourceSet = resourceSet;
        }

        protected boolean processResources() {
            if (this.resourceSet != null) {
                for (URI uri : this.getURIs()) {
                    try {
                        if (this.processResource(this.resourceSet.getResource(uri, true))) continue;
                        return false;
                    }
                    catch (RuntimeException exception) {
                        EMFEditUIPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
            return true;
        }

        protected boolean processResource(Resource resource) {
            Application application = ImportModel.this.application;
            application.importModel(resource);
            return true;
        }

        protected void prepareBrowseFileSystemButton(org.eclipse.swt.widgets.Button browseFileSystemButton) {
            browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(LoadResourceDialog.this.getShell(), LoadResourceDialog.this.style);
                    fileDialog.setFilterExtensions(FILE_SUFIXES);
                    fileDialog.open();
                    String filterPath = fileDialog.getFilterPath();
                    if (LoadResourceDialog.this.isMulti()) {
                        String[] fileNames = fileDialog.getFileNames();
                        StringBuffer uris = new StringBuffer();
                        int i = 0;
                        int len = fileNames.length;
                        while (i < len) {
                            uris.append(URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileNames[i])).toString());
                            uris.append("  ");
                            ++i;
                        }
                        LoadResourceDialog.this.uriField.setText((String.valueOf(LoadResourceDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                    } else {
                        String fileName = fileDialog.getFileName();
                        if (fileName != null) {
                            LoadResourceDialog.this.uriField.setText(URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileName)).toString());
                        }
                    }
                }
            });
        }

        protected void prepareBrowseWorkspaceButton(org.eclipse.swt.widgets.Button browseWorkspaceButton) {
            browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (LoadResourceDialog.this.isMulti()) {
                        StringBuffer uris = new StringBuffer();
                        IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)LoadResourceDialog.this.getShell(), null, null, (boolean)true, null, LoadResourceDialog.this.getViewerFilters());
                        int i = 0;
                        int len = files.length;
                        while (i < len) {
                            uris.append(URI.createPlatformResourceURI((String)files[i].getFullPath().toString(), (boolean)true));
                            uris.append("  ");
                            ++i;
                        }
                        LoadResourceDialog.this.uriField.setText((String.valueOf(LoadResourceDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                    } else {
                        IFile file = null;
                        if (LoadResourceDialog.this.isSave()) {
                            file = WorkspaceResourceDialog.openNewFile((Shell)LoadResourceDialog.this.getShell(), null, null, null, LoadResourceDialog.this.getViewerFilters());
                        } else {
                            IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)LoadResourceDialog.this.getShell(), null, null, (boolean)false, null, LoadResourceDialog.this.getViewerFilters());
                            if (files.length != 0) {
                                file = files[0];
                            }
                        }
                        if (file != null) {
                            LoadResourceDialog.this.uriField.setText(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
                        }
                    }
                }
            });
        }

        protected List<ViewerFilter> getViewerFilters() {
            ArrayList<ViewerFilter> arrayList = new ArrayList<ViewerFilter>();
            arrayList.add(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IAdaptable) {
                        IAdaptable adaptable = (IAdaptable)element;
                        IResource resource = (IResource)adaptable.getAdapter(IResource.class);
                        switch (resource.getType()) {
                            case 2: 
                            case 4: {
                                return true;
                            }
                            case 1: {
                                String[] stringArray = FILE_EXTENSIONS;
                                int n = FILE_EXTENSIONS.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String extension = stringArray[n2];
                                    if (extension.equals(resource.getFileExtension())) {
                                        return true;
                                    }
                                    ++n2;
                                }
                                break;
                            }
                        }
                    }
                    return false;
                }
            });
            return arrayList;
        }
    }
}

