/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preprocessor.c;

import org.eclipse.photran.internal.core.preprocessor.c.ILexerLog;
import org.eclipse.photran.internal.core.preprocessor.c.IToken;
import org.eclipse.photran.internal.core.preprocessor.c.OffsetLimitReachedException;
import org.eclipse.photran.internal.core.preprocessor.c.Token;
import org.eclipse.photran.internal.core.preprocessor.c.TokenForDigraph;
import org.eclipse.photran.internal.core.preprocessor.c.TokenWithImage;

public final class Lexer {
    public static final int tBEFORE_INPUT = -100;
    public static final int tNEWLINE = -99;
    public static final int tQUOTE_HEADER_NAME = -98;
    public static final int tSYSTEM_HEADER_NAME = -97;
    public static final int tOTHER_CHARACTER = -96;
    public static final int tPRE_PHASE_3 = -95;
    private static final int END_OF_INPUT = -1;
    private static final int ORIGIN_LEXER = 1;
    private final LexerOptions fOptions;
    private boolean fSupportContentAssist = false;
    private final ILexerLog fLog;
    private final Object fSource;
    private final char[] fInput;
    private int fStart;
    private int fLimit;
    private int fOffset;
    private int fEndOffset;
    private int fCharPhase3;
    private boolean fInsideIncludeDirective = false;
    private Token fToken;
    private Token fLastToken;
    private int fMarkOffset;
    private int fMarkEndOffset;
    private int fMarkPrefetchedChar;
    private IToken fParentToken = null;

    public Lexer(char[] input, LexerOptions options, ILexerLog log, Object source) {
        this(input, 0, input.length, options, log, source);
    }

    public Lexer(char[] input, LexerOptions options, ILexerLog log, Object source, IToken parentToken) {
        this(input, 0, input.length, options, log, source);
        this.fParentToken = parentToken;
    }

    public Lexer(char[] input, int start, int end, LexerOptions options, ILexerLog log, Object source) {
        this.fInput = input;
        this.fOffset = this.fEndOffset = start;
        this.fStart = this.fEndOffset;
        this.fLimit = end;
        this.fOptions = options;
        this.fLog = log;
        this.fSource = source;
        this.fLastToken = this.fToken = new Token(-100, source, start, start);
        this.nextCharPhase3();
    }

    public char[] getRawChars(int offset, int endOffset) {
        if (offset < this.fStart || endOffset > this.fLimit) {
            return null;
        }
        char[] result = new char[endOffset - offset];
        System.arraycopy(this.fInput, offset, result, 0, result.length);
        return result;
    }

    public IToken getParentToken() {
        return this.fParentToken;
    }

    public Object getSource() {
        return this.fSource;
    }

    public void setContentAssistMode(int offset) {
        this.fSupportContentAssist = true;
        this.fLimit = Math.min(offset, this.fInput.length);
        this.fOffset = this.fEndOffset = this.fStart;
        this.nextCharPhase3();
    }

    public void setInsideIncludeDirective(boolean val) {
        this.fInsideIncludeDirective = val;
    }

    public Token currentToken() {
        return this.fToken;
    }

    public int getLastEndOffset() {
        return this.fLastToken.getEndOffset();
    }

    public Token nextToken() throws OffsetLimitReachedException {
        this.fLastToken = this.fToken;
        this.fToken = this.fetchToken();
        return this.fToken;
    }

    public boolean currentTokenIsFirstOnLine() {
        int type = this.fLastToken.getType();
        return type == -99 || type == -100;
    }

    public final int consumeLine(int origin) throws OffsetLimitReachedException {
        Token t = this.fToken;
        Token lt = null;
        while (true) {
            switch (t.getType()) {
                case 140: {
                    if (lt != null) {
                        this.fLastToken = lt;
                    }
                    this.fToken = t;
                    throw new OffsetLimitReachedException(origin, t);
                }
                case 144: {
                    if (this.fSupportContentAssist) {
                        t.setType(140);
                        throw new OffsetLimitReachedException(origin, t);
                    }
                }
                case -99: {
                    this.fToken = t;
                    if (lt != null) {
                        this.fLastToken = lt;
                    }
                    return this.getLastEndOffset();
                }
            }
            lt = t;
            t = this.fetchToken();
        }
    }

    public Token nextDirective() throws OffsetLimitReachedException {
        this.fInsideIncludeDirective = false;
        Token t = this.fToken;
        boolean haveNL = t == null || t.getType() == -99;
        block19: while (true) {
            int d;
            boolean hadNL = haveNL;
            haveNL = false;
            int start = this.fOffset;
            int c = this.fCharPhase3;
            int pos = this.fEndOffset;
            if (pos + 1 >= this.fLimit) {
                d = this.nextCharPhase3();
            } else {
                d = this.fInput[pos];
                switch (d) {
                    case 92: {
                        d = this.nextCharPhase3();
                        break;
                    }
                    case 63: {
                        if (this.fInput[pos + 1] == '?') {
                            d = this.nextCharPhase3();
                            break;
                        }
                        this.fOffset = pos;
                        this.fCharPhase3 = d;
                        this.fEndOffset = pos + 1;
                        break;
                    }
                    default: {
                        this.fOffset = pos;
                        this.fCharPhase3 = d;
                        this.fEndOffset = pos + 1;
                    }
                }
            }
            switch (c) {
                case -1: {
                    this.fLastToken = this.fToken = this.newToken(144, start, start);
                    return this.fToken;
                }
                case 10: {
                    haveNL = true;
                    continue block19;
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    haveNL = hadNL;
                    continue block19;
                }
                case 34: {
                    this.stringLiteral(start, start, false);
                    continue block19;
                }
                case 39: {
                    this.charLiteral(start, start, false);
                    continue block19;
                }
                case 47: {
                    switch (d) {
                        case 47: {
                            this.nextCharPhase3();
                            this.lineComment(start);
                            continue block19;
                        }
                        case 42: {
                            this.blockComment(start, '*');
                            continue block19;
                        }
                        case 37: {
                            if (!this.fOptions.fSupportSlashPercentComments) continue block19;
                            this.blockComment(start, '%');
                            continue block19;
                        }
                    }
                    continue block19;
                }
                case 37: {
                    if (!hadNL || d != 58) continue block19;
                    int e = this.nextCharPhase3();
                    if (e == 37) {
                        this.markPhase3();
                        if (this.nextCharPhase3() == 58) {
                            this.nextCharPhase3();
                            continue block19;
                        }
                        this.restorePhase3();
                    }
                    this.fLastToken = new Token(-99, this.fSource, 0, start);
                    this.fToken = this.newDigraphToken(138, start, start);
                    return this.fToken;
                }
                case 35: {
                    if (!hadNL || d == 35) continue block19;
                    this.fLastToken = new Token(-99, this.fSource, 0, start);
                    this.fToken = this.newToken(138, start, start);
                    return this.fToken;
                }
            }
        }
    }

    private Token fetchToken() throws OffsetLimitReachedException {
        int charImageLength;
        Token t;
        Token ancestor = t = this.innerFetchToken();
        int tOffset = t.getOffset();
        int tEndOffset = t.getEndOffset();
        if (tEndOffset - tOffset != (charImageLength = t.getType() == -99 ? 1 : t.getCharImage().length)) {
            TokenWithImage invoker = new TokenWithImage(-95, this.fSource, tOffset, tEndOffset, this.getRawChars(tOffset, tEndOffset), t.getCharPrecedingWhiteSpace());
            ancestor.setParent(invoker);
            ancestor = invoker;
        }
        if (this.fParentToken != null) {
            ancestor.setParent(this.fParentToken);
        }
        return t;
    }

    private Token innerFetchToken() throws OffsetLimitReachedException {
        int start;
        int spacesStart = this.fOffset;
        block94: while (true) {
            start = this.fOffset;
            int c = this.fCharPhase3;
            int d = this.nextCharPhase3();
            switch (c) {
                case -1: {
                    return this.newToken(144, spacesStart, start);
                }
                case 10: {
                    this.fInsideIncludeDirective = false;
                    return this.newToken(-99, spacesStart, start);
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    continue block94;
                }
                case 76: {
                    switch (d) {
                        case 34: {
                            this.nextCharPhase3();
                            return this.stringLiteral(spacesStart, start, true);
                        }
                        case 39: {
                            this.nextCharPhase3();
                            return this.charLiteral(spacesStart, start, true);
                        }
                    }
                    return this.identifier(spacesStart, start, 1);
                }
                case 34: {
                    if (this.fInsideIncludeDirective) {
                        return this.headerName(spacesStart, start, true);
                    }
                    return this.stringLiteral(spacesStart, start, false);
                }
                case 39: {
                    return this.charLiteral(spacesStart, start, false);
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    return this.identifier(spacesStart, start, 1);
                }
                case 36: {
                    if (!this.fOptions.fSupportDollarInIdentifiers) break block94;
                    return this.identifier(spacesStart, start, 1);
                }
                case 64: {
                    if (!this.fOptions.fSupportAtSignInIdentifiers) break block94;
                    return this.identifier(spacesStart, start, 1);
                }
                case 92: {
                    switch (d) {
                        case 85: 
                        case 117: {
                            this.nextCharPhase3();
                            return this.identifier(spacesStart, start, 2);
                        }
                    }
                    return this.newToken(-96, spacesStart, start, 1);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.number(spacesStart, start, 1, false);
                }
                case 46: {
                    switch (d) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.nextCharPhase3();
                            return this.number(spacesStart, start, 2, true);
                        }
                        case 46: {
                            this.markPhase3();
                            if (this.nextCharPhase3() == 46) {
                                this.nextCharPhase3();
                                return this.newToken(48, spacesStart, start);
                            }
                            this.restorePhase3();
                            break;
                        }
                        case 42: {
                            this.nextCharPhase3();
                            return this.newToken(49, spacesStart, start);
                        }
                    }
                    return this.newToken(50, spacesStart, start);
                }
                case 35: {
                    if (d == 35) {
                        this.nextCharPhase3();
                        return this.newToken(139, spacesStart, start);
                    }
                    return this.newToken(138, spacesStart, start);
                }
                case 123: {
                    return this.newToken(12, spacesStart, start);
                }
                case 125: {
                    return this.newToken(13, spacesStart, start);
                }
                case 91: {
                    return this.newToken(10, spacesStart, start);
                }
                case 93: {
                    return this.newToken(11, spacesStart, start);
                }
                case 40: {
                    return this.newToken(8, spacesStart, start);
                }
                case 41: {
                    return this.newToken(9, spacesStart, start);
                }
                case 59: {
                    return this.newToken(5, spacesStart, start);
                }
                case 58: {
                    switch (d) {
                        case 58: {
                            this.nextCharPhase3();
                            return this.newToken(3, spacesStart, start);
                        }
                        case 62: {
                            this.nextCharPhase3();
                            return this.newDigraphToken(11, spacesStart, start);
                        }
                    }
                    return this.newToken(4, spacesStart, start);
                }
                case 63: {
                    return this.newToken(7, spacesStart, start);
                }
                case 43: {
                    switch (d) {
                        case 43: {
                            this.nextCharPhase3();
                            return this.newToken(15, spacesStart, start);
                        }
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(14, spacesStart, start);
                        }
                    }
                    return this.newToken(16, spacesStart, start);
                }
                case 45: {
                    switch (d) {
                        case 62: {
                            int e = this.nextCharPhase3();
                            if (e == 42) {
                                this.nextCharPhase3();
                                return this.newToken(19, spacesStart, start);
                            }
                            return this.newToken(20, spacesStart, start);
                        }
                        case 45: {
                            this.nextCharPhase3();
                            return this.newToken(18, spacesStart, start);
                        }
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(17, spacesStart, start);
                        }
                    }
                    return this.newToken(21, spacesStart, start);
                }
                case 42: {
                    if (d == 61) {
                        this.nextCharPhase3();
                        return this.newToken(22, spacesStart, start);
                    }
                    return this.newToken(23, spacesStart, start);
                }
                case 47: {
                    switch (d) {
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(51, spacesStart, start);
                        }
                        case 47: {
                            this.nextCharPhase3();
                            this.lineComment(start);
                            continue block94;
                        }
                        case 42: {
                            this.blockComment(start, '*');
                            continue block94;
                        }
                        case 37: {
                            if (!this.fOptions.fSupportSlashPercentComments) break;
                            this.blockComment(start, '%');
                            continue block94;
                        }
                    }
                    return this.newToken(52, spacesStart, start);
                }
                case 37: {
                    switch (d) {
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(24, spacesStart, start);
                        }
                        case 62: {
                            this.nextCharPhase3();
                            return this.newDigraphToken(13, spacesStart, start);
                        }
                        case 58: {
                            int e = this.nextCharPhase3();
                            if (e == 37) {
                                this.markPhase3();
                                if (this.nextCharPhase3() == 58) {
                                    this.nextCharPhase3();
                                    return this.newDigraphToken(139, spacesStart, start);
                                }
                                this.restorePhase3();
                            }
                            return this.newDigraphToken(138, spacesStart, start);
                        }
                    }
                    return this.newToken(25, spacesStart, start);
                }
                case 94: {
                    if (d == 61) {
                        this.nextCharPhase3();
                        return this.newToken(26, spacesStart, start);
                    }
                    return this.newToken(27, spacesStart, start);
                }
                case 38: {
                    switch (d) {
                        case 38: {
                            this.nextCharPhase3();
                            return this.newToken(29, spacesStart, start);
                        }
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(28, spacesStart, start);
                        }
                    }
                    return this.newToken(30, spacesStart, start);
                }
                case 124: {
                    switch (d) {
                        case 124: {
                            this.nextCharPhase3();
                            return this.newToken(32, spacesStart, start);
                        }
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(31, spacesStart, start);
                        }
                    }
                    return this.newToken(33, spacesStart, start);
                }
                case 126: {
                    return this.newToken(34, spacesStart, start);
                }
                case 33: {
                    if (d == 61) {
                        this.nextCharPhase3();
                        return this.newToken(35, spacesStart, start);
                    }
                    return this.newToken(36, spacesStart, start);
                }
                case 61: {
                    if (d == 61) {
                        this.nextCharPhase3();
                        return this.newToken(37, spacesStart, start);
                    }
                    return this.newToken(38, spacesStart, start);
                }
                case 60: {
                    if (this.fInsideIncludeDirective) {
                        return this.headerName(spacesStart, start, false);
                    }
                    switch (d) {
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(41, spacesStart, start);
                        }
                        case 60: {
                            int e = this.nextCharPhase3();
                            if (e == 61) {
                                this.nextCharPhase3();
                                return this.newToken(47, spacesStart, start);
                            }
                            return this.newToken(40, spacesStart, start);
                        }
                        case 63: {
                            if (!this.fOptions.fSupportMinAndMax) break;
                            this.nextCharPhase3();
                            return this.newToken(153, spacesStart, start);
                        }
                        case 58: {
                            this.nextCharPhase3();
                            return this.newDigraphToken(10, spacesStart, start);
                        }
                        case 37: {
                            this.nextCharPhase3();
                            return this.newDigraphToken(12, spacesStart, start);
                        }
                    }
                    return this.newToken(42, spacesStart, start);
                }
                case 62: {
                    switch (d) {
                        case 61: {
                            this.nextCharPhase3();
                            return this.newToken(45, spacesStart, start);
                        }
                        case 62: {
                            int e = this.nextCharPhase3();
                            if (e == 61) {
                                this.nextCharPhase3();
                                return this.newToken(43, spacesStart, start);
                            }
                            return this.newToken(44, spacesStart, start);
                        }
                        case 63: {
                            if (!this.fOptions.fSupportMinAndMax) break;
                            this.nextCharPhase3();
                            return this.newToken(152, spacesStart, start);
                        }
                    }
                    return this.newToken(46, spacesStart, start);
                }
                case 44: {
                    return this.newToken(6, spacesStart, start);
                }
                default: {
                    if (!Character.isUnicodeIdentifierStart((char)c)) break block94;
                    return this.identifier(spacesStart, start, 1);
                }
            }
            break;
        }
        return this.newToken(-96, spacesStart, start, 1);
    }

    private Token newToken(int kind, int spacesStart, int offset) {
        char[] spaces = new char[offset - spacesStart];
        System.arraycopy(this.fInput, spacesStart, spaces, 0, spaces.length);
        return new Token(kind, this.fSource, offset, this.fOffset, spaces);
    }

    private Token newDigraphToken(int kind, int spacesStart, int offset) {
        char[] spaces = new char[offset - spacesStart];
        System.arraycopy(this.fInput, spacesStart, spaces, 0, spaces.length);
        return new TokenForDigraph(kind, this.fSource, offset, this.fOffset, spaces);
    }

    private Token newToken(int kind, int spacesStart, int offset, int imageLength) {
        char[] image;
        int endOffset = this.fOffset;
        int sourceLen = endOffset - offset;
        if (sourceLen != imageLength) {
            image = this.getCharImage(offset, endOffset, imageLength);
        } else {
            image = new char[imageLength];
            System.arraycopy(this.fInput, offset, image, 0, imageLength);
        }
        char[] spaces = new char[offset - spacesStart];
        System.arraycopy(this.fInput, spacesStart, spaces, 0, spaces.length);
        return new TokenWithImage(kind, this.fSource, offset, endOffset, image, spaces);
    }

    private void handleProblem(int problemID, char[] arg, int offset) {
        this.fLog.handleProblem(problemID, arg, offset, this.fOffset);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Token headerName(int spacesStart, int start, boolean expectQuotes) throws OffsetLimitReachedException {
        int n;
        int length = 1;
        boolean done = false;
        int c = this.fCharPhase3;
        block6: while (!done) {
            switch (c) {
                case -1: {
                    if (this.fSupportContentAssist) {
                        int n2;
                        if (expectQuotes) {
                            n2 = -98;
                            throw new OffsetLimitReachedException(1, this.newToken(n2, spacesStart, start, length));
                        }
                        n2 = -97;
                        throw new OffsetLimitReachedException(1, this.newToken(n2, spacesStart, start, length));
                    }
                }
                case 10: {
                    this.handleProblem(0x1000002, this.getInputChars(start, this.fOffset), start);
                    break block6;
                }
                case 34: {
                    done = expectQuotes;
                    break;
                }
                case 62: {
                    done = !expectQuotes;
                }
            }
            ++length;
            c = this.nextCharPhase3();
        }
        if (expectQuotes) {
            n = -98;
            return this.newToken(n, spacesStart, start, length);
        }
        n = -97;
        return this.newToken(n, spacesStart, start, length);
    }

    private void blockComment(int start, char trigger) {
        int pos = this.fEndOffset;
        while (pos < this.fLimit) {
            if (this.fInput[pos++] != trigger) continue;
            this.fEndOffset = pos;
            if (this.nextCharPhase3() != 47) continue;
            this.nextCharPhase3();
            this.fLog.handleComment(true, start, this.fOffset);
            return;
        }
        this.fCharPhase3 = -1;
        this.fOffset = this.fEndOffset = pos;
        this.fLog.handleComment(true, start, pos);
    }

    private void lineComment(int start) {
        int c = this.fCharPhase3;
        while (true) {
            switch (c) {
                case -1: 
                case 10: {
                    this.fLog.handleComment(false, start, this.fOffset);
                    return;
                }
            }
            c = this.nextCharPhase3();
        }
    }

    private Token stringLiteral(int spacesStart, int start, boolean wide) throws OffsetLimitReachedException {
        boolean escaped = false;
        boolean done = false;
        int length = wide ? 2 : 1;
        int c = this.fCharPhase3;
        block6: while (!done) {
            switch (c) {
                case -1: {
                    if (this.fSupportContentAssist) {
                        throw new OffsetLimitReachedException(1, this.newToken(wide ? 131 : 130, spacesStart, start, length));
                    }
                }
                case 10: {
                    this.handleProblem(0x1000002, this.getInputChars(start, this.fOffset), start);
                    break block6;
                }
                case 92: {
                    escaped = !escaped;
                    break;
                }
                case 34: {
                    if (!escaped) {
                        done = true;
                    }
                    escaped = false;
                    break;
                }
                default: {
                    escaped = false;
                }
            }
            ++length;
            c = this.nextCharPhase3();
        }
        return this.newToken(wide ? 131 : 130, spacesStart, start, length);
    }

    private Token charLiteral(int spacesStart, int start, boolean wide) throws OffsetLimitReachedException {
        boolean escaped = false;
        boolean done = false;
        int length = wide ? 2 : 1;
        int c = this.fCharPhase3;
        block6: while (!done) {
            switch (c) {
                case -1: {
                    if (this.fSupportContentAssist) {
                        throw new OffsetLimitReachedException(1, this.newToken(wide ? 133 : 132, spacesStart, start, length));
                    }
                }
                case 10: {
                    this.handleProblem(0x1000001, this.getInputChars(start, this.fOffset), start);
                    break block6;
                }
                case 92: {
                    escaped = !escaped;
                    break;
                }
                case 39: {
                    if (!escaped) {
                        done = true;
                    }
                    escaped = false;
                    break;
                }
                default: {
                    escaped = false;
                }
            }
            ++length;
            c = this.nextCharPhase3();
        }
        return this.newToken(wide ? 133 : 132, spacesStart, start, length);
    }

    private Token identifier(int spacesStart, int start, int length) {
        int tokenKind = 1;
        boolean isPartOfIdentifier = true;
        int c = this.fCharPhase3;
        while (true) {
            block0 : switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    break;
                }
                case 92: {
                    this.markPhase3();
                    switch (this.nextCharPhase3()) {
                        case 85: 
                        case 117: {
                            ++length;
                            break block0;
                        }
                    }
                    this.restorePhase3();
                    isPartOfIdentifier = false;
                    break;
                }
                case -1: {
                    if (this.fSupportContentAssist) {
                        tokenKind = 140;
                    }
                    isPartOfIdentifier = false;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    isPartOfIdentifier = false;
                    break;
                }
                case 36: {
                    isPartOfIdentifier = this.fOptions.fSupportDollarInIdentifiers;
                    break;
                }
                case 64: {
                    isPartOfIdentifier = this.fOptions.fSupportAtSignInIdentifiers;
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 91: 
                case 93: 
                case 94: 
                case 123: 
                case 124: 
                case 125: 
                case 126: {
                    isPartOfIdentifier = false;
                    break;
                }
                default: {
                    isPartOfIdentifier = Character.isUnicodeIdentifierPart((char)c);
                }
            }
            if (!isPartOfIdentifier) break;
            ++length;
            c = this.nextCharPhase3();
        }
        return this.newToken(tokenKind, spacesStart, start, length);
    }

    private Token number(int spacesStart, int start, int length, boolean isFloat) throws OffsetLimitReachedException {
        boolean isPartOfNumber = true;
        int c = this.fCharPhase3;
        block13: while (true) {
            block0 : switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    break;
                }
                case 46: {
                    isFloat = true;
                    break;
                }
                case 69: 
                case 80: 
                case 101: 
                case 112: {
                    ++length;
                    c = this.nextCharPhase3();
                    switch (c) {
                        case 43: 
                        case 45: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            isFloat = true;
                            ++length;
                            c = this.nextCharPhase3();
                        }
                    }
                    continue block13;
                }
                case 92: {
                    this.markPhase3();
                    switch (this.nextCharPhase3()) {
                        case 85: 
                        case 117: {
                            ++length;
                            break block0;
                        }
                    }
                    this.restorePhase3();
                    isPartOfNumber = false;
                    break;
                }
                case -1: {
                    if (this.fSupportContentAssist) {
                        throw new OffsetLimitReachedException(1, this.newToken(isFloat ? 129 : 2, spacesStart, start, length));
                    }
                    isPartOfNumber = false;
                    break;
                }
                default: {
                    isPartOfNumber = false;
                }
            }
            if (!isPartOfNumber) break;
            c = this.nextCharPhase3();
            ++length;
        }
        return this.newToken(isFloat ? 129 : 2, spacesStart, start, length);
    }

    private void markPhase3() {
        this.fMarkOffset = this.fOffset;
        this.fMarkEndOffset = this.fEndOffset;
        this.fMarkPrefetchedChar = this.fCharPhase3;
    }

    private void restorePhase3() {
        this.fOffset = this.fMarkOffset;
        this.fEndOffset = this.fMarkEndOffset;
        this.fCharPhase3 = this.fMarkPrefetchedChar;
    }

    private int nextCharPhase3() {
        int c;
        int pos = this.fEndOffset;
        block5: while (true) {
            if (pos + 1 >= this.fLimit) {
                if (pos >= this.fLimit) {
                    this.fOffset = this.fLimit;
                    this.fEndOffset = this.fLimit;
                    this.fCharPhase3 = -1;
                    return -1;
                }
                this.fOffset = pos;
                this.fEndOffset = pos + 1;
                this.fCharPhase3 = this.fInput[pos];
                return this.fCharPhase3;
            }
            c = this.fInput[pos];
            this.fOffset = pos++;
            this.fEndOffset = pos;
            this.fCharPhase3 = c;
            switch (c) {
                case 13: {
                    if (this.fInput[pos] == '\n') {
                        this.fEndOffset = pos + 1;
                        this.fCharPhase3 = 10;
                        return 10;
                    }
                    return c;
                }
                case 63: {
                    if (this.fInput[pos] != '?' || pos + 1 >= this.fLimit) {
                        return c;
                    }
                    char trigraph = this.checkTrigraph(this.fInput[pos + 1]);
                    if (trigraph == '\u0000') {
                        return c;
                    }
                    if (trigraph != '\\') {
                        this.fEndOffset = pos + 2;
                        this.fCharPhase3 = trigraph;
                        return trigraph;
                    }
                    pos += 2;
                }
                case 92: {
                    int lsPos = this.findEndOfLineSpliceSequence(pos);
                    if (lsPos > pos) {
                        pos = lsPos;
                        continue block5;
                    }
                    this.fEndOffset = pos;
                    this.fCharPhase3 = 92;
                    return 92;
                }
            }
            break;
        }
        return c;
    }

    private char checkTrigraph(char c) {
        switch (c) {
            case '=': {
                return '#';
            }
            case '\'': {
                return '^';
            }
            case '(': {
                return '[';
            }
            case ')': {
                return ']';
            }
            case '!': {
                return '|';
            }
            case '<': {
                return '{';
            }
            case '>': {
                return '}';
            }
            case '-': {
                return '~';
            }
            case '/': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private int findEndOfLineSpliceSequence(int pos) {
        boolean haveBackslash = true;
        int result = -1;
        block6: while (pos < this.fLimit) {
            switch (this.fInput[pos++]) {
                case '\n': {
                    if (haveBackslash) {
                        result = pos;
                        haveBackslash = false;
                        break;
                    }
                    return result;
                }
                case '\t': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (haveBackslash) continue block6;
                    return result;
                }
                case '?': {
                    if (pos + 1 >= this.fLimit || this.fInput[pos] != '?' || this.fInput[++pos] != '/') {
                        return result;
                    }
                }
                case '\\': {
                    if (!haveBackslash) {
                        haveBackslash = true;
                        break;
                    }
                    return result;
                }
                default: {
                    return result;
                }
            }
        }
        return result;
    }

    public char[] getInputChars(int offset, int endOffset) {
        int length = endOffset - offset;
        char[] result = new char[length];
        System.arraycopy(this.fInput, offset, result, 0, length);
        return result;
    }

    char[] getInput() {
        return this.fInput;
    }

    private char[] getCharImage(int offset, int endOffset, int imageLength) {
        char[] result = new char[imageLength];
        this.markPhase3();
        this.fEndOffset = offset;
        int idx = 0;
        while (idx < imageLength) {
            result[idx] = (char)this.nextCharPhase3();
            ++idx;
        }
        this.restorePhase3();
        return result;
    }

    public static final class LexerOptions
    implements Cloneable {
        public boolean fSupportDollarInIdentifiers = true;
        public boolean fSupportAtSignInIdentifiers = true;
        public boolean fSupportMinAndMax = true;
        public boolean fCreateImageLocations = true;
        public boolean fSupportSlashPercentComments = false;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

