/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.SWTUtil;
import org.eclipse.pde.internal.ds.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ds.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ds.ui.editor.sections.DSProvideSection;
import org.eclipse.pde.internal.ds.ui.parts.FormEntry;
import org.eclipse.pde.internal.ds.ui.wizards.DSNewClassCreationWizard;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DSEditProvideDialog
extends FormDialog {
    private IDSProvide fProvide;
    private FormEntry fInterfaceEntry;
    private DSProvideSection fProvideSection;

    public DSEditProvideDialog(Shell parentShell, IDSProvide provide, DSProvideSection provideSection) {
        super(parentShell);
        this.fProvide = provide;
        this.fProvideSection = provideSection;
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText(Messages.DSEditProvideDialog_dialog_title);
        Composite container = mform.getForm().getBody();
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        FormToolkit toolkit = mform.getToolkit();
        toolkit.decorateFormHeading(mform.getForm().getForm());
        Composite composite = toolkit.createComposite(container);
        composite.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        composite.setLayoutData((Object)new GridData(1808));
        this.fInterfaceEntry = new FormEntry(composite, toolkit, Messages.DSProvideDetails_interface, Messages.DSProvideDetails_browse, false, 0);
        GridData gd = new GridData(768);
        gd.widthHint = 20;
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 3;
        toolkit.paintBordersFor(composite);
        this.updateFields();
        this.setInterfaceEntryListeners();
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.handleOKPressed();
            }
        }
        super.buttonPressed(buttonId);
    }

    private void handleOKPressed() {
        this.fInterfaceEntry.commit();
        if (!(this.fInterfaceEntry.getValue().equals("") && this.fProvide.getInterface() == null || this.fInterfaceEntry.getValue().equals(this.fProvide.getInterface()))) {
            this.fProvide.setInterface(this.fInterfaceEntry.getValue());
        }
    }

    private void updateFields() {
        if (this.fProvide == null) {
            return;
        }
        if (this.fProvide.getInterface() == null) {
            this.fInterfaceEntry.setValue("");
        } else {
            this.fInterfaceEntry.setValue(this.fProvide.getInterface(), true);
        }
        this.fInterfaceEntry.setEditable(true);
    }

    public void setInterfaceEntryListeners() {
        this.fInterfaceEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this.fProvideSection){

            @Override
            public void textValueChanged(FormEntry entry) {
            }

            @Override
            public void textDirty(FormEntry entry) {
            }

            @Override
            public void linkActivated(HyperlinkEvent e) {
                String value = DSEditProvideDialog.this.fInterfaceEntry.getValue();
                if ((value = DSEditProvideDialog.this.handleLinkActivated(value, false)) != null) {
                    DSEditProvideDialog.this.fInterfaceEntry.setValue(value);
                }
            }

            @Override
            public void browseButtonSelected(FormEntry entry) {
                DSEditProvideDialog.this.doOpenSelectionDialog(512, DSEditProvideDialog.this.fInterfaceEntry);
            }
        });
    }

    private String handleLinkActivated(String value, boolean isInter) {
        IProject project = this.getProject();
        try {
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType element = javaProject.findType(value.replace('$', '.'));
                if (element != null) {
                    JavaUI.openInEditor((IJavaElement)element);
                } else {
                    DSNewClassCreationWizard wizard = new DSNewClassCreationWizard(project, isInter, value);
                    WizardDialog dialog = new WizardDialog(Activator.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    if (dialog.open() == 0) {
                        return wizard.getQualifiedName();
                    }
                }
            }
        }
        catch (PartInitException partInitException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    private IProject getProject() {
        PDEFormEditor editor = (PDEFormEditor)this.fProvideSection.getPage().getEditor();
        return editor.getCommonProject();
    }

    private void doOpenSelectionDialog(int scopeType, FormEntry entry) {
        try {
            String filter = entry.getValue();
            filter = filter.substring(filter.lastIndexOf(".") + 1);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Activator.getActiveWorkbenchShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)scopeType, (boolean)false, (String)filter);
            dialog.setTitle(Messages.DSProvideDetails_selectType);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                entry.setValue(type.getFullyQualifiedName('$'));
                entry.commit();
            }
        }
        catch (CoreException coreException) {}
    }
}

