/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.NodeFinder;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;

public class RemoveUnsupportedTagOperation
extends UIJob {
    private IMarker[] markers = null;

    public RemoveUnsupportedTagOperation(IMarker[] markers) {
        super(MarkerMessages.UnsupportedTagResolution_remove_unsupported_tags);
        this.markers = markers;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MarkerMessages.RemoveUnsupportedTagOperation_removeing_unsupported_tag, (int)(this.markers.length + 6));
        HashMap<ICompilationUnit, Boolean> seen = new HashMap<ICompilationUnit, Boolean>();
        int i = 0;
        while (i < this.markers.length) {
            IResource resource = this.markers[i].getResource();
            IJavaElement javaElement = JavaCore.create((IResource)resource);
            try {
                if (javaElement != null && javaElement.getElementType() == 5) {
                    ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
                    if (!seen.containsKey(compilationUnit)) {
                        seen.put(compilationUnit, compilationUnit.hasUnsavedChanges());
                    }
                    if (!compilationUnit.isWorkingCopy()) {
                        JavaUI.openInEditor((IJavaElement)compilationUnit);
                    }
                    if (!compilationUnit.isConsistent()) {
                        compilationUnit.reconcile(0, false, null, null);
                        localMonitor.split(1);
                    }
                    localMonitor.split(1);
                    ASTParser parser = ASTParser.newParser((int)10);
                    parser.setSource(compilationUnit);
                    Integer charStartAttribute = null;
                    charStartAttribute = (Integer)this.markers[i].getAttribute("charStart");
                    int intValue = charStartAttribute;
                    parser.setFocalPosition(intValue);
                    Map options = compilationUnit.getJavaProject().getOptions(true);
                    options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                    parser.setCompilerOptions(options);
                    CompilationUnit unit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
                    NodeFinder finder = new NodeFinder(intValue);
                    unit.accept((ASTVisitor)finder);
                    localMonitor.split(1);
                    BodyDeclaration node = finder.getNode();
                    if (node != null) {
                        unit.recordModifications();
                        AST ast = unit.getAST();
                        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                        Javadoc docnode = node.getJavadoc();
                        if (docnode == null) {
                            return Status.CANCEL_STATUS;
                        }
                        List tags = docnode.tags();
                        String arg = (String)this.markers[i].getAttribute("messagearguments");
                        String[] args = arg.split("#");
                        TagElement tag2 = null;
                        for (TagElement tag2 : tags) {
                            if (args[0].equals(tag2.getTagName()) && tag2.getStartPosition() == intValue) break;
                        }
                        if (tag2 == null) {
                            return Status.CANCEL_STATUS;
                        }
                        ListRewrite lrewrite = rewrite.getListRewrite((ASTNode)docnode, Javadoc.TAGS_PROPERTY);
                        lrewrite.remove((ASTNode)tag2, null);
                        localMonitor.split(1);
                        TextEdit edit = rewrite.rewriteAST();
                        compilationUnit.applyTextEdit(edit, monitor);
                        localMonitor.split(1);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (PartInitException partInitException) {
            }
            catch (CoreException coreException) {}
            ++i;
        }
        for (Map.Entry entry : seen.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            try {
                ((ICompilationUnit)entry.getKey()).commitWorkingCopy(true, null);
            }
            catch (JavaModelException javaModelException) {}
        }
        return Status.OK_STATUS;
    }
}

