/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.InstanceScopeAnalysis;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.BranchingTracebackStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackStepCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestFactory;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestSet;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.FlatSet;
import org.eclipse.ocl.examples.impactanalyzer.util.IterableAsOperationCallExpKeyedSet;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.OperationCallExpKeyedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationCallTracebackStep
extends BranchingTracebackStep<OperationCallExp> {
    private static final Set<String> sourcePassThroughStdLibOpNames = new HashSet<String>();
    private static final Set<String> argumentPassThroughStdLibOpNames;
    private final EClass allInstancesClass;
    private final OppositeEndFinder oppositeEndFinder;
    private final boolean requireTypeExactly;
    private final boolean filterResultsByCall;

    static {
        sourcePassThroughStdLibOpNames.add("any");
        sourcePassThroughStdLibOpNames.add("asBag");
        sourcePassThroughStdLibOpNames.add("asSet");
        sourcePassThroughStdLibOpNames.add("asOrderedSet");
        sourcePassThroughStdLibOpNames.add("asSequence");
        sourcePassThroughStdLibOpNames.add("at");
        sourcePassThroughStdLibOpNames.add("excluding");
        sourcePassThroughStdLibOpNames.add("first");
        sourcePassThroughStdLibOpNames.add("flatten");
        sourcePassThroughStdLibOpNames.add("including");
        sourcePassThroughStdLibOpNames.add("insertAt");
        sourcePassThroughStdLibOpNames.add("append");
        sourcePassThroughStdLibOpNames.add("intersection");
        sourcePassThroughStdLibOpNames.add("oclAsType");
        sourcePassThroughStdLibOpNames.add("union");
        sourcePassThroughStdLibOpNames.add("selectByKind");
        argumentPassThroughStdLibOpNames = new HashSet<String>();
        argumentPassThroughStdLibOpNames.add("including");
        argumentPassThroughStdLibOpNames.add("insertAt");
        argumentPassThroughStdLibOpNames.add("append");
        argumentPassThroughStdLibOpNames.add("union");
    }

    public OperationCallTracebackStep(OperationCallExp sourceExpression, EClass context, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor, TracebackStepCache tracebackStepCache, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory, OCLFactory oclFactory) {
        super(sourceExpression, tupleLiteralNamesToLookFor, tracebackStepCache.getOppositeEndFinder(), operationBodyToCallMapper, unusedEvaluationRequestFactory, oclFactory);
        this.oppositeEndFinder = tracebackStepCache.getOppositeEndFinder();
        tracebackStepCache.put((OCLExpression)sourceExpression, tupleLiteralNamesToLookFor, this);
        OCLExpression body = operationBodyToCallMapper.getOperationBody((EOperation)sourceExpression.getReferredOperation());
        if (body != null) {
            this.allInstancesClass = null;
            this.filterResultsByCall = true;
            this.requireTypeExactly = false;
            this.getSteps().add(this.createTracebackStepAndScopeChange((OCLExpression)sourceExpression, body, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache));
        } else {
            this.filterResultsByCall = false;
            String opName = ((EOperation)sourceExpression.getReferredOperation()).getName();
            if (opName.equals("oclAsType")) {
                this.allInstancesClass = null;
                this.requireTypeExactly = false;
                this.handleOclAsType(sourceExpression, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache);
            } else if (opName.equals("selectByType")) {
                this.allInstancesClass = null;
                this.requireTypeExactly = true;
                this.handleSourcePassThroughOperation(sourceExpression, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache, opName);
            } else if (sourcePassThroughStdLibOpNames.contains(opName)) {
                this.allInstancesClass = null;
                this.requireTypeExactly = false;
                this.handleSourcePassThroughOperation(sourceExpression, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache, opName);
            } else if (opName.equals("allInstances")) {
                this.allInstancesClass = context;
                this.requireTypeExactly = false;
            } else {
                this.allInstancesClass = null;
                this.requireTypeExactly = false;
            }
        }
    }

    private void handleSourcePassThroughOperation(OperationCallExp sourceExpression, EClass context, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor, TracebackStepCache tracebackStepCache, String opName) {
        this.getSteps().add(this.createTracebackStepAndScopeChange((OCLExpression)sourceExpression, (OCLExpression)sourceExpression.getSource(), context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache));
        if (argumentPassThroughStdLibOpNames.contains(opName)) {
            int paramPos = 0;
            if (opName.equals("insertAt")) {
                paramPos = 1;
            }
            OCLExpression argument = (OCLExpression)sourceExpression.getArgument().get(paramPos);
            this.getSteps().add(this.createTracebackStepAndScopeChange((OCLExpression)sourceExpression, argument, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache));
        }
    }

    private void handleOclAsType(OperationCallExp sourceExpression, EClass context, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor, TracebackStepCache tracebackStepCache) {
        OCLExpression argument = (OCLExpression)sourceExpression.getArgument().get(0);
        if (!(argument instanceof TypeExp)) {
            throw new RuntimeException("What else could be the argument of oclAsType if not a TypeExp? " + argument.eClass().getName());
        }
        this.getSteps().add(this.createTracebackStepAndScopeChange((OCLExpression)sourceExpression, (OCLExpression)sourceExpression.getSource(), context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache));
    }

    @Override
    protected OperationCallExpKeyedSet performSubsequentTraceback(AnnotatedEObject source, UnusedEvaluationRequestSet pendingUnusedEvalRequests, TracebackCache tracebackCache, Notification changeEvent) {
        OperationCallExpKeyedSet result;
        if (this.allInstancesClass != null) {
            FlatSet preResult = new FlatSet();
            Object allInstancesLookupContext = changeEvent != null && changeEvent.getNotifier() != null ? (Notifier)changeEvent.getNotifier() : source.getAnnotatedObject();
            for (EObject roi : InstanceScopeAnalysis.getAllPossibleContextInstances((Notifier)allInstancesLookupContext, this.allInstancesClass, this.oppositeEndFinder)) {
                preResult.add(this.annotateEObject(source, roi));
            }
            result = preResult;
        } else {
            OperationCallExpKeyedSet preResult = this.requireTypeExactly && source.eClass() != this.requiredType ? FlatSet.emptySet() : super.performSubsequentTraceback(source, pendingUnusedEvalRequests, tracebackCache, changeEvent);
            result = this.filterResultsByCall && tracebackCache.getConfiguration().isOperationCallSelectionActive() ? new IterableAsOperationCallExpKeyedSet(preResult.getCombinedResultsFor((OperationCallExp)this.getExpression())) : preResult;
        }
        return result;
    }
}

