/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal.confirmation;

import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.signal.IndicationWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.confirmation.ConfirmationPrompt;
import org.eclipse.net4j.util.confirmation.Confirmation;
import org.eclipse.net4j.util.confirmation.IConfirmationProvider;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfirmationIndication<PROTOCOL extends SignalProtocol<?>>
extends IndicationWithMonitoring {
    private ConfirmationPrompt prompt;

    public ConfirmationIndication(SignalProtocol<?> protocol, short id, String name) {
        super(protocol, id, name);
    }

    public ConfirmationIndication(SignalProtocol<?> protocol, short signalID) {
        super(protocol, signalID);
    }

    public ConfirmationIndication(SignalProtocol<?> protocol, Enum<?> literal) {
        super(protocol, literal);
    }

    @Override
    protected int getIndicatingWorkPercent() {
        return 1;
    }

    @Override
    protected void indicating(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
        this.prompt = ConfirmationPrompt.read((ExtendedDataInput)in);
    }

    protected final ConfirmationPrompt getPrompt() {
        return this.prompt;
    }

    @Override
    protected void responding(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            try {
                IConfirmationProvider confirmationProvider = this.getConfirmationProvider();
                if (confirmationProvider == null) {
                    throw new IllegalStateException("No confirmation provider configured");
                }
                Confirmation confirmation = confirmationProvider.confirm(this.prompt.getSubject(), this.prompt.getMessage(), this.prompt.getAcceptableResponses(), this.prompt.getSuggestedResponse());
                if (confirmation == null) {
                    throw new IllegalStateException("No confirmation provided");
                }
                out.writeBoolean(true);
                out.writeEnum((Enum)confirmation);
            }
            catch (Throwable ex) {
                out.writeBoolean(false);
                OM.LOG.error(ex);
                async.stop();
                monitor.done();
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }

    public IConfirmationProvider getConfirmationProvider() {
        return ((IConfirmationProvider.Provider)this.getProtocol()).getConfirmationProvider();
    }
}

