/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.connector.IServerConnector;
import org.eclipse.net4j.internal.tcp.TCPAcceptor;
import org.eclipse.net4j.internal.tcp.TCPConnector;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.tcp.ITCPSelector;
import org.eclipse.spi.net4j.InternalConnector;

public class TCPServerConnector
extends TCPConnector
implements IServerConnector {
    private TCPAcceptor acceptor;

    public TCPServerConnector(TCPAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public TCPAcceptor getAcceptor() {
        return this.acceptor;
    }

    public ILocationAware.Location getLocation() {
        return ILocationAware.Location.SERVER;
    }

    public String getHost() {
        try {
            return this.getSocketChannel().socket().getInetAddress().getHostAddress();
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public int getPort() {
        try {
            return this.getSocketChannel().socket().getPort();
        }
        catch (RuntimeException ex) {
            return 0;
        }
    }

    public String toString() {
        if (this.getUserID() == null) {
            return MessageFormat.format("TCPServerConnector[{0}:{1}]", this.getHost(), this.getPort());
        }
        return MessageFormat.format("TCPServerConnector[{2}@{0}:{1}]", this.getHost(), this.getPort(), this.getUserID());
    }

    public void handleRegistration(ITCPSelector selector, SocketChannel socketChannel) {
        super.handleRegistration(selector, socketChannel);
        try {
            this.acceptor.addConnector((InternalConnector)this);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            this.deactivateAsync();
        }
    }
}

