/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.widgets.internal;

import java.util.Collection;
import org.eclipse.jwt.transformations.api.Transformation;
import org.eclipse.jwt.transformations.api.io.ContentChangeListener;
import org.eclipse.jwt.transformations.internal.TransformationsMessages;
import org.eclipse.jwt.transformations.widgets.internal.ObjectPickerCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationGroup {
    private static final int DESCRIPTION_WIDTH_HINT = 400;
    private final ContentChangeListener pageListener;
    private final Group delegate;
    final TransformationPickerCombo transformationsCombo;
    final Label descriptionLabel;

    public TransformationGroup(Composite parent, ContentChangeListener pageListener, Collection<Transformation> transformations, String comboText) {
        this.pageListener = pageListener;
        this.delegate = new Group(parent, 0);
        this.delegate.setText(TransformationsMessages.transformationGroup);
        this.delegate.setLayout((Layout)new GridLayout(1, false));
        this.transformationsCombo = new TransformationPickerCombo(comboText);
        this.transformationsCombo.setData(transformations);
        this.descriptionLabel = new Label((Composite)this.delegate, 16448);
        GridData descriptionLabelLayoutData = new GridData(4, 4, true, true);
        descriptionLabelLayoutData.widthHint = 400;
        this.descriptionLabel.setLayoutData((Object)descriptionLabelLayoutData);
    }

    public Group getControl() {
        return this.delegate;
    }

    public Transformation getTransformation() {
        return (Transformation)this.transformationsCombo.getSelection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformationPickerCombo
    extends ObjectPickerCombo<Transformation, Transformation> {
        public TransformationPickerCombo(String comboText) {
            super((Composite)TransformationGroup.this.delegate, 0);
            this.getControl().setText(comboText);
            this.getControl().setLayoutData((Object)new GridData(768));
        }

        @Override
        protected String extractLabel(Transformation entry) {
            return entry.getName();
        }

        @Override
        protected Transformation extractData(Transformation entry) {
            return entry;
        }

        @Override
        protected void onSelectionChanged() {
            Transformation selection = (Transformation)this.getSelection();
            if (selection != null) {
                TransformationGroup.this.descriptionLabel.setText(selection.getDescription());
            }
            TransformationGroup.this.delegate.layout(true);
            TransformationGroup.this.delegate.getParent().update();
            TransformationGroup.this.pageListener.contentChanged();
        }
    }
}

