/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.javafx;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.javafx.internal.JavafxToolkitInfo;

/**
 * Factory for creating components from the javafx toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2018-11-27T13:11:26.681Z")
public class JavafxComponents {
    
    @NonNull private final static ToolkitInfo TOOLKIT_INFORMATION = JavafxToolkit.createToolkitInformation();

    private JavafxComponents() {
        super();
    }
    
    /** 
     *  @return the toolkit information, not recommended to be modified
     */
    @NonNull public static ToolkitInfo getToolkitInformation() {
        return TOOLKIT_INFORMATION;
    }

    /** create a new representative for a {@link Stage} component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.Application createStage () {
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Stage();
    }
    
    /** create a new instance of StageActionHandler 
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ApplicationActionHandler createStageActionHandler () {
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.StageActionHandler();
    }
    /** create a new representative for a {@link JavaReflection} component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ReflectionComponent createJavaReflection () {
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.JavaReflection();
    }
    
    /** create a new instance of JavaReflectionActionHandler 
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ReflectionComponentActionHandler createJavaReflectionActionHandler () {
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.JavaReflectionActionHandler();
    }
    /** create a new representative for a {@link javafx.scene.control.ButtonBase} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButtonBase (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.ButtonBase(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.ButtonBase} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createButtonBaseActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.ButtonBaseActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.Button} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Button(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.Button} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.ButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.MenuButton} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createMenuButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.MenuButton(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.MenuButton} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createMenuButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.MenuButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.CheckBox} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createCheckBox (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.CheckBox(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.CheckBox} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createCheckBoxActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.CheckBoxActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.Hyperlink} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createHyperlink (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Hyperlink(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.Hyperlink} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createHyperlinkActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.HyperlinkActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.ToggleButton} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createToggleButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.ToggleButton(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.ToggleButton} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createToggleButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.ToggleButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.RadioButton} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createRadioButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.RadioButton(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.RadioButton} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createRadioButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.RadioButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.Label} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createLabel (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Label(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.Label} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createLabelActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.LabelActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TitledPane} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createTitledPane (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TitledPane(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.TitledPane} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createTitledPaneActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.TitledPaneActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.text.Text} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createText (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Text(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.text.Text} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createTextActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.TextActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TextInputControl} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextInputControl (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TextInputControl(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.TextInputControl} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler createTextInputControlActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.TextInputControlActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TextField} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextField (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TextField(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.TextField} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler createTextFieldActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.TextFieldActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.PasswordField} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createPasswordField (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.PasswordField(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.PasswordField} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler createPasswordFieldActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.PasswordFieldActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TextArea} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextArea (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TextArea(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.TextArea} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler createTextAreaActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.TextAreaActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TableView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TableComponent createTableView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TableComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TableView(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.TableView} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TableComponentActionHandler createTableViewActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TableComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.TableViewActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TreeView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TreeComponent createTreeView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TreeComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TreeView(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.TreeView} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TreeComponentActionHandler createTreeViewActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TreeComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.TreeViewActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TreeTableView} UI component.
     * @since 5.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.javafx.components.TreeTableView createTreeTableView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.javafx.components.TreeTableView> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TreeTableView(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.TreeTableView} UI component.
     * @since 5.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.javafx.components.handler.TreeTableViewActionHandler createTreeTableViewActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.javafx.components.TreeTableView> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.TreeTableViewActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.Accordion} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createAccordion (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Accordion(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.Accordion} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TabComponentActionHandler createAccordionActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.AccordionActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.ChoiceBox} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createChoiceBox (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ComboComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.ChoiceBox(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.ChoiceBox} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ComboComponentActionHandler createChoiceBoxActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ComboComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.ChoiceBoxActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.ComboBox} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createComboBox (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ComboComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.ComboBox(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.ComboBox} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ComboComponentActionHandler createComboBoxActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ComboComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.ComboBoxActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TabPane} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createTabPane (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TabPane(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.TabPane} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TabComponentActionHandler createTabPaneActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.TabPaneActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link MenuBar} component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.MenuBarComponent createMenuBar () {
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.MenuBar();
    }
    
    /** create a new instance of MenuBarActionHandler 
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.MenuBarComponentActionHandler createMenuBarActionHandler () {
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.MenuBarActionHandler();
    }
    /** create a new representative for a {@link javafx.scene.control.ListView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createListView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.ListView(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.ListView} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ListComponentActionHandler createListViewActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.ListViewActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.image.ImageView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createImageView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.ImageView(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.image.ImageView} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.base.components.handler.GraphicsComponentActionHandler createImageViewActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.ImageViewActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link Tooltip} component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TooltipComponent createTooltip () {
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Tooltip();
    }
    
    /** create a new instance of TooltipActionHandler 
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TooltipComponentActionHandler createTooltipActionHandler () {
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.TooltipActionHandler();
    }
    /** create a new representative for a {@link javafx.scene.control.DatePicker} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createDatePicker (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.DatePicker(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.DatePicker} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler createDatePickerActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.DatePickerActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link OperatingSystem} component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.OperatingSystemComponent createOperatingSystem () {
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.OperatingSystem();
    }
    
    /** create a new instance of OperatingSystemActionHandler 
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.OperatingSystemComponentActionHandler createOperatingSystemActionHandler () {
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.OperatingSystemActionHandler();
    }
    /** create a new representative for a {@link javafx.scene.control.Slider} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.SliderComponent createSlider (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.SliderComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Slider(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.control.Slider} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.SliderComponentActionHandler createSliderActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.SliderComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.SliderActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.shape.Shape} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createShape (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Shape(componentIdentifier);
    }
    
    /** create a new representative for a {@link javafx.scene.shape.Shape} UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.base.components.handler.GraphicsComponentActionHandler createShapeActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.handler.ShapeActionHandler(componentIdentifier);
    }
}