/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.jar.Manifest;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;

@Command(common=true, usage="usage_DisplayTheVersionOfJgit")
class Version
extends TextBuiltin {
    Version() {
    }

    @Override
    protected void run() throws Exception {
        String version = this.getImplementationVersion();
        if (version == null) {
            version = this.getBundleVersion();
        }
        if (version == null) {
            throw Version.die(CLIText.get().cannotReadPackageInformation);
        }
        this.outw.println(MessageFormat.format(CLIText.get().jgitVersion, version));
    }

    @Override
    protected final boolean requiresRepository() {
        return false;
    }

    private String getImplementationVersion() {
        Package pkg = this.getClass().getPackage();
        return pkg == null ? null : pkg.getImplementationVersion();
    }

    private String getBundleVersion() {
        URL url;
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl instanceof URLClassLoader && (url = ((URLClassLoader)cl).findResource("META-INF/MANIFEST.MF")) != null) {
            return Version.getBundleVersion(url);
        }
        return null;
    }

    private static String getBundleVersion(URL url) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = url.openStream();){
                Manifest manifest = new Manifest(is);
                return manifest.getMainAttributes().getValue("Bundle-Version");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

