/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.mvc.fx.operations.ChangeViewportOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.policies.ViewportPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;
import org.eclipse.gef.zest.fx.models.NavigationModel;
import org.eclipse.gef.zest.fx.operations.NavigateOperation;
import org.eclipse.gef.zest.fx.parts.NodePart;

public class SemanticZoomPolicy
extends ViewportPolicy {
    private NavigationModel navigationModel;
    private IViewer viewer;

    public ITransactionalOperation commit() {
        this.navigationModel = null;
        this.viewer = null;
        return super.commit();
    }

    protected ITransactionalOperation createOperation() {
        return new NavigateOperation(this.viewer);
    }

    protected List<NodePart> findNestingNodes() {
        ObservableList rootChildren = this.getHost().getRoot().getChildrenUnmodifiable();
        ObservableList graphChildren = rootChildren.size() > 0 ? ((IVisualPart)rootChildren.get(0)).getChildrenUnmodifiable() : Collections.emptyList();
        List nestingNodeContentParts = PartUtils.filterParts((Collection)graphChildren, NodePart.class);
        int i = nestingNodeContentParts.size() - 1;
        while (i >= 0) {
            NodePart nodePart = (NodePart)((Object)nestingNodeContentParts.get(i));
            if (nodePart.getContent().getNestedGraph() == null) {
                nestingNodeContentParts.remove(i);
            }
            --i;
        }
        return nestingNodeContentParts;
    }

    protected ChangeViewportOperation getChangeViewportOperation() {
        return this.getNavigateOperation().getChangeViewportOperation();
    }

    protected NavigateOperation getNavigateOperation() {
        return (NavigateOperation)this.getOperation();
    }

    public void init() {
        this.viewer = this.getHost().getRoot().getViewer();
        this.navigationModel = (NavigationModel)this.viewer.getAdapter(NavigationModel.class);
        if (this.navigationModel == null) {
            throw new IllegalArgumentException("NavigationModel could not be obtained!");
        }
        super.init();
    }

    public void zoom(boolean relative, boolean discretize, double relativeZoom, double sceneX, double sceneY) {
        this.checkInitialized();
        double initialZoomLevel = this.getChangeViewportOperation().getNewContentTransform().getScaleX();
        double finalZoomLevel = initialZoomLevel * relativeZoom;
        boolean openGraph = false;
        if (initialZoomLevel < finalZoomLevel && finalZoomLevel > 3.0) {
            List<NodePart> nestingNodeContentParts = this.findNestingNodes();
            double pivotDistance = Double.MAX_VALUE;
            NodePart pivotPart = null;
            InfiniteCanvas infiniteCanvas = ((InfiniteCanvasViewer)this.viewer).getCanvas();
            Rectangle viewportBounds = new Rectangle(0.0, 0.0, infiniteCanvas.getWidth(), infiniteCanvas.getHeight());
            Point pivotPoint = FX2Geometry.toPoint((Point2D)infiniteCanvas.sceneToLocal(sceneX, sceneY));
            for (NodePart nodePart : new ArrayList<NodePart>(nestingNodeContentParts)) {
                double distance;
                Group visual = (Group)nodePart.getVisual();
                Bounds boundsInScene = visual.localToScene(visual.getLayoutBounds());
                Rectangle boundsInViewport = FX2Geometry.toRectangle((Bounds)infiniteCanvas.sceneToLocal(boundsInScene));
                if (!boundsInViewport.touches(viewportBounds) || !((distance = boundsInViewport.getCenter().getDistance(pivotPoint)) < pivotDistance)) continue;
                pivotPart = nodePart;
            }
            if (pivotPart != null) {
                openGraph = true;
                this.getNavigateOperation().setFinalState(pivotPart.getContent().getNestedGraph(), true);
            }
        } else if (initialZoomLevel > finalZoomLevel && finalZoomLevel < 0.7) {
            Graph nestingGraph;
            Graph currentGraph = (Graph)this.viewer.getContents().get(0);
            Graph graph = nestingGraph = currentGraph.getNestingNode() != null ? currentGraph.getNestingNode().getGraph() : null;
            if (nestingGraph != null) {
                openGraph = true;
                this.getNavigateOperation().setFinalState(nestingGraph, false);
            }
        }
        if (openGraph) {
            this.locallyExecuteOperation();
        } else {
            super.zoom(true, true, relativeZoom, sceneX, sceneY);
        }
        for (NodePart nestingNodePart : this.findNestingNodes()) {
            nestingNodePart.refreshContentChildren();
            nestingNodePart.refreshVisual();
        }
    }
}

