/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.behaviors;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.SetChangeListener;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.ILayoutFilter;
import org.eclipse.gef.layout.LayoutContext;
import org.eclipse.gef.layout.LayoutProperties;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;
import org.eclipse.gef.zest.fx.ZestProperties;
import org.eclipse.gef.zest.fx.behaviors.AbstractLayoutBehavior;
import org.eclipse.gef.zest.fx.models.HidingModel;
import org.eclipse.gef.zest.fx.models.NavigationModel;
import org.eclipse.gef.zest.fx.parts.GraphPart;
import org.eclipse.gef.zest.fx.parts.NodePart;

public class GraphLayoutBehavior
extends AbstractLayoutBehavior {
    private Runnable postLayout = new Runnable(){

        @Override
        public void run() {
            GraphLayoutBehavior.this.postLayout();
        }
    };
    private Runnable preLayout = new Runnable(){

        @Override
        public void run() {
            GraphLayoutBehavior.this.preLayout();
        }
    };
    private Parent nestingVisual;
    private ChangeListener<? super Bounds> nestingVisualLayoutBoundsChangeListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldLayoutBounds, Bounds newLayoutBounds) {
            GraphLayoutBehavior.this.updateBounds();
        }
    };
    private ChangeListener<? super Bounds> viewportBoundsChangeListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldLayoutBounds, Bounds newLayoutBounds) {
            GraphLayoutBehavior.this.updateBounds();
        }
    };
    private ListChangeListener<IVisualPart<? extends Node>> childrenObserver = new ListChangeListener<IVisualPart<? extends Node>>(){

        public void onChanged(ListChangeListener.Change<? extends IVisualPart<? extends Node>> c) {
            GraphLayoutBehavior.this.applyLayout(true, null);
        }
    };
    private SetChangeListener<org.eclipse.gef.graph.Node> hidingModelObserver = new SetChangeListener<org.eclipse.gef.graph.Node>(){

        public void onChanged(SetChangeListener.Change<? extends org.eclipse.gef.graph.Node> change) {
            GraphLayoutBehavior.this.applyLayout(true, null);
        }
    };
    private boolean skipNextLayout;

    public void applyLayout(boolean clean, Object extra) {
        if (this.getHost().getChildrenUnmodifiable().size() != this.getHost().getContentChildrenUnmodifiable().size()) {
            return;
        }
        List childContentParts = PartUtils.filterParts((Collection)this.getHost().getChildrenUnmodifiable(), IContentPart.class);
        for (IContentPart cp : childContentParts) {
            if (this.getHost().getContentChildrenUnmodifiable().contains(cp.getContent())) continue;
            return;
        }
        if (this.skipNextLayout) {
            this.skipNextLayout = false;
            return;
        }
        Graph graph = this.getHost().getContent();
        LayoutContext layoutContext = this.getLayoutContext();
        ILayoutAlgorithm layoutAlgorithm = ZestProperties.getLayoutAlgorithm(graph);
        if (layoutAlgorithm != null) {
            if (layoutContext.getLayoutAlgorithm() != layoutAlgorithm) {
                layoutContext.setLayoutAlgorithm(layoutAlgorithm);
            }
        } else if (layoutContext.getLayoutAlgorithm() != null) {
            layoutContext.setLayoutAlgorithm(null);
        }
        if (layoutContext.getGraph() != graph) {
            layoutContext.setGraph(graph);
        }
        layoutContext.applyLayout(true);
    }

    protected Rectangle computeLayoutBounds() {
        Rectangle newBounds = new Rectangle();
        if (this.nestingVisual != null) {
            Bounds layoutBounds = this.nestingVisual.getLayoutBounds();
            newBounds = new Rectangle(0.0, 0.0, layoutBounds.getWidth() / 0.25, layoutBounds.getHeight() / 0.25);
        } else {
            InfiniteCanvas canvas = this.getInfiniteCanvas();
            double windowWidth = canvas.getScene().getWindow().getWidth();
            double windowHeight = canvas.getScene().getWindow().getHeight();
            newBounds = new Rectangle(0.0, 0.0, Double.isFinite(windowWidth) ? Math.min(canvas.getWidth(), windowWidth) : canvas.getWidth(), Double.isFinite(windowHeight) ? Math.min(canvas.getHeight(), windowHeight) : canvas.getHeight());
        }
        return newBounds;
    }

    @Override
    protected void doActivate() {
        NavigationModel navigationModel;
        this.getHost().getChildrenUnmodifiable().addListener(this.childrenObserver);
        LayoutContext layoutContext = this.getLayoutContext();
        layoutContext.schedulePreLayoutPass(this.preLayout);
        layoutContext.schedulePostLayoutPass(this.postLayout);
        if (this.getHost().getParent() == this.getHost().getRoot()) {
            this.getInfiniteCanvas().scrollableBoundsProperty().addListener(this.viewportBoundsChangeListener);
        } else {
            this.nestingVisual = ((Group)this.getHost().getVisual()).getParent();
            this.nestingVisual.layoutBoundsProperty().addListener(this.nestingVisualLayoutBoundsChangeListener);
        }
        final HidingModel hidingModel = (HidingModel)this.getHost().getRoot().getViewer().getAdapter(HidingModel.class);
        if (hidingModel != null) {
            this.getLayoutContext().addLayoutFilter(new ILayoutFilter(){
                Map<Object, IContentPart<? extends Node>> contentPartMap;
                {
                    this.contentPartMap = GraphLayoutBehavior.this.getHost().getViewer().getContentPartMap();
                }

                public boolean isLayoutIrrelevant(Edge edge) {
                    if (!this.contentPartMap.containsKey(edge)) {
                        return true;
                    }
                    if (!this.contentPartMap.get(edge).isActive()) {
                        return true;
                    }
                    return Boolean.TRUE.equals(ZestProperties.getLayoutIrrelevant(edge)) || this.isLayoutIrrelevant(edge.getSource()) || hidingModel.isHidden(edge.getSource()) || this.isLayoutIrrelevant(edge.getTarget()) || hidingModel.isHidden(edge.getTarget());
                }

                public boolean isLayoutIrrelevant(org.eclipse.gef.graph.Node node) {
                    if (!this.contentPartMap.containsKey(node)) {
                        return true;
                    }
                    if (!this.contentPartMap.get(node).isActive()) {
                        return true;
                    }
                    return Boolean.TRUE.equals(ZestProperties.getLayoutIrrelevant(node)) || hidingModel.isHidden(node);
                }
            });
            hidingModel.hiddenProperty().addListener(this.hidingModelObserver);
        }
        NavigationModel.ViewportState savedViewport = (navigationModel = (NavigationModel)this.getHost().getRoot().getViewer().getAdapter(NavigationModel.class)) == null ? null : navigationModel.getViewportState(this.getHost().getContent());
        InfiniteCanvas canvas = ((InfiniteCanvasViewer)this.getHost().getRoot().getViewer()).getCanvas();
        boolean isNested = this.getNestingPart() != null;
        boolean isViewportChanged = savedViewport != null && (savedViewport.getWidth() != canvas.getWidth() || savedViewport.getHeight() != canvas.getHeight());
        boolean bl = this.skipNextLayout = savedViewport != null;
        if (savedViewport == null || isNested || isViewportChanged) {
            LayoutProperties.setBounds((Graph)this.getHost().getContent(), (Rectangle)this.computeLayoutBounds());
            this.applyLayout(true, null);
        }
    }

    @Override
    protected void doDeactivate() {
        this.getHost().getChildrenUnmodifiable().removeListener(this.childrenObserver);
        HidingModel hidingModel = (HidingModel)this.getHost().getRoot().getViewer().getAdapter(HidingModel.class);
        if (hidingModel != null) {
            hidingModel.hiddenProperty().removeListener(this.hidingModelObserver);
        }
        LayoutContext layoutContext = this.getLayoutContext();
        layoutContext.unschedulePreLayoutPass(this.preLayout);
        layoutContext.unschedulePostLayoutPass(this.postLayout);
        if (this.nestingVisual != null) {
            this.nestingVisual.layoutBoundsProperty().removeListener(this.nestingVisualLayoutBoundsChangeListener);
        } else {
            this.getInfiniteCanvas().scrollableBoundsProperty().removeListener(this.viewportBoundsChangeListener);
        }
        this.nestingVisual = null;
    }

    public GraphPart getHost() {
        return (GraphPart)super.getHost();
    }

    protected InfiniteCanvas getInfiniteCanvas() {
        return ((InfiniteCanvasViewer)this.getHost().getRoot().getViewer()).getCanvas();
    }

    @Override
    protected LayoutContext getLayoutContext() {
        return (LayoutContext)this.getHost().getAdapter(LayoutContext.class);
    }

    protected NodePart getNestingPart() {
        if (this.getHost().getParent() instanceof NodePart) {
            return (NodePart)this.getHost().getParent();
        }
        return null;
    }

    @Override
    protected void postLayout() {
        for (IVisualPart child : this.getHost().getChildrenUnmodifiable()) {
            AbstractLayoutBehavior childLayoutBehavior;
            if (child.getViewer() == null || (childLayoutBehavior = (AbstractLayoutBehavior)((Object)child.getAdapter(AbstractLayoutBehavior.class))) == null) continue;
            childLayoutBehavior.postLayout();
        }
    }

    @Override
    protected void preLayout() {
        for (IVisualPart child : this.getHost().getChildrenUnmodifiable()) {
            AbstractLayoutBehavior childLayoutBehavior;
            if (child.getViewer() == null || (childLayoutBehavior = (AbstractLayoutBehavior)((Object)child.getAdapter(AbstractLayoutBehavior.class))) == null) continue;
            childLayoutBehavior.preLayout();
        }
    }

    protected void updateBounds() {
        if (((Group)this.getHost().getVisual()).getScene().getWindow() == null) {
            return;
        }
        Rectangle newBounds = this.computeLayoutBounds();
        Rectangle oldBounds = LayoutProperties.getBounds((Graph)this.getHost().getContent());
        if (!(oldBounds == newBounds || oldBounds != null && oldBounds.equals((Object)newBounds))) {
            LayoutProperties.setBounds((Graph)this.getHost().getContent(), (Rectangle)newBounds);
            this.applyLayout(true, null);
        }
    }
}

