/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.ui.internal.mergeresolution;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.compare.egit.ui.internal.EMFCompareEGitUIMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PostMergeDialog
extends Dialog {
    private static final int MARGIN_WIDTH = 15;
    private static final int MARGIN_TOP = 15;
    private static final int VERTICAL_SPACING = 10;
    private final IResource[] resources;

    public PostMergeDialog(Shell parentShell, IResource[] resources) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setBlockOnOpen(true);
        this.resources = resources;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(EMFCompareEGitUIMessages.getString("post.merge.dialog.title"));
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginWidth = 15;
        gridLayout.marginTop = 15;
        composite.setLayout((Layout)gridLayout);
        Label resultLabel = new Label(composite, 0);
        resultLabel.setText(EMFCompareEGitUIMessages.getString("post.merge.dialog.text"));
        resultLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        TableViewer viewer = new TableViewer(composite);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ListStyleProvider styleProvider = new ListStyleProvider();
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)styleProvider));
        PostMergeDialog.applyDialogFont((Control)composite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo(viewer.getControl());
        viewer.setInput((Object)this.resources);
        return composite;
    }

    public class ListStyleProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private final WorkbenchLabelProvider wrapped = new WorkbenchLabelProvider();

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
            this.wrapped.dispose();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public StyledString getStyledText(Object element) {
            IResource resource = (IResource)element;
            return new StyledString(resource.getProjectRelativePath().toString());
        }

        public Image getImage(Object element) {
            return this.wrapped.getImage(element);
        }
    }
}

