/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndicationWithMonitoring;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class SwitchTargetIndication
extends CDOServerReadIndicationWithMonitoring {
    private List<CDORevisionDelta> allChangedObjects = new ArrayList<CDORevisionDelta>();
    private List<CDOID> allDetachedObjects = new ArrayList<CDOID>();

    public SwitchTargetIndication(CDOServerProtocol protocol) {
        super(protocol, (short)4);
    }

    protected int getIndicatingWorkPercent() {
        return 90;
    }

    protected void indicating(CDODataInput in, OMMonitor monitor) throws IOException {
        try {
            monitor.begin();
            OMMonitor.Async async = monitor.forkAsync();
            try {
                int viewID = in.readXInt();
                CDOBranchPoint branchPoint = in.readCDOBranchPoint();
                int size = in.readXInt();
                ArrayList<CDOID> invalidObjects = new ArrayList<CDOID>(size);
                int i = 0;
                while (i < size) {
                    CDOID id = in.readCDOID();
                    invalidObjects.add(id);
                    ++i;
                }
                InternalView view = this.getView(viewID);
                view.changeTarget(branchPoint, invalidObjects, this.allChangedObjects, this.allDetachedObjects);
            }
            finally {
                async.stop();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void responding(CDODataOutput out, OMMonitor monitor) throws IOException {
        out.writeXInt(this.allChangedObjects.size());
        for (CDORevisionDelta delta : this.allChangedObjects) {
            out.writeCDORevisionDelta(delta);
        }
        out.writeXInt(this.allDetachedObjects.size());
        for (CDOID id : this.allDetachedObjects) {
            out.writeCDOID(id);
        }
    }
}

