/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.dltk.internal.testing.model.ITestRunListener2;
import org.eclipse.dltk.internal.testing.model.ITestRunnerClient;
import org.eclipse.dltk.internal.testing.model.TestRunSession;
import org.eclipse.dltk.testing.DLTKTestingPlugin;

public class SocketTestRunnerClient
implements ITestRunnerClient {
    private static boolean DEBUG = false;
    private final StringBuffer fFailedTrace = new StringBuffer();
    private final StringBuffer fExpectedResult = new StringBuffer();
    private final StringBuffer fActualResult = new StringBuffer();
    private final StringBuffer fFailedRerunTrace = new StringBuffer();
    ProcessingState fDefaultState = new DefaultProcessingState();
    ProcessingState fTraceState = new TraceProcessingState();
    ProcessingState fExpectedState = new AppendingProcessingState(this.fExpectedResult, "%EXPECTE");
    ProcessingState fActualState = new AppendingProcessingState(this.fActualResult, "%ACTUALE");
    ProcessingState fRerunState = new AppendingProcessingState(this.fFailedRerunTrace, "%RTRACEE");
    ProcessingState fCurrentState = this.fDefaultState;
    private ITestRunListener2[] fListeners;
    private ServerSocket fServerSocket;
    private Socket fSocket;
    private final int fPort;
    private PrintWriter fWriter;
    private BufferedReader fBufferedReader;
    private String fVersion;
    private String fFailedTest;
    private String fFailedTestId;
    private int fFailureKind;
    private boolean fDebug = false;

    public SocketTestRunnerClient(int port) {
        this.fPort = port;
    }

    @Override
    public synchronized void startListening(ITestRunListener2 listener) {
        this.fListeners = new ITestRunListener2[]{listener};
        ServerConnection connection = new ServerConnection(this.fPort);
        connection.start();
    }

    @Override
    public synchronized void stopTest() {
        if (this.isRunning()) {
            this.fWriter.println(">STOP   ");
            this.fWriter.flush();
        }
    }

    @Override
    public synchronized void stopWaiting() {
        if (this.fServerSocket != null && !this.fServerSocket.isClosed() && this.fSocket == null) {
            this.shutDown();
        }
    }

    private synchronized void shutDown() {
        if (this.fDebug) {
            System.out.println("shutdown " + this.fPort);
        }
        if (this.fWriter != null) {
            this.fWriter.close();
            this.fWriter = null;
        }
        try {
            if (this.fBufferedReader != null) {
                this.fBufferedReader.close();
                this.fBufferedReader = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
                this.fSocket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.fServerSocket != null) {
                this.fServerSocket.close();
                this.fServerSocket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isRunning() {
        return this.fSocket != null;
    }

    private String readMessage(BufferedReader in) throws IOException {
        return in.readLine();
    }

    private void receiveMessage(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
        this.fCurrentState = this.fCurrentState.readMessage(message);
    }

    private void scanOldReranMessage(String arg) {
        int c = arg.indexOf(" ");
        int t = arg.indexOf(" ", c + 1);
        String className = arg.substring(0, c);
        String testName = arg.substring(c + 1, t);
        String status = arg.substring(t + 1);
        String testId = String.valueOf(className) + testName;
        this.notifyTestReran(testId, className, testName, status);
    }

    private void scanReranMessage(String arg) {
        int i = arg.indexOf(32);
        int c = arg.indexOf(32, i + 1);
        int t = arg.indexOf(32, c + 1);
        String testId = arg.substring(0, i);
        String className = arg.substring(i + 1, c);
        String testName = arg.substring(c + 1, t);
        String status = arg.substring(t + 1);
        this.notifyTestReran(testId, className, testName, status);
    }

    private void notifyTestReran(String testId, String className, String testName, String status) {
        int statusCode = 0;
        if (status.equals("FAILURE")) {
            statusCode = 2;
        } else if (status.equals("ERROR")) {
            statusCode = 1;
        }
        String trace = "";
        if (statusCode != 0) {
            trace = this.fFailedRerunTrace.toString();
        }
        this.notifyTestReran(testId, className, testName, statusCode, trace);
    }

    private void extractFailure(String arg, int status) {
        String[] s = this.extractTestId(arg);
        this.fFailedTestId = s[0];
        this.fFailedTest = s[1];
        this.fFailureKind = status;
    }

    String[] extractTestId(String arg) {
        String[] result = new String[2];
        if (!this.hasTestId()) {
            result[0] = arg;
            result[1] = arg;
            return result;
        }
        int i = arg.indexOf(44);
        result[0] = arg.substring(0, i);
        if (arg.indexOf(44, i + 1) >= 0 || arg.indexOf(92, i + 1) >= 0) {
            StringBuffer sb = new StringBuffer(arg.length() - i - 1);
            TestRunSession.scanTestName(arg, i + 1, sb, false);
            result[1] = sb.toString().trim();
        } else {
            result[1] = arg.substring(i + 1, arg.length());
        }
        return result;
    }

    private boolean hasTestId() {
        if (this.fVersion == null) {
            return true;
        }
        return this.fVersion.equals("v2");
    }

    private void notifyTestReran(final String testId, final String className, final String testName, final int statusCode, final String trace) {
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    listener.testReran(testId, className, testName, statusCode, trace, fExpectedResult.toString(), fActualResult.toString());
                }
            });
            ++i;
        }
    }

    private void notifyTestTreeEntry(String treeEntry) {
        int i = 0;
        while (i < this.fListeners.length) {
            ITestRunListener2 listener = this.fListeners[i];
            if (!this.hasTestId()) {
                listener.testTreeEntry(this.fakeTestId(treeEntry));
            } else {
                listener.testTreeEntry(treeEntry);
            }
            ++i;
        }
    }

    private String fakeTestId(String treeEntry) {
        int index0 = treeEntry.indexOf(44);
        String testName = treeEntry.substring(0, index0).trim();
        return String.valueOf(testName) + "," + treeEntry;
    }

    private void notifyTestRunStopped(final long elapsedTime) {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    listener.testRunStopped(elapsedTime);
                }
            });
            ++i;
        }
    }

    private void testRunEnded(final long elapsedTime) {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    listener.testRunEnded(elapsedTime);
                }
            });
            ++i;
        }
    }

    private void notifyTestEnded(final String test) {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    String[] s = this.extractTestId(test);
                    listener.testEnded(s[0], s[1]);
                }
            });
            ++i;
        }
    }

    private void notifyTestStarted(final String test) {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    String[] s = this.extractTestId(test);
                    listener.testStarted(s[0], s[1]);
                }
            });
            ++i;
        }
    }

    private void notifyTestRunStarted(final int count) {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    listener.testRunStarted(count);
                }
            });
            ++i;
        }
    }

    private void notifyTestFailed() {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    listener.testFailed(fFailureKind, fFailedTestId, fFailedTest, fFailedTrace.toString(), fExpectedResult.toString(), fActualResult.toString(), 4);
                }
            });
            ++i;
        }
    }

    private void notifyTestRunTerminated() {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    listener.testRunTerminated();
                }
            });
            ++i;
        }
    }

    @Override
    public void rerunTest(String testId, String className, String testName) {
        if (this.isRunning()) {
            this.fActualResult.setLength(0);
            this.fExpectedResult.setLength(0);
            this.fWriter.println(">RERUN  " + testId + " " + className + " " + testName);
            this.fWriter.flush();
        }
    }

    class AppendingProcessingState
    extends ProcessingState {
        private final StringBuffer fBuffer;
        private String fEndString;

        AppendingProcessingState(StringBuffer buffer, String endString) {
            this.fBuffer = buffer;
            this.fEndString = endString;
        }

        @Override
        ProcessingState readMessage(String message) {
            if (message.startsWith(this.fEndString)) {
                this.entireStringRead();
                return SocketTestRunnerClient.this.fDefaultState;
            }
            this.fBuffer.append(message);
            this.fBuffer.append('\n');
            return this;
        }

        void entireStringRead() {
        }
    }

    class DefaultProcessingState
    extends ProcessingState {
        DefaultProcessingState() {
        }

        @Override
        ProcessingState readMessage(String message) {
            if (message.startsWith("%TRACES ")) {
                SocketTestRunnerClient.this.fFailedTrace.setLength(0);
                return SocketTestRunnerClient.this.fTraceState;
            }
            if (message.startsWith("%EXPECTS")) {
                SocketTestRunnerClient.this.fExpectedResult.setLength(0);
                return SocketTestRunnerClient.this.fExpectedState;
            }
            if (message.startsWith("%ACTUALS")) {
                SocketTestRunnerClient.this.fActualResult.setLength(0);
                return SocketTestRunnerClient.this.fActualState;
            }
            if (message.startsWith("%RTRACES")) {
                SocketTestRunnerClient.this.fFailedRerunTrace.setLength(0);
                return SocketTestRunnerClient.this.fRerunState;
            }
            String arg = message.substring(8);
            if (message.startsWith("%TESTC  ")) {
                int count = 0;
                int v = arg.indexOf(32);
                if (v == -1) {
                    SocketTestRunnerClient.this.fVersion = "v1";
                    count = Integer.parseInt(arg);
                } else {
                    SocketTestRunnerClient.this.fVersion = arg.substring(v + 1);
                    String sc = arg.substring(0, v);
                    count = Integer.parseInt(sc);
                }
                SocketTestRunnerClient.this.notifyTestRunStarted(count);
                return this;
            }
            if (message.startsWith("%TESTS  ")) {
                SocketTestRunnerClient.this.notifyTestStarted(arg);
                return this;
            }
            if (message.startsWith("%TESTE  ")) {
                SocketTestRunnerClient.this.notifyTestEnded(arg);
                return this;
            }
            if (message.startsWith("%ERROR  ")) {
                SocketTestRunnerClient.this.extractFailure(arg, 1);
                return this;
            }
            if (message.startsWith("%FAILED ")) {
                SocketTestRunnerClient.this.extractFailure(arg, 2);
                return this;
            }
            if (message.startsWith("%RUNTIME")) {
                long elapsedTime = Long.parseLong(arg);
                SocketTestRunnerClient.this.testRunEnded(elapsedTime);
                return this;
            }
            if (message.startsWith("%TSTSTP ")) {
                long elapsedTime = Long.parseLong(arg);
                SocketTestRunnerClient.this.notifyTestRunStopped(elapsedTime);
                SocketTestRunnerClient.this.shutDown();
                return this;
            }
            if (message.startsWith("%TSTTREE")) {
                SocketTestRunnerClient.this.notifyTestTreeEntry(arg);
                return this;
            }
            if (message.startsWith("%TSTRERN")) {
                if (SocketTestRunnerClient.this.hasTestId()) {
                    SocketTestRunnerClient.this.scanReranMessage(arg);
                } else {
                    SocketTestRunnerClient.this.scanOldReranMessage(arg);
                }
                return this;
            }
            return this;
        }
    }

    public abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        public void handleException(Throwable exception) {
            DLTKTestingPlugin.log(exception);
        }
    }

    abstract class ProcessingState {
        ProcessingState() {
        }

        abstract ProcessingState readMessage(String var1);
    }

    private class ServerConnection
    extends Thread {
        int fServerPort;

        public ServerConnection(int port) {
            super("DLTK Testing Client Connection");
            this.fServerPort = port;
        }

        @Override
        public void run() {
            try {
                String message;
                if (SocketTestRunnerClient.this.fDebug) {
                    System.out.println("Creating server socket " + this.fServerPort);
                }
                SocketTestRunnerClient.this.fServerSocket = new ServerSocket(this.fServerPort);
                SocketTestRunnerClient.this.fSocket = SocketTestRunnerClient.this.fServerSocket.accept();
                SocketTestRunnerClient.this.fBufferedReader = new BufferedReader(new InputStreamReader(SocketTestRunnerClient.this.fSocket.getInputStream(), StandardCharsets.UTF_8));
                SocketTestRunnerClient.this.fWriter = new PrintWriter((Writer)new OutputStreamWriter(SocketTestRunnerClient.this.fSocket.getOutputStream(), StandardCharsets.UTF_8), true);
                while (SocketTestRunnerClient.this.fBufferedReader != null && (message = SocketTestRunnerClient.this.readMessage(SocketTestRunnerClient.this.fBufferedReader)) != null) {
                    SocketTestRunnerClient.this.receiveMessage(message);
                }
            }
            catch (SocketException e) {
                SocketTestRunnerClient.this.notifyTestRunTerminated();
            }
            catch (IOException e) {
                DLTKTestingPlugin.log(e);
            }
            SocketTestRunnerClient.this.shutDown();
        }
    }

    class TraceProcessingState
    extends AppendingProcessingState {
        TraceProcessingState() {
            super(SocketTestRunnerClient.this.fFailedTrace, "%TRACEE ");
        }

        @Override
        void entireStringRead() {
            SocketTestRunnerClient.this.notifyTestFailed();
            SocketTestRunnerClient.this.fExpectedResult.setLength(0);
            SocketTestRunnerClient.this.fActualResult.setLength(0);
        }

        @Override
        ProcessingState readMessage(String message) {
            if (message.startsWith("%TRACEE ")) {
                SocketTestRunnerClient.this.notifyTestFailed();
                SocketTestRunnerClient.this.fFailedTrace.setLength(0);
                SocketTestRunnerClient.this.fActualResult.setLength(0);
                SocketTestRunnerClient.this.fExpectedResult.setLength(0);
                return SocketTestRunnerClient.this.fDefaultState;
            }
            SocketTestRunnerClient.this.fFailedTrace.append(message).append('\n');
            return this;
        }
    }
}

