/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.log;

import org.eclipse.dltk.dbgp.IDbgpRawPacket;

public class ScriptDebugLogItem {
    private final long timestamp;
    private final String type;
    private final int sessionId;
    private final String message;

    public ScriptDebugLogItem(String type, String message) {
        this.timestamp = System.currentTimeMillis();
        this.type = type;
        this.sessionId = 0;
        this.message = message;
    }

    public ScriptDebugLogItem(String type, int sessionId, IDbgpRawPacket message) {
        this(System.currentTimeMillis(), type, sessionId, message);
    }

    public ScriptDebugLogItem(long timestamp, String type, int sessionId, IDbgpRawPacket message) {
        this.timestamp = timestamp;
        this.type = type;
        this.sessionId = sessionId;
        this.message = message.getPacketAsString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.valueOf(this.type) + '\t' + this.message;
    }
}

