/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.debug;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.cargo.core.CargoProjectTester;
import org.eclipse.corrosion.debug.DebugUtil;
import org.eclipse.corrosion.ui.InputComponent;
import org.eclipse.corrosion.ui.OptionalDefaultInputComponent;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class RustDebugTab
extends AbstractLaunchConfigurationTab {
    private InputComponent projectInput;
    private InputComponent buildInput;
    private OptionalDefaultInputComponent executableInput;
    private OptionalDefaultInputComponent workingDirectoryInput;
    private IProject project;
    private static CargoProjectTester tester = new CargoProjectTester();

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.corrosionBUILD_COMMAND", this.buildInput.getValue());
        configuration.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.projectInput.getValue());
        configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.executableInput.getValue());
        configuration.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", this.workingDirectoryInput.getValue());
        this.setDirty(false);
    }

    public void createControl(Composite parent) {
        Group container = new Group(parent, 2048);
        this.setControl((Control)container);
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo((Composite)container);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.projectInput = new InputComponent((Composite)container, Messages.LaunchUI_project, result -> {
            this.setDirty(true);
            this.setProject(this.projectInput.getValue());
            this.updateLaunchConfigurationDialog();
        });
        this.projectInput.createComponent();
        this.projectInput.createProjectSelection();
        ModifyListener updateListener = result -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        };
        this.buildInput = new InputComponent((Composite)container, Messages.RustDebugTab_buildCommand, updateListener);
        this.buildInput.createComponent();
        this.buildInput.createVariableSelection();
        this.executableInput = new OptionalDefaultInputComponent((Composite)container, Messages.RustDebugTab_Executable, updateListener, () -> DebugUtil.getDefaultExecutablePath(this.project));
        this.executableInput.createComponent();
        this.executableInput.createResourceSelection(() -> this.project);
        this.workingDirectoryInput = new OptionalDefaultInputComponent((Composite)container, Messages.LaunchUI_workingDirectory, updateListener, () -> this.getDefaultWorkingDirectoryPath());
        this.workingDirectoryInput.createComponent();
        this.workingDirectoryInput.createContainerSelection(() -> this.project);
    }

    private void setProject(String projectName) {
        this.project = projectName != null && !projectName.isEmpty() ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectName) : null;
        if (this.executableInput.getSelection()) {
            this.executableInput.setValue(DebugUtil.getDefaultExecutablePath(this.project));
        }
        if (this.workingDirectoryInput.getSelection()) {
            this.workingDirectoryInput.setValue(this.getDefaultWorkingDirectoryPath());
        }
    }

    private String getDefaultWorkingDirectoryPath() {
        if (this.project == null) {
            return "";
        }
        return this.project.getName();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.corrosionBUILD_COMMAND", "build");
        configuration.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        configuration.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.projectInput.setValue(configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", ""));
        }
        catch (CoreException ce) {
            this.projectInput.setValue("");
        }
        this.setProject(this.projectInput.getValue());
        try {
            this.buildInput.setValue(configuration.getAttribute("org.eclipse.corrosionBUILD_COMMAND", "build"));
        }
        catch (CoreException ce) {
            this.buildInput.setValue("build");
        }
        try {
            this.executableInput.setValue(configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", ""));
        }
        catch (CoreException ce) {
            this.executableInput.setValue("");
        }
        this.executableInput.updateSelection(this.executableInput.getValue().equals(DebugUtil.getDefaultExecutablePath(this.project)));
        try {
            this.workingDirectoryInput.setValue(configuration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", ""));
        }
        catch (CoreException ce) {
            this.workingDirectoryInput.setValue("");
        }
        this.workingDirectoryInput.updateSelection(this.workingDirectoryInput.getValue().equals(this.getDefaultWorkingDirectoryPath()));
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.canSave();
    }

    public boolean canSave() {
        if (this.project == null || !this.project.exists() || !tester.test(this.project, "isCargoProject", null, null)) {
            this.setErrorMessage(Messages.LaunchUI_invalidCargoProjectName);
            return false;
        }
        if (this.buildInput.getValue().isEmpty()) {
            this.setErrorMessage(Messages.RustDebugTab_cargoCommandConnotBeEmpty);
            return false;
        }
        if (this.executableInput.getValue().isEmpty()) {
            this.setErrorMessage(Messages.RustDebugTab_InvalidProjectExecutablePath);
            return false;
        }
        if (this.workingDirectoryInput.getValue().isEmpty()) {
            this.setErrorMessage(Messages.LaunchUI_invalidWorkingDirectory);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getName() {
        return Messages.LaunchUI_main;
    }
}

