/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractconstant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.ASTNodeFactoryFactory;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNodeFactory;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.dom.rewrite.DeclarationGenerator;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ClassMemberInserter;
import org.eclipse.cdt.internal.ui.refactoring.MethodContext;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.extractconstant.ExtractConstantInfo;
import org.eclipse.cdt.internal.ui.refactoring.extractconstant.ExtractConstantRefactoringDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.extractconstant.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.IdentifierHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.cdt.internal.ui.util.NameComposer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractConstantRefactoring
extends CRefactoring {
    private static final String PREFIX_FOR_NAME_WITH_LEADING_DIGIT = "_";
    public static final String ID = "org.eclipse.cdt.ui.refactoring.extractconstant.ExtractConstantRefactoring";
    private IASTExpression target;
    private final ExtractConstantInfo info = new ExtractConstantInfo();

    public ExtractConstantRefactoring(ICElement element, ISelection selection, ICProject project) {
        super(element, selection, project);
        this.name = Messages.ExtractConstantRefactoring_ExtractConst;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Collection<IASTLiteralExpression> literalExpressionCollection;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
        RefactoringStatus status = super.checkInitialConditions((IProgressMonitor)subMonitor.split(8));
        if (status.hasError()) {
            return status;
        }
        if (this.selectedRegion == null) {
            status.addFatalError(Messages.ExtractConstantRefactoring_LiteralMustBeSelected);
            return status;
        }
        IASTExpression selectedExpression = this.findSelectedExpression((IProgressMonitor)subMonitor.split(1));
        if (selectedExpression == null) {
            status.addFatalError(Messages.ExtractConstantRefactoring_LiteralMustBeSelected);
            return status;
        }
        if (!this.isExtractableExpression(selectedExpression)) {
            status.addFatalError(Messages.ExtractConstantRefactoring_LiteralMustBeSelected);
        }
        if ((literalExpressionCollection = this.findAllLiterals((IProgressMonitor)subMonitor.split(1))).isEmpty()) {
            status.addFatalError(Messages.ExtractConstantRefactoring_LiteralMustBeSelected);
            return status;
        }
        this.target = selectedExpression;
        if (this.info.getName().isEmpty()) {
            this.info.setName(this.getDefaultName(this.target));
        }
        this.info.setMethodContext(NodeHelper.findMethodContext((IASTNode)this.target, this.refactoringContext, (IProgressMonitor)subMonitor.split(1)));
        subMonitor.split(1);
        IScope containingScope = CPPVisitor.getContainingScope((IASTNode)this.target);
        IASTTranslationUnit ast = this.target.getTranslationUnit();
        this.info.setNameUsedChecker(name -> {
            IBinding[] bindingsForName = containingScope.find(name, ast);
            return bindingsForName.length != 0;
        });
        return status;
    }

    private IASTExpression findSelectedExpression(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        IASTTranslationUnit ast = this.getAST(this.tu, (IProgressMonitor)subMonitor.split(4));
        subMonitor.split(1);
        SelectedExpressionFinderVisitor expressionFinder = new SelectedExpressionFinderVisitor();
        ast.accept((ASTVisitor)expressionFinder);
        return expressionFinder.selectedExpression;
    }

    private boolean isExtractableExpression(IASTExpression expression) {
        if (expression instanceof IASTLiteralExpression) {
            return true;
        }
        if (expression instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExpression = (IASTUnaryExpression)expression;
            return this.isExtractableExpression(unaryExpression.getOperand());
        }
        if (expression instanceof IASTBinaryExpression) {
            IASTBinaryExpression binaryExpression = (IASTBinaryExpression)expression;
            return this.isExtractableExpression(binaryExpression.getOperand1()) && this.isExtractableExpression(binaryExpression.getOperand2());
        }
        return false;
    }

    private String getDefaultName(IASTExpression expression) {
        String nameString = expression.getRawSignature();
        NameComposer composer = ExtractConstantRefactoring.createNameComposer();
        String composedName = composer.compose(nameString);
        if (IdentifierHelper.isLeadingADigit(composedName)) {
            composedName = PREFIX_FOR_NAME_WITH_LEADING_DIGIT + composedName;
        }
        return composedName;
    }

    private static NameComposer createNameComposer() {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.constant.capitalization", 1, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.constant.wordDelimiter", PREFIX_FOR_NAME_WITH_LEADING_DIGIT, null);
        String prefix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.constant.prefix", "", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.constant.suffix", "", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        return composer;
    }

    private Collection<IASTLiteralExpression> findAllLiterals(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        final ArrayList<IASTLiteralExpression> result = new ArrayList<IASTLiteralExpression>();
        IASTTranslationUnit ast = this.getAST(this.tu, (IProgressMonitor)subMonitor.split(4));
        subMonitor.split(1);
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitExpressions = true;
            }

            public int visit(IASTExpression expression) {
                if (expression instanceof IASTLiteralExpression && (expression.getNodeLocations().length != 1 || !(expression.getNodeLocations()[0] instanceof IASTMacroExpansionLocation))) {
                    IASTLiteralExpression literal = (IASTLiteralExpression)expression;
                    result.add(literal);
                }
                return super.visit(expression);
            }
        });
        return result;
    }

    @Override
    protected void collectModifications(IProgressMonitor monitor, ModificationCollector collector) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        Collection<IASTExpression> expressionsToReplace = this.findExpressionsToExtract((IProgressMonitor)subMonitor.split(4));
        Collection<IASTExpression> expressionsToReplaceInSameContext = this.filterLiteralsInSameContext(expressionsToReplace, (IProgressMonitor)subMonitor.split(3));
        this.replaceLiteralsWithConstant(expressionsToReplaceInSameContext, collector, (IProgressMonitor)subMonitor.split(2));
        this.insertConstantDeclaration(collector, (IProgressMonitor)subMonitor.split(1));
    }

    private void insertConstantDeclaration(ModificationCollector collector, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        MethodContext context = this.info.getMethodContext();
        IASTTranslationUnit ast = this.getAST(this.tu, (IProgressMonitor)subMonitor.split(9));
        subMonitor.split(1);
        String constName = this.info.getName();
        if (context.getType() == MethodContext.ContextType.METHOD) {
            IASTDeclaration methodDeclaration = context.getMethodDeclaration();
            ICPPASTCompositeTypeSpecifier classDefinition = (ICPPASTCompositeTypeSpecifier)methodDeclaration.getParent();
            IASTDeclaration memberDeclaration = this.createConstantDeclarationForClass(constName);
            ClassMemberInserter.createChange(classDefinition, this.info.getVisibility(), (IASTNode)memberDeclaration, true, collector);
        } else {
            IASTDeclaration nodes = this.createGlobalConstantDeclaration(constName, ast.getASTNodeFactory());
            ASTRewrite rewriter = collector.rewriterForTranslationUnit(ast);
            TextEditGroup editGroup = new TextEditGroup(Messages.ExtractConstantRefactoring_CreateConstant);
            rewriter.insertBefore((IASTNode)ast, ExtractConstantRefactoring.getFirstNode(ast), (IASTNode)nodes, editGroup);
        }
    }

    private void replaceLiteralsWithConstant(Collection<IASTExpression> literals, ModificationCollector collector, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)literals.size());
        String constName = this.info.getName();
        for (IASTExpression each : literals) {
            subMonitor.split(1);
            IASTTranslationUnit translationUnit = each.getTranslationUnit();
            ASTRewrite rewrite = collector.rewriterForTranslationUnit(translationUnit);
            INodeFactory nodeFactory = translationUnit.getASTNodeFactory();
            IASTIdExpression idExpression = nodeFactory.newIdExpression(nodeFactory.newName(constName.toCharArray()));
            rewrite.replace((IASTNode)each, (IASTNode)idExpression, new TextEditGroup(Messages.ExtractConstantRefactoring_ReplaceLiteral));
        }
    }

    private Collection<IASTExpression> filterLiteralsInSameContext(Collection<IASTExpression> literalsToReplace, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        MethodContext context = this.info.getMethodContext();
        ArrayList<IASTExpression> locLiteralsToReplace = new ArrayList<IASTExpression>();
        if (context.getType() == MethodContext.ContextType.METHOD) {
            SubMonitor loopMonitor = subMonitor.split(literalsToReplace.size());
            for (IASTExpression expression : literalsToReplace) {
                MethodContext exprContext = NodeHelper.findMethodContext((IASTNode)expression, this.refactoringContext, (IProgressMonitor)loopMonitor.split(1));
                if (exprContext.getType() != MethodContext.ContextType.METHOD) continue;
                if (context.getMethodQName() != null) {
                    if (!MethodContext.isSameClass(exprContext.getMethodQName(), context.getMethodQName())) continue;
                    locLiteralsToReplace.add(expression);
                    continue;
                }
                if (!MethodContext.haveSameClass(exprContext, context)) continue;
                locLiteralsToReplace.add(expression);
            }
        } else {
            subMonitor.split(1);
            literalsToReplace.stream().filter(expr -> expr.getTranslationUnit().getOriginatingTranslationUnit() != null).collect(Collectors.toCollection(() -> locLiteralsToReplace));
        }
        return locLiteralsToReplace;
    }

    private Collection<IASTExpression> findExpressionsToExtract(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        final ArrayList<IASTExpression> result = new ArrayList<IASTExpression>();
        if (this.info.isReplaceAllOccurences()) {
            IASTTranslationUnit ast = this.getAST(this.tu, (IProgressMonitor)subMonitor.split(4));
            subMonitor.split(1);
            ast.accept(new ASTVisitor(){
                {
                    this.shouldVisitExpressions = true;
                }

                public int visit(IASTExpression expression) {
                    if (ExtractConstantRefactoring.isSameExpressionTree(expression, ExtractConstantRefactoring.this.target) && (expression.getNodeLocations().length != 1 || !(expression.getNodeLocations()[0] instanceof IASTMacroExpansionLocation))) {
                        result.add(expression);
                    }
                    return super.visit(expression);
                }
            });
        } else {
            subMonitor.split(5);
            result.add(this.target);
        }
        return result;
    }

    private static boolean isSameExpressionTree(IASTExpression expression1, IASTExpression expression2) {
        if (expression1 instanceof IASTLiteralExpression && expression2 instanceof IASTLiteralExpression) {
            IASTLiteralExpression literalExpression1 = (IASTLiteralExpression)expression1;
            IASTLiteralExpression literalExpression2 = (IASTLiteralExpression)expression2;
            return literalExpression1.getKind() == literalExpression2.getKind() && String.valueOf(expression1).equals(String.valueOf(expression2));
        }
        if (expression1 instanceof IASTUnaryExpression && expression2 instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExpression1 = (IASTUnaryExpression)expression1;
            IASTUnaryExpression unaryExpression2 = (IASTUnaryExpression)expression2;
            if (unaryExpression1.getOperator() == unaryExpression2.getOperator()) {
                return ExtractConstantRefactoring.isSameExpressionTree(unaryExpression1.getOperand(), unaryExpression2.getOperand());
            }
        }
        if (expression1 instanceof IASTBinaryExpression && expression2 instanceof IASTBinaryExpression) {
            IASTBinaryExpression binaryExpression1 = (IASTBinaryExpression)expression1;
            IASTBinaryExpression binaryExpression2 = (IASTBinaryExpression)expression2;
            if (binaryExpression1.getOperator() == binaryExpression2.getOperator()) {
                return ExtractConstantRefactoring.isSameExpressionTree(binaryExpression1.getOperand1(), binaryExpression2.getOperand1()) && ExtractConstantRefactoring.isSameExpressionTree(binaryExpression1.getOperand2(), binaryExpression2.getOperand2());
            }
        }
        return false;
    }

    private static IASTNode getFirstNode(IASTTranslationUnit ast) {
        IASTDeclaration[] declarations = ast.getDeclarations();
        return Arrays.stream(declarations).filter(decl -> decl.isPartOfTranslationUnitFile()).findFirst().orElse(null);
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        Map<String, String> arguments = this.getArgumentMap();
        ExtractConstantRefactoringDescriptor desc = new ExtractConstantRefactoringDescriptor(this.project.getProject().getName(), "Extract Constant Refactoring", "Create constant for " + this.target.getRawSignature(), arguments);
        return desc;
    }

    private Map<String, String> getArgumentMap() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("fileName", this.tu.getLocationURI().toString());
        arguments.put("selection", String.valueOf(this.selectedRegion.getOffset()) + "," + this.selectedRegion.getLength());
        arguments.put("name", this.info.getName());
        arguments.put("visibility", this.info.getVisibility().toString());
        arguments.put("replaceAll", Boolean.toString(this.info.isReplaceAllOccurences()));
        return arguments;
    }

    private IASTSimpleDeclaration createConstantDeclaration(String newName) {
        ICPPNodeFactory factory = ASTNodeFactoryFactory.getDefaultCPPNodeFactory();
        DeclarationGenerator generator = DeclarationGenerator.create((INodeFactory)factory);
        IType type = this.target.getExpressionType();
        IASTDeclSpecifier declSpec = generator.createDeclSpecFromType(type);
        declSpec.setConst(true);
        IASTDeclarator declarator = generator.createDeclaratorFromType(type, newName.toCharArray());
        IASTSimpleDeclaration simple = factory.newSimpleDeclaration(declSpec);
        IASTEqualsInitializer init = factory.newEqualsInitializer((IASTInitializerClause)this.target.copy());
        declarator.setInitializer((IASTInitializer)init);
        simple.addDeclarator(declarator);
        return simple;
    }

    private IASTDeclaration createGlobalConstantDeclaration(String newName, INodeFactory nodeFactory) {
        IASTSimpleDeclaration simple = this.createConstantDeclaration(newName);
        if (nodeFactory instanceof ICPPNodeFactory) {
            ICPPASTNamespaceDefinition namespace = ((ICPPNodeFactory)nodeFactory).newNamespaceDefinition(nodeFactory.newName());
            namespace.addDeclaration((IASTDeclaration)simple);
            return namespace;
        }
        simple.getDeclSpecifier().setStorageClass(3);
        return simple;
    }

    private IASTDeclaration createConstantDeclarationForClass(String newName) {
        IASTSimpleDeclaration simple = this.createConstantDeclaration(newName);
        simple.getDeclSpecifier().setStorageClass(3);
        return simple;
    }

    public ExtractConstantInfo getRefactoringInfo() {
        return this.info;
    }

    private final class SelectedExpressionFinderVisitor
    extends ASTVisitor {
        private IASTExpression selectedExpression;

        private SelectedExpressionFinderVisitor() {
            this.shouldVisitExpressions = true;
        }

        public int visit(IASTExpression expression) {
            if (SelectionHelper.nodeMatchesSelection((IASTNode)expression, (IRegion)ExtractConstantRefactoring.this.selectedRegion)) {
                this.selectedExpression = expression;
                return 2;
            }
            if (expression instanceof IASTLiteralExpression && SelectionHelper.isSelectionInsideNode((IASTNode)expression, (IRegion)ExtractConstantRefactoring.this.selectedRegion)) {
                this.selectedExpression = expression;
                return 2;
            }
            return super.visit(expression);
        }
    }
}

