/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.core.cxx.model.AbstractAstFunctionChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.model.cfg.IBasicBlock;
import org.eclipse.cdt.codan.core.model.cfg.ICfgData;
import org.eclipse.cdt.codan.core.model.cfg.IControlFlowGraph;
import org.eclipse.cdt.codan.core.model.cfg.IExitNode;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.codan.internal.core.cfg.ControlFlowGraph;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLambdaExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.core.resources.IResource;

public class ReturnChecker
extends AbstractAstFunctionChecker {
    public static final String PARAM_IMPLICIT = "implicit";
    public static final String RET_NO_VALUE_ID = "org.eclipse.cdt.codan.checkers.noreturn";
    public static final String RET_ERR_VALUE_ID = "org.eclipse.cdt.codan.checkers.errreturnvalue";
    public static final String RET_NORET_ID = "org.eclipse.cdt.codan.checkers.errnoreturn";
    private IType cachedReturnType = null;

    public boolean isConstructorDestructor(IASTFunctionDefinition func) {
        IBinding method;
        return func instanceof ICPPASTFunctionDefinition && ((method = func.getDeclarator().getName().resolveBinding()) instanceof ICPPConstructor || method instanceof ICPPMethod && ((ICPPMethod)method).isDestructor());
    }

    public boolean isMain(IASTFunctionDefinition func) {
        try {
            char[] functionName = func.getDeclarator().getName().getSimpleID();
            if (CharArrayUtils.equals((char[])functionName, (String)"main")) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    protected void processFunction(IASTFunctionDefinition func) {
        IASTStatement body;
        this.cachedReturnType = null;
        if (func.getParent() instanceof ICPPASTTemplateDeclaration) {
            return;
        }
        ReturnStmpVisitor visitor = new ReturnStmpVisitor(func);
        func.accept((ASTVisitor)visitor);
        boolean nonVoid = this.isNonVoid(func);
        if (nonVoid && !this.isMain(func) && (body = func.getBody()) instanceof IASTCompoundStatement) {
            IASTStatement[] statements = ((IASTCompoundStatement)body).getStatements();
            if (statements.length > 0) {
                IASTStatement last = statements[statements.length - 1];
                while (last instanceof IASTLabelStatement) {
                    last = ((IASTLabelStatement)last).getNestedStatement();
                }
                if (this.isCompoundStatement(last)) {
                    if (this.endsWithNoExitNode(func)) {
                        this.reportNoRet(func, visitor.hasret);
                    }
                } else if (!this.isFuncExitStatement(last) && !this.isInDeadCode(func, last)) {
                    this.reportNoRet(func, visitor.hasret);
                }
            } else {
                this.reportNoRet(func, false);
            }
        }
    }

    private boolean isInDeadCode(IASTFunctionDefinition func, IASTStatement last) {
        Collection<IBasicBlock> deadBlocks = this.getDeadBlocks(func);
        for (IBasicBlock bb : deadBlocks) {
            if (((ICfgData)bb).getData() != last) continue;
            return true;
        }
        return false;
    }

    public Collection<IBasicBlock> getDeadBlocks(IASTFunctionDefinition func) {
        IControlFlowGraph graph = this.getModelCache().getControlFlowGraph(func);
        return ((ControlFlowGraph)graph).getDeadNodes();
    }

    protected void reportNoRet(IASTFunctionDefinition func, boolean hasRet) {
        if (!(hasRet || this.checkImplicitReturn(RET_NORET_ID) || this.isExplicitReturn(func))) {
            return;
        }
        this.reportProblem(RET_NORET_ID, (IASTNode)func.getDeclSpecifier(), new Object[0]);
    }

    private boolean isCompoundStatement(IASTStatement last) {
        return last instanceof IASTIfStatement || last instanceof IASTWhileStatement || last instanceof IASTDoStatement || last instanceof IASTForStatement || last instanceof IASTSwitchStatement || last instanceof IASTCompoundStatement || last instanceof ICPPASTTryBlockStatement;
    }

    protected boolean isFuncExitStatement(IASTStatement statement) {
        return statement instanceof IASTReturnStatement || CxxAstUtils.isThrowStatement((IASTNode)statement) || CxxAstUtils.isExitStatement((IASTNode)statement);
    }

    protected boolean checkImplicitReturn(String id) {
        IProblem pt = this.getProblemById(id, (IResource)this.getFile());
        return (Boolean)this.getPreference(pt, PARAM_IMPLICIT);
    }

    protected boolean endsWithNoExitNode(IASTFunctionDefinition func) {
        IControlFlowGraph graph = this.getModelCache().getControlFlowGraph(func);
        Iterator exitNodeIterator = graph.getExitNodeIterator();
        while (exitNodeIterator.hasNext()) {
            Collection<IBasicBlock> deadBlocks;
            IExitNode node = (IExitNode)exitNodeIterator.next();
            Object astNode = ((ICfgData)node).getData();
            if (astNode != null || (deadBlocks = this.getDeadBlocks(func)).contains(node)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExplicitReturn(IASTFunctionDefinition func) {
        IASTDeclSpecifier declSpecifier = func.getDeclSpecifier();
        return !(declSpecifier instanceof IASTSimpleDeclSpecifier) || ((IASTSimpleDeclSpecifier)declSpecifier).getType() != 0;
    }

    private boolean isNonVoid(IASTFunctionDefinition func) {
        if (this.isConstructorDestructor(func)) {
            return false;
        }
        return !this.isVoid(this.getReturnType(func));
    }

    private IType getReturnType(IASTFunctionDefinition func) {
        if (this.cachedReturnType == null) {
            this.cachedReturnType = CxxAstUtils.getReturnType((IASTFunctionDefinition)func);
        }
        return this.cachedReturnType;
    }

    public boolean isVoid(IType type) {
        return type instanceof IBasicType && ((IBasicType)type).getKind() == IBasicType.Kind.eVoid;
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        if (problem.getId().equals(RET_NO_VALUE_ID) || problem.getId().equals(RET_NORET_ID)) {
            this.addPreference(problem, PARAM_IMPLICIT, CheckersMessages.ReturnChecker_Param0, Boolean.FALSE);
        }
    }

    class ReturnStmpVisitor
    extends ASTVisitor {
        private final IASTFunctionDefinition func;
        boolean hasret;

        ReturnStmpVisitor(IASTFunctionDefinition func) {
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.func = func;
            this.hasret = false;
        }

        public int visit(IASTDeclaration element) {
            if (element != this.func) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTExpression expr) {
            if (expr instanceof ICPPASTLambdaExpression) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof IASTReturnStatement) {
                IASTReturnStatement ret = (IASTReturnStatement)stmt;
                IASTInitializerClause returnValue = ret.getReturnArgument();
                if (returnValue != null) {
                    this.hasret = true;
                }
                if (ReturnChecker.this.isNonVoid(this.func) && !ReturnChecker.this.isConstructorDestructor(this.func)) {
                    if ((ReturnChecker.this.checkImplicitReturn(ReturnChecker.RET_NO_VALUE_ID) || ReturnChecker.this.isExplicitReturn(this.func)) && returnValue == null) {
                        ReturnChecker.this.reportProblem(ReturnChecker.RET_NO_VALUE_ID, (IASTNode)ret, new Object[0]);
                    }
                } else if (returnValue instanceof IASTExpression) {
                    IType type = ((IASTExpression)returnValue).getExpressionType();
                    if (ReturnChecker.this.isVoid(type)) {
                        return 1;
                    }
                    ReturnChecker.this.reportProblem(ReturnChecker.RET_ERR_VALUE_ID, (IASTNode)returnValue, new Object[0]);
                }
                return 1;
            }
            return 3;
        }
    }
}

