/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.util.widget;

import java.io.File;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.ui.internal.i18n.UiMessages;
import org.eclipse.buildship.ui.internal.util.file.DirectoryDialogSelectionListener;
import org.eclipse.buildship.ui.internal.util.font.FontUtils;
import org.eclipse.buildship.ui.internal.util.widget.HoverText;
import org.eclipse.buildship.ui.internal.util.widget.UiBuilder;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class GradleUserHomeGroup
extends Group {
    private final Font defaultFont;
    private final UiBuilder.UiBuilderFactory builderFactory;
    private Text gradleUserHomeText;
    private Button gradleUserHomeBrowseButton;
    private Label warningLabel;

    public GradleUserHomeGroup(Composite parent) {
        super(parent, 0);
        this.setText(CoreMessages.Preference_Label_GradleUserHome);
        this.defaultFont = FontUtils.getDefaultDialogFont();
        this.builderFactory = new UiBuilder.UiBuilderFactory(this.defaultFont);
        this.setLayoutData(new GridData(4, 128, true, false));
        this.setLayout((Layout)new GridLayout(3, false));
        this.gradleUserHomeText = this.builderFactory.newText((Composite)this).alignFillHorizontal().control();
        this.gradleUserHomeBrowseButton = this.builderFactory.newButton((Composite)this).alignLeft().text(UiMessages.Button_Label_Browse).control();
        this.warningLabel = this.builderFactory.newLabel((Composite)this).alignLeft().control();
        this.warningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        HoverText.createAndAttach((Control)this.warningLabel, NLS.bind((String)CoreMessages.WarningMessage_Using_0_NonPortable, (Object)"Gradle user home"));
        this.addListeners();
    }

    private void addListeners() {
        this.gradleUserHomeBrowseButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(this.getShell(), this.gradleUserHomeText, CoreMessages.Preference_Label_GradleUserHome));
    }

    public Text getGradleUserHomeText() {
        return this.gradleUserHomeText;
    }

    protected void checkSubclass() {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEnablement();
    }

    private void updateEnablement() {
        boolean groupEnabled = this.getEnabled();
        this.gradleUserHomeText.setEnabled(groupEnabled);
        this.gradleUserHomeBrowseButton.setEnabled(groupEnabled);
    }

    public File getGradleUserHome() {
        String gradleUserHomeString = this.gradleUserHomeText.getText();
        return gradleUserHomeString.isEmpty() ? null : new File(gradleUserHomeString);
    }

    public void setGradleUserHome(File gradleUserHome) {
        if (gradleUserHome == null) {
            this.gradleUserHomeText.setText("");
        } else {
            this.gradleUserHomeText.setText(gradleUserHome.getPath());
        }
    }

    public void dispose() {
        if (this.defaultFont != null && !this.defaultFont.isDisposed()) {
            this.defaultFont.dispose();
        }
        super.dispose();
    }
}

