/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.modeler.core.utils.AnchorSite;
import org.eclipse.graphiti.mm.algorithms.styles.Point;

public enum Direction {
    NONE,
    UP,
    DOWN,
    LEFT,
    RIGHT;


    public static Direction get(Point start, Point end) {
        return Direction.get(start, end, false);
    }

    public static Direction get(Point start, Point end, boolean exact) {
        int dx = start.getX() - end.getX();
        int dy = start.getY() - end.getY();
        if (dy == 0) {
            if (dx > 0) {
                return LEFT;
            }
            if (dx < 0) {
                return RIGHT;
            }
        } else if (dx == 0) {
            if (dy > 0) {
                return UP;
            }
            if (dy < 0) {
                return DOWN;
            }
        }
        if (!exact) {
            if (dy > 0) {
                if (dx > 0) {
                    if (Math.abs(dx) > Math.abs(dy)) {
                        return LEFT;
                    }
                    return UP;
                }
                if (dx < 0) {
                    if (Math.abs(dx) > Math.abs(dy)) {
                        return RIGHT;
                    }
                    return UP;
                }
            } else if (dy < 0) {
                if (dx > 0) {
                    if (Math.abs(dx) > Math.abs(dy)) {
                        return LEFT;
                    }
                    return DOWN;
                }
                if (dx < 0) {
                    if (Math.abs(dx) > Math.abs(dy)) {
                        return RIGHT;
                    }
                    return DOWN;
                }
            }
        }
        return NONE;
    }

    public static Direction get(Direction oldDirection, Point start, Point end) {
        int dx = start.getX() - end.getX();
        int dy = start.getY() - end.getY();
        if (dy == 0) {
            if (dx > 0) {
                return LEFT;
            }
            if (dx < 0) {
                return RIGHT;
            }
        } else if (dx == 0) {
            if (dy > 0) {
                return UP;
            }
            if (dy < 0) {
                return DOWN;
            }
        } else if (dy > 0) {
            if (dx > 0) {
                if (oldDirection == LEFT || oldDirection == UP) {
                    return oldDirection;
                }
                if (Math.abs(dx) > Math.abs(dy)) {
                    return LEFT;
                }
                return UP;
            }
            if (dx < 0) {
                if (oldDirection == RIGHT || oldDirection == UP) {
                    return oldDirection;
                }
                if (Math.abs(dx) > Math.abs(dy)) {
                    return RIGHT;
                }
                return UP;
            }
        } else if (dy < 0) {
            if (dx > 0) {
                if (oldDirection == LEFT || oldDirection == DOWN) {
                    return oldDirection;
                }
                if (Math.abs(dx) > Math.abs(dy)) {
                    return LEFT;
                }
                return DOWN;
            }
            if (dx < 0) {
                if (oldDirection == RIGHT || oldDirection == DOWN) {
                    return oldDirection;
                }
                if (Math.abs(dx) > Math.abs(dy)) {
                    return RIGHT;
                }
                return DOWN;
            }
        }
        return NONE;
    }

    public static Direction get(AnchorSite site) {
        switch (site) {
            case TOP: {
                return UP;
            }
            case BOTTOM: {
                return DOWN;
            }
            case LEFT: {
                return LEFT;
            }
            case RIGHT: {
                return RIGHT;
            }
        }
        return NONE;
    }

    public static Direction reverse(Direction direction) {
        switch (direction) {
            case DOWN: {
                return UP;
            }
            case UP: {
                return DOWN;
            }
            case RIGHT: {
                return LEFT;
            }
            case LEFT: {
                return RIGHT;
            }
        }
        return NONE;
    }

    public boolean isHorizontal() {
        return this == LEFT || this == RIGHT;
    }

    public boolean isVertical() {
        return this == UP || this == DOWN;
    }

    public boolean parallel(Direction that) {
        return this.isHorizontal() && that.isHorizontal() || this.isVertical() && that.isVertical();
    }
}

