/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.extension.IEditputProvider;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class IDEEditputProvider
implements IEditputProvider {
    public IEditorInput createEditorInput(Object file) {
        if (file instanceof File) {
            File handle = (File)file;
            String fileName = handle.getAbsolutePath();
            IWorkspace space = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = space.getRoot();
            try {
                IFile[] resources = root.findFilesForLocationURI(new File(fileName).toURI());
                if (resources != null && resources.length > 0) {
                    FileEditorInput input = new FileEditorInput(resources[0]);
                    return input;
                }
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(fileName));
                IFileInfo fetchInfo = fileStore.fetchInfo();
                if (!fetchInfo.isDirectory() && fetchInfo.exists()) {
                    return new FileStoreEditorInput(fileStore);
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }
}

